/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.enums.bill;

import kd.bos.util.StringUtils;
import kd.wtc.wtbs.common.MultiLangEnumBridge;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;

public enum PlanSceneEnum {
    VP("vp", "wtc_scene_vacation_v2", new MultiLangEnumBridge("\u4f11\u5047\u65b9\u6848", "PlanSceneEnum_0", "wtc-wtbs-common")),
    TP("tp", "wtc_scene_tp_v2", new MultiLangEnumBridge("{0}\u65b9\u6848", "PlanSceneEnum_1", "wtc-wtbs-common", new Object[]{BillTypeEnum.EVECTIONBILL})),
    OTP("otp", "wtc_scene_otp_v2", new MultiLangEnumBridge("\u52a0\u73ed\u65b9\u6848", "PlanSceneEnum_2", "wtc-wtbs-common")),
    AD("ad", "wtc_scene_ad_v2", new MultiLangEnumBridge("\u8865\u7b7e\u65b9\u6848", "PlanSceneEnum_3", "wtc-wtbs-common")),
    SWS("sws", "wtc_scene_swshift", new MultiLangEnumBridge("\u8c03\u73ed\u65b9\u6848", "PlanSceneEnum_4", "wtc-wtbs-common"));

    private final String planFlag;
    private final String sceneNumber;
    private final MultiLangEnumBridge planName;

    private PlanSceneEnum(String planFlag, String sceneNumber, MultiLangEnumBridge planName) {
        this.planFlag = planFlag;
        this.sceneNumber = sceneNumber;
        this.planName = planName;
    }

    public String getPlanFlag() {
        return this.planFlag;
    }

    public String getSceneNumber() {
        return this.sceneNumber;
    }

    public String getPlanName() {
        return this.planName.loadKDString();
    }

    public static String getSceneNumberByPlanFlag(String planFlag) {
        PlanSceneEnum planEnum = PlanSceneEnum.getPlanEnum(planFlag);
        if (planEnum == null) {
            return StringUtils.getEmpty();
        }
        return planEnum.sceneNumber;
    }

    public static PlanSceneEnum getPlanEnum(String key) {
        PlanSceneEnum[] planEnumArr;
        for (PlanSceneEnum planEnum : planEnumArr = PlanSceneEnum.values()) {
            if (!planEnum.getPlanFlag().equals(key)) continue;
            return planEnum;
        }
        return null;
    }
}

