/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.enums.file;

import java.util.ArrayList;
import java.util.List;
import kd.wtc.wtbs.common.MultiLangEnumBridge;

public enum FileTypeEnum {
    ATTFILE("3", "wtp_attfilebase", new MultiLangEnumBridge("\u8003\u52e4\u6863\u6848", "FileF7Enum_1", "wtc-wtbs-common")),
    VCFILE("2", "wtp_vafilebase", new MultiLangEnumBridge("\u5047\u671f\u6863\u6848", "FileF7Enum_2", "wtc-wtbs-common")),
    ALLFILE("1", "", new MultiLangEnumBridge("\u8003\u52e4\u6863\u6848\u548c\u5047\u671f\u6863\u6848", "FileF7Enum_3", "wtc-wtbs-common"));

    private String fileType;
    private String pageId;
    private MultiLangEnumBridge description;

    private FileTypeEnum(String fileType, String pageId, MultiLangEnumBridge description) {
        this.fileType = fileType;
        this.pageId = pageId;
        this.description = description;
    }

    public String getFileType() {
        return this.fileType;
    }

    public MultiLangEnumBridge getDescription() {
        return this.description;
    }

    public String getPageId() {
        return this.pageId;
    }

    public static List<String> getFileTypeByPageId(String pageId) {
        ArrayList<String> fileTypeList = new ArrayList<String>(10);
        fileTypeList.add(ATTFILE.getFileType());
        switch (pageId) {
            case "wtp_attfilebase": {
                fileTypeList.add(ALLFILE.getFileType());
                break;
            }
            case "wtp_vafilebase": {
                fileTypeList.add(VCFILE.getFileType());
                break;
            }
        }
        return fileTypeList;
    }

    public static FileTypeEnum of(String fileType) {
        FileTypeEnum[] fileTypeEnums;
        for (FileTypeEnum fileTypeEnum : fileTypeEnums = FileTypeEnum.values()) {
            if (!fileTypeEnum.getFileType().equals(fileType)) continue;
            return fileTypeEnum;
        }
        return ALLFILE;
    }
}

