/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.helper;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.wtc.wtbs.common.bean.WTCBeanFactory;
import kd.wtc.wtbs.common.bean.WTCBeanFactoryDefault;
import kd.wtc.wtbs.common.config.WTCProjectConfigHelper;
import kd.wtc.wtbs.common.lang.WTCException;
import kd.wtc.wtbs.common.param.WTCAppParam;
import kd.wtc.wtbs.common.param.WTCParam;
import kd.wtc.wtbs.common.param.WTCProjectParam;
import kd.wtc.wtbs.common.param.WTCSystemParam;

public class WTCAppContextHelper {
    private static final WTCBeanFactory BEAN_FACTORY = WTCAppContextHelper.initFactory();

    public static <T> T getBean(String beanClassFullName, Class<T> beanType) {
        Object bean = BEAN_FACTORY.getBean(beanClassFullName);
        return WTCAppContextHelper.castBean(beanType, bean);
    }

    public static <T> T getBean(Class<? extends T> beanClass) {
        T bean = BEAN_FACTORY.getBean(beanClass);
        return WTCAppContextHelper.castBean(beanClass, bean);
    }

    private static <T> T castBean(Class<T> beanType, Object bean) {
        if (bean == null) {
            throw new WTCException("can not find bean,beanClass:" + beanType.getName());
        }
        if (beanType.isInstance(bean)) {
            return beanType.cast(bean);
        }
        String msg = "Bean type mismatch, expected: " + beanType.getName() + ", actual: " + bean.getClass().getName();
        throw new WTCException(msg);
    }

    private static WTCBeanFactory initFactory() {
        String factoryClassName = WTCProjectConfigHelper.getProjectConfig().getBeanFactoryClassName();
        if (StringUtils.isBlank((CharSequence)factoryClassName) || StringUtils.equals((CharSequence)WTCBeanFactoryDefault.class.getName(), (CharSequence)factoryClassName)) {
            return new WTCBeanFactoryDefault();
        }
        return WTCAppContextHelper.createByClassName(factoryClassName);
    }

    private static WTCBeanFactory createByClassName(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (WTCBeanFactory)clazz.newInstance();
        }
        catch (Exception e) {
            throw new WTCException(e, "Can't Create WTCBeanFactory by Class:" + className);
        }
    }

    public static WTCParam getProjectParams() {
        return WTCAppContextHelper.getBean(WTCProjectParam.class);
    }

    public static WTCParam getSysParams() {
        return WTCAppContextHelper.getBean(WTCSystemParam.class);
    }

    public static WTCParam getAppParams(AppParam appParam) {
        WTCAppParam wtcAppParam = WTCAppContextHelper.getBean(WTCAppParam.class);
        if (null == wtcAppParam) {
            throw new NullPointerException("WTCAppParam");
        }
        wtcAppParam.load(appParam);
        return wtcAppParam;
    }

    public static WTCParam getAppParams() {
        long orgId = RequestContext.get().getOrgId();
        String appId = AppMetadataCache.getAppInfo((String)"wtp").getId();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        return WTCAppContextHelper.getAppParams(appParam);
    }
}

