/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.i18n;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.IFormat;
import kd.bos.service.ITimeService;
import kd.bos.service.InteTimeZone;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.inte.InteServiceHelper;

public class WtcInterDateTimeUtil {
    private static final ITimeService TIME_SERVICE = new TimeService();

    private static ITimeService getITimeService() {
        return TIME_SERVICE;
    }

    public static String getUserDateFormat(Long userId) {
        return InteServiceHelper.getDateFormat((Long)userId);
    }

    public static Map<String, String> getUserTimeFormat(Long userId) {
        return InteServiceHelper.getTimeFormat((Long)userId);
    }

    public static FormatObject getUserFormat(Long userId) {
        return InteServiceHelper.getUserFormat((Long)userId);
    }

    public static InteTimeZone getUserTimezone(Long userId) {
        return WtcInterDateTimeUtil.getITimeService().getUserTimeZone(userId);
    }

    public static InteTimeZone getSysTimeZone() {
        return WtcInterDateTimeUtil.getITimeService().getSysTimeZone();
    }

    public static String formatUserDateTime(Date dateTime) {
        long currUserId = RequestContext.get().getCurrUserId();
        IFormat format = FormatFactory.get((FormatTypes)FormatTypes.Time);
        FormatObject formatObject = InteServiceHelper.getUserFormat((Long)currUserId);
        InteTimeZone timeZone = WtcInterDateTimeUtil.getUserTimezone(currUserId);
        if (formatObject != null && formatObject.isTimeNotEmpty()) {
            formatObject.getTimeFormat().setTimeArea(timeZone.getTimeArea());
            formatObject.getDateFormat().setTimeArea(timeZone.getTimeArea());
        }
        return format.getFormat(formatObject).format(dateTime);
    }

    public static SimpleDateFormat getDateTimeFormat(Long userId) {
        IFormat format = FormatFactory.get((FormatTypes)FormatTypes.Time);
        FormatObject formatObject = WtcInterDateTimeUtil.getUserFormat(userId);
        return (SimpleDateFormat)format.getFormat(formatObject);
    }
}

