/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.model;

import java.util.ArrayList;
import java.util.List;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.WTCCollections;

public class BillResponse {
    private boolean success;
    private List<String> message;
    private Object data;
    private Object failData;

    public BillResponse() {
    }

    public BillResponse(boolean success, List<String> messages, Object data) {
        this.success = success;
        this.message = messages;
        this.data = data;
    }

    public static BillResponse success() {
        BillResponse billResponse = new BillResponse();
        billResponse.setSuccess(true);
        return billResponse;
    }

    public static BillResponse success(Object data) {
        BillResponse billResponse = new BillResponse();
        billResponse.setSuccess(true);
        billResponse.setData(data);
        return billResponse;
    }

    public static BillResponse success(Object data, List<String> messages) {
        BillResponse billResponse = new BillResponse();
        billResponse.setSuccess(true);
        billResponse.setData(data);
        billResponse.setMessage(messages);
        return billResponse;
    }

    public static BillResponse error(Object data, List<String> message) {
        BillResponse billResponse = new BillResponse();
        billResponse.setData(data);
        billResponse.setMessage(message);
        billResponse.setSuccess(false);
        return billResponse;
    }

    public static BillResponse emptyIsSuccess(String errMsg) {
        if (HRStringUtils.isEmpty((String)errMsg)) {
            return BillResponse.success();
        }
        ArrayList<String> msgs = new ArrayList<String>(10);
        msgs.add(errMsg);
        return BillResponse.error(null, msgs);
    }

    public String topErrMsg() {
        if (WTCCollections.isEmpty(this.message)) {
            return "";
        }
        return this.message.get(0);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public List<String> getMessage() {
        if (this.message == null) {
            this.message = new ArrayList<String>(10);
        }
        return this.message;
    }

    public void setMessage(List<String> message) {
        this.message = message;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getFailData() {
        return this.failData;
    }

    public void setFailData(Object failData) {
        this.failData = failData;
    }
}

