/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.model.customcontrol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.wtc.wtbs.common.enums.DatePickerEnum;
import kd.wtc.wtbs.common.model.customcontrol.DatePickerStepVo;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class DatePickerModel
implements Serializable {
    private static final long serialVersionUID = 9024883614552994745L;
    private String event;
    private List<Date> dateValue;
    List<DatePickerStepVo> shortcuts;
    private String today;
    private String dateFormat;
    private int firstDayOfWeek = 7;
    private boolean disabled;

    public List<Date> getDateValue() {
        return this.dateValue;
    }

    public void setDateValue(List<Date> dateValue) {
        this.dateValue = dateValue;
    }

    public List<DatePickerStepVo> getShortcuts() {
        return this.shortcuts;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setShortcuts(List<DatePickerStepVo> shortcuts) {
        this.shortcuts = shortcuts;
    }

    public DatePickerModel(List<Date> dateValue, List<DatePickerStepVo> shortcuts) {
        this.dateValue = dateValue;
        this.shortcuts = shortcuts;
    }

    public DatePickerModel() {
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getToday() {
        return this.today;
    }

    public void setToday(String today) {
        this.today = today;
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public static DatePickerModel setDatePickerModel(Date startDate, Date endDate) {
        DatePickerModel datePickerModel = new DatePickerModel();
        ArrayList<Date> dateValue = Lists.newArrayListWithExpectedSize(2);
        if (startDate != null) {
            dateValue.add(startDate);
        }
        if (endDate != null) {
            dateValue.add(endDate);
        }
        datePickerModel.setDateValue(dateValue);
        ArrayList<DatePickerStepVo> shortcuts = Lists.newArrayListWithExpectedSize(16);
        Date userDate = WTCInteDateUtil.getUserDate(new Date());
        int userFirstDayOfWeek = WTCInteDateUtil.getUserFirstDayOfWeek();
        int firstDayOfWeekInCalendar = WTCDateUtils.getDayOfWeekInCalendar(userFirstDayOfWeek);
        shortcuts.add(new DatePickerStepVo(DatePickerEnum.LASTWEEK.getDescription(), Lists.newArrayList(WTCDateUtils.getBeginDayOfLastWeek(userDate, firstDayOfWeekInCalendar), WTCDateUtils.getEndDayOfLastWeek(userDate, firstDayOfWeekInCalendar)), DatePickerEnum.LASTWEEK.getIndex()));
        shortcuts.add(new DatePickerStepVo(DatePickerEnum.CURWEEK.getDescription(), Lists.newArrayList(WTCDateUtils.getBeginDayOfWeek(userDate, firstDayOfWeekInCalendar), WTCDateUtils.getEndDayOfWeek(userDate, firstDayOfWeekInCalendar)), DatePickerEnum.CURWEEK.getIndex()));
        shortcuts.add(new DatePickerStepVo(DatePickerEnum.NEXTWEEK.getDescription(), Lists.newArrayList(WTCDateUtils.getBeginDayOfNextWeek(userDate, firstDayOfWeekInCalendar), WTCDateUtils.getEndDayOfNextWeek(userDate, firstDayOfWeekInCalendar)), DatePickerEnum.NEXTWEEK.getIndex()));
        shortcuts.add(new DatePickerStepVo(DatePickerEnum.YESTERDAY.getDescription(), Lists.newArrayList(WTCDateUtils.getYesterday(userDate), WTCDateUtils.getYesterday(userDate)), DatePickerEnum.YESTERDAY.getIndex()));
        shortcuts.add(new DatePickerStepVo(DatePickerEnum.TODAY.getDescription(), Lists.newArrayList(WTCDateUtils.getZeroDate(userDate), WTCDateUtils.getZeroDate(userDate)), DatePickerEnum.TODAY.getIndex()));
        datePickerModel.setShortcuts(shortcuts);
        datePickerModel.setEvent("init");
        datePickerModel.setToday(WTCDateUtils.date2Str(userDate, "yyyy-MM-dd HH:mm:ss"));
        datePickerModel.setFirstDayOfWeek(userFirstDayOfWeek == 0 ? 7 : userFirstDayOfWeek);
        datePickerModel.setDateFormat(WTCInteDateUtil.getUserDateFormat());
        return datePickerModel;
    }
}

