/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.model.evaluation;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.model.common.DateType;
import kd.wtc.wtbs.common.model.evaluation.ShiftDetail;
import kd.wtc.wtbs.common.model.evaluation.ShiftInfoVo;
import kd.wtc.wtbs.common.model.evaluation.ShiftMiddleRule;
import kd.wtc.wtbs.common.model.sign.TakeCardRule;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;

public class Shift
implements Serializable {
    private static final long serialVersionUID = 7456740337223357915L;
    private static Log logger = LogFactory.getLog(Shift.class);
    private Long id;
    private Long boId;
    private Date checkDate;
    private String shiftType;
    private Long checkCardTimes;
    private String shiftColor;
    private String name;
    private String chineseName;
    private String number;
    private boolean isOff;
    private boolean offNonPlan;
    private String lastRefStartDay;
    private String lastRefEndDay;
    private int lastShiftEndDate;
    private int lastShiftStartDate;
    @Deprecated
    private Long clockRuleId;
    @Deprecated
    private String shiftAttribute;
    @Deprecated
    private DateType dateType;
    private ShiftMiddleRule shiftMiddleRule;
    private String oneCardType;
    private Date bsed;
    private Date bsled;
    private Integer standardTime;
    private List<ShiftInfoVo> shiftInfoVoList;
    private List<ShiftDetail> shiftDetailList;
    private List<ShiftDetail> flexShift;
    private TakeCardRule takeCardRule;

    public void setFlexShift(List<ShiftDetail> flexShift) {
        this.flexShift = flexShift;
    }

    public List<ShiftDetail> getFlexShift() {
        return this.flexShift;
    }

    public List<ShiftInfoVo> getShiftInfoVoList() {
        return this.shiftInfoVoList;
    }

    public void setShiftInfoVoList(List<ShiftInfoVo> shiftInfoVoList) {
        this.shiftInfoVoList = shiftInfoVoList;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getBoId() {
        return this.boId;
    }

    public void setBoId(Long boId) {
        this.boId = boId;
    }

    @Deprecated
    public Date getCheckDate() {
        return this.checkDate;
    }

    @Deprecated
    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
        this.shiftDetailList.stream().forEach(e -> e.setCheckDate(checkDate));
    }

    public List<ShiftDetail> getShiftDetailList() {
        return this.shiftDetailList;
    }

    public void setShiftDetailList(List<ShiftDetail> shiftDetailList) {
        this.shiftDetailList = shiftDetailList;
    }

    public String getShiftType() {
        return this.shiftType;
    }

    public void setShiftType(String shiftType) {
        this.shiftType = shiftType;
    }

    public boolean isOff() {
        return this.isOff;
    }

    public void setOff(boolean off) {
        this.isOff = off;
    }

    public boolean getOffNonPlan() {
        return this.offNonPlan;
    }

    public void setOffNonPlan(boolean offNonPlan) {
        this.offNonPlan = offNonPlan;
    }

    public String getRefFstTime() {
        return Objects.isNull(this.flexShift) || this.flexShift.isEmpty() ? null : this.flexShift.get(0).getRefStartDay();
    }

    public String getRefLastTime() {
        return Objects.isNull(this.flexShift) || this.flexShift.isEmpty() ? null : this.flexShift.get(0).getRefEndDay();
    }

    public Integer getFlxSTime() {
        return Objects.isNull(this.flexShift) || this.flexShift.isEmpty() ? null : Integer.valueOf(this.flexShift.get(0).getShiftStartDate());
    }

    public Integer getFlexEtime() {
        return Objects.isNull(this.flexShift) || this.flexShift.isEmpty() ? null : Integer.valueOf(this.flexShift.get(0).getShiftEndDate());
    }

    @Deprecated
    public String getShiftAttribute() {
        return this.shiftAttribute;
    }

    public void setShiftAttribute(String shiftAttribute) {
        this.shiftAttribute = shiftAttribute;
    }

    public String getLastRefStartDay() {
        return this.lastRefStartDay;
    }

    public void setLastRefStartDay(String lastRefStartDay) {
        this.lastRefStartDay = lastRefStartDay;
    }

    public String getLastRefEndDay() {
        return this.lastRefEndDay;
    }

    public void setLastRefEndDay(String lastRefEndDay) {
        this.lastRefEndDay = lastRefEndDay;
    }

    public int getLastShiftEndDate() {
        return this.lastShiftEndDate;
    }

    public void setLastShiftEndDate(int lastShiftEndDate) {
        this.lastShiftEndDate = lastShiftEndDate;
    }

    public int getLastShiftStartDate() {
        return this.lastShiftStartDate;
    }

    public void setLastShiftStartDate(int lastShiftStartDate) {
        this.lastShiftStartDate = lastShiftStartDate;
    }

    @Deprecated
    public DateType getDateType() {
        return this.dateType;
    }

    @Deprecated
    public void setDateType(DateType dateType) {
        this.dateType = dateType;
    }

    public Long getClockRuleId() {
        return this.clockRuleId;
    }

    public void setClockRuleId(Long clockRuleId) {
        this.clockRuleId = clockRuleId;
    }

    public TakeCardRule getTakeCardRule() {
        return this.takeCardRule;
    }

    public void setTakeCardRule(TakeCardRule takeCardRule) {
        this.takeCardRule = takeCardRule;
    }

    public Date getShiftStartTime() {
        return WTCCollectionIndexUtil.getEleFromList(this.shiftDetailList, 0).isPresent() ? WTCCollectionIndexUtil.getEleFromList(this.shiftDetailList, 0).get().getAbsoluteShiftStartDate() : null;
    }

    public Date getShiftEndTime() {
        if (this.shiftDetailList != null && !this.shiftDetailList.isEmpty()) {
            return this.shiftDetailList.get(this.shiftDetailList.size() - 1).getAbsoluteShiftEndDate();
        }
        return null;
    }

    public static Calendar getSpecificCalendar(Date rankDate, String refstart, int startDate) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String dateFormat = simpleDateFormat.format(rankDate);
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(simpleDateFormat.parse(dateFormat));
            if (refstart.equals("C")) {
                calendar.add(5, 1);
            } else if (refstart.equals("Q")) {
                calendar.add(5, -1);
            }
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        calendar.add(13, startDate);
        return calendar;
    }

    public Long getCheckCardTimes() {
        return this.checkCardTimes;
    }

    public void setCheckCardTimes(Long checkCardTimes) {
        this.checkCardTimes = checkCardTimes;
    }

    public String getShiftColor() {
        return this.shiftColor;
    }

    public void setShiftColor(String shiftColor) {
        this.shiftColor = shiftColor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getChineseName() {
        return this.chineseName;
    }

    public void setChineseName(String chineseName) {
        this.chineseName = chineseName;
    }

    public ShiftMiddleRule getShiftMiddleRule() {
        return this.shiftMiddleRule;
    }

    public void setShiftMiddleRule(ShiftMiddleRule shiftMiddleRule) {
        this.shiftMiddleRule = shiftMiddleRule;
    }

    public String getOneCardType() {
        return this.oneCardType;
    }

    public void setOneCardType(String oneCardType) {
        this.oneCardType = oneCardType;
    }

    public Date getBsed() {
        return this.bsed;
    }

    public void setBsed(Date bsed) {
        this.bsed = bsed;
    }

    public Date getBsled() {
        return this.bsled;
    }

    public void setBsled(Date bsled) {
        this.bsled = bsled;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Integer getStandardTime() {
        return this.standardTime;
    }

    public void setStandardTime(Integer standardTime) {
        this.standardTime = standardTime;
    }

    public int getStandardTimeOfNoOt() {
        return this.standardTime - this.getInOtShiftDetail().stream().map(ShiftDetail::getSeconds).reduce(0, Integer::sum);
    }

    public List<ShiftDetail> getInOtShiftDetail() {
        return this.shiftDetailList != null ? this.shiftDetailList.stream().filter(ShiftDetail::isOTPeriod).collect(Collectors.toList()) : new ArrayList<ShiftDetail>(0);
    }

    public Tuple<Tuple<String, Integer>, Tuple<String, Integer>> getEarliestAndLatestPunchCardTuple() {
        if (this.shiftDetailList != null && !this.shiftDetailList.isEmpty()) {
            ShiftDetail startDetail = this.shiftDetailList.get(0);
            ShiftDetail endDetail = this.shiftDetailList.get(this.shiftDetailList.size() - 1);
            return Tuple.create((Object)Tuple.create((Object)startDetail.getRefStartDay(), (Object)startDetail.getShiftStartDate()), (Object)Tuple.create((Object)endDetail.getRefEndDay(), (Object)endDetail.getShiftEndDate()));
        }
        return null;
    }

    public String toString() {
        return "Shift{id=" + this.id + ", checkDate=" + this.checkDate + ", shiftType='" + this.shiftType + '\'' + ", checkCardTimes=" + this.checkCardTimes + ", shiftColor='" + this.shiftColor + '\'' + ", name='" + this.name + '\'' + ", isOff=" + this.isOff + ", offNonPlan=" + this.offNonPlan + ", lastRefStartDay='" + this.lastRefStartDay + '\'' + ", lastRefEndDay='" + this.lastRefEndDay + '\'' + ", lastShiftEndDate=" + this.lastShiftEndDate + ", lastShiftStartDate=" + this.lastShiftStartDate + ", clockRuleId=" + this.clockRuleId + ", shiftMiddleRule=" + this.shiftMiddleRule + ", shiftInfoVoList=" + this.shiftInfoVoList + ", shiftDetailList=" + this.shiftDetailList + ", flexShift=" + this.flexShift + '}';
    }
}

