/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.model.shift;

import javax.annotation.Nullable;

public enum RefDateType {
    TODAY("D", "today", 0),
    NEXTDAY("C", "nextday", 1),
    LASTDAY("Q", "lastday", -1);

    public final String code;
    public final int refIndex;
    private final String name;
    static final int DAYOFSECOND = 86400;

    private RefDateType(String code, String name, int refIndex) {
        this.code = code;
        this.name = name;
        this.refIndex = refIndex;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public static RefDateType from(String code) {
        RefDateType[] statusEnumArr;
        for (RefDateType statusEnum : statusEnumArr = RefDateType.values()) {
            if (!statusEnum.code.equals(code)) continue;
            return statusEnum;
        }
        return null;
    }

    public int getAdjustSecond(int second) {
        switch (this) {
            case TODAY: {
                return second;
            }
            case NEXTDAY: {
                return second + 86400;
            }
        }
        return second;
    }

    public static RefDateType fromBySeconds(int seconds) {
        return seconds >= 86400 ? NEXTDAY : TODAY;
    }
}

