/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.model.sign;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.wtc.wtbs.common.model.shift.RefDateType;

public class TimeSeq
implements Serializable {
    private static final long serialVersionUID = 4131629563621234479L;
    private Integer startBeforeScope;
    private Integer startAfterScope;
    private String startTakeCardRule;
    private String startTakeCardSameLen;
    private Integer endBeforeScope;
    private Integer endAfterScope;
    private String endTakeCardRule;
    private String endTakeCardSameLen;
    private Integer timeSeq;

    public Date getSpecificDateTime(Date date, String refDay, int time) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String dateFormat = simpleDateFormat.format(date);
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(simpleDateFormat.parse(dateFormat));
            if (RefDateType.NEXTDAY.code.equals(refDay)) {
                calendar.add(5, 1);
            } else if (RefDateType.LASTDAY.code.equals(refDay)) {
                calendar.add(5, -1);
            }
        }
        catch (ParseException e) {
            String msg = ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u9519\u8bef\u3002", (String)"TimeSeq_0", (String)"wtc-wtbs-common", (Object[])new Object[0]);
            throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
        }
        calendar.add(13, time);
        return calendar.getTime();
    }

    public Date getStartDateBefore(Date baseDate, String refDay, int time) {
        return this.getSpecificDateTime(baseDate, refDay, time - this.startBeforeScope * 60);
    }

    public Date getStartDateAfter(Date baseDate, String refDay, int time) {
        return this.getSpecificDateTime(baseDate, refDay, time + this.startAfterScope * 60);
    }

    public Date getEndDateBefore(Date baseDate, String refDay, int time) {
        return this.getSpecificDateTime(baseDate, refDay, time - this.endBeforeScope * 60);
    }

    public Date getEndDateAfter(Date baseDate, String refDay, int time) {
        return this.getSpecificDateTime(baseDate, refDay, time + this.endAfterScope * 60);
    }

    public Integer getStartBeforeScope() {
        return this.startBeforeScope;
    }

    public void setStartBeforeScope(Integer startBeforeScope) {
        this.startBeforeScope = startBeforeScope;
    }

    public Integer getStartAfterScope() {
        return this.startAfterScope;
    }

    public void setStartAfterScope(Integer startAfterScope) {
        this.startAfterScope = startAfterScope;
    }

    public String getStartTakeCardRule() {
        return this.startTakeCardRule;
    }

    public void setStartTakeCardRule(String startTakeCardRule) {
        this.startTakeCardRule = startTakeCardRule;
    }

    public String getStartTakeCardSameLen() {
        return this.startTakeCardSameLen;
    }

    public void setStartTakeCardSameLen(String startTakeCardSameLen) {
        this.startTakeCardSameLen = startTakeCardSameLen;
    }

    public Integer getEndBeforeScope() {
        return this.endBeforeScope;
    }

    public void setEndBeforeScope(Integer endBeforeScope) {
        this.endBeforeScope = endBeforeScope;
    }

    public Integer getEndAfterScope() {
        return this.endAfterScope;
    }

    public void setEndAfterScope(Integer endAfterScope) {
        this.endAfterScope = endAfterScope;
    }

    public String getEndTakeCardRule() {
        return this.endTakeCardRule;
    }

    public void setEndTakeCardRule(String endTakeCardRule) {
        this.endTakeCardRule = endTakeCardRule;
    }

    public String getEndTakeCardSameLen() {
        return this.endTakeCardSameLen;
    }

    public void setEndTakeCardSameLen(String endTakeCardSameLen) {
        this.endTakeCardSameLen = endTakeCardSameLen;
    }

    public Integer getTimeSeq() {
        return this.timeSeq;
    }

    public void setTimeSeq(Integer timeSeq) {
        this.timeSeq = timeSeq;
    }
}

