/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.model.workschdule.datetypeadj;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.enums.workschedule.DateTypeEnum;
import kd.wtc.wtbs.common.model.common.DateType;
import kd.wtc.wtbs.common.util.third.collect.ImmutableMap;

public class DateTypeAdj
implements Serializable {
    private static final long serialVersionUID = -1589095770844532851L;
    private static final Log LOG = LogFactory.getLog(DateTypeAdj.class);
    private static final String[] DAY_WEEKS = new String[]{null, "A", "A", "A", "A", "A", "B", "C"};
    public static final Map<Long, Long> DEFAULT_DATETYPE_OF_DATEPROP_MAP = ImmutableMap.of(DateAttribute.WORKDAY.getId(), DateTypeEnum.WORK_PAID.getId(), DateAttribute.OFFDAY.getId(), DateTypeEnum.REST_PAID.getId());
    private final Map<String, Tuple<Long, Long>> entryEntityMap;
    private final List<Tuple<Tuple<Date, Date>, Tuple<Long, Long>>> specialDateEntries;
    private Map<Long, DateType> dateTypeMap = null;
    private Set<Long> dateTypeIdSet = null;
    private boolean isNeedShiftOffType;

    public DateTypeAdj(Map<String, Tuple<Long, Long>> entryEntityMap, List<Tuple<Tuple<Date, Date>, Tuple<Long, Long>>> specialDateEntries, boolean isNeedShiftOffType) {
        this.entryEntityMap = entryEntityMap;
        this.specialDateEntries = specialDateEntries;
        this.isNeedShiftOffType = isNeedShiftOffType;
    }

    public Tuple<Long, Long> adjustDateType(Date workDate, int weekDay, long datePropId, long fromDateTypeId) {
        return this.adjustDateType(workDate, weekDay, datePropId, fromDateTypeId, false);
    }

    public Tuple<Long, Long> adjustDateType(Date workDate, int weekDay, long datePropId, long fromDateTypeId, boolean isOff) {
        Tuple<Long, Long> toDateType;
        if (fromDateTypeId == 0L) {
            Long dateTypeId = DEFAULT_DATETYPE_OF_DATEPROP_MAP.get(datePropId);
            if (dateTypeId == null) {
                return null;
            }
            fromDateTypeId = dateTypeId;
        }
        if ((toDateType = this.entryEntityMap.get(DateTypeAdj.genKeyOfEntryMap(weekDay, fromDateTypeId, this.isNeedShiftOffType, isOff))) != null) {
            if (DateTypeEnum.REST_SPECIAL.getId().equals(toDateType.item1)) {
                if (this.specialDateEntries != null) {
                    for (Tuple<Tuple<Date, Date>, Tuple<Long, Long>> specialDateEntry : this.specialDateEntries) {
                        if (workDate.before((Date)((Tuple)specialDateEntry.item1).item1) || workDate.after((Date)((Tuple)specialDateEntry.item1).item2)) continue;
                        return (Tuple)specialDateEntry.item2;
                    }
                }
            } else if (toDateType.item1 != null && (Long)toDateType.item1 != 0L) {
                return toDateType;
            }
        }
        return null;
    }

    public void setDateTypeIdSet(Set<Long> dateTypeIdSet) {
        this.dateTypeIdSet = dateTypeIdSet;
    }

    public Set<Long> getAllOutPutDateTypeIds() {
        return this.dateTypeIdSet;
    }

    public void setDateTypeMap(Map<Long, DateType> dateTypeMap) {
        this.dateTypeMap = dateTypeMap;
    }

    public DateType getDateTypeById(Long dateTypeId) {
        if (this.dateTypeMap != null) {
            return this.dateTypeMap.get(dateTypeId);
        }
        return null;
    }

    public static String genKeyOfEntryMap(int weekday, long fromDateTypeId, boolean isNeedShiftOffType, boolean isOff) {
        if (isNeedShiftOffType) {
            return DAY_WEEKS[weekday] + "_" + fromDateTypeId + "_" + (isOff ? "0" : "1");
        }
        return DAY_WEEKS[weekday] + "_" + fromDateTypeId;
    }

    public static String genKeyOfEntryMap(String dayWeek, long fromDateTypeId, String shiftOffType) {
        if (HRStringUtils.isEmpty((String)shiftOffType)) {
            return dayWeek + "_" + fromDateTypeId;
        }
        return dayWeek + "_" + fromDateTypeId + "_" + shiftOffType;
    }

    public boolean isNeedShiftOffType() {
        return this.isNeedShiftOffType;
    }
}

