/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.param;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import kd.wtc.wtbs.common.lang.WTCException;
import kd.wtc.wtbs.common.param.WTCParam;
import kd.wtc.wtbs.common.util.WTCAssert;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public abstract class WTCMapParam
implements WTCParam {
    private JSONObject properties;

    protected void loadParams(Map<String, Object> params) {
        WTCAssert.nonNull(params, "params");
        this.properties = new JSONObject(params);
    }

    @Override
    public String getString(String paramKey, String defaultValue) {
        try {
            String value = this.properties.getString(paramKey);
            return value == null ? defaultValue : value;
        }
        catch (Exception e) {
            throw new WTCException(e, "Param resolve exception: " + paramKey);
        }
    }

    @Override
    public Boolean getBoolean(String paramKey, Boolean defaultValue) {
        try {
            Boolean value = this.properties.getBoolean(paramKey);
            return value == null ? defaultValue : value;
        }
        catch (Exception e) {
            throw new WTCException(e, "Param resolve exception: " + paramKey);
        }
    }

    @Override
    public Integer getInteger(String paramKey, Integer defaultValue) {
        try {
            Integer value = this.properties.getInteger(paramKey);
            return value == null ? defaultValue : value;
        }
        catch (Exception e) {
            throw new WTCException(e, "Param resolve exception: " + paramKey);
        }
    }

    @Override
    public Long getLong(String paramKey, Long defaultValue) {
        try {
            Long value = this.properties.getLong(paramKey);
            return value == null ? defaultValue : value;
        }
        catch (Exception e) {
            throw new WTCException(e, "Param resolve exception: " + paramKey);
        }
    }

    @Override
    public Double getDouble(String paramKey, Double defaultValue) {
        try {
            Double value = this.properties.getDouble(paramKey);
            return value == null ? defaultValue : value;
        }
        catch (Exception e) {
            throw new WTCException(e, "Param resolve exception: " + paramKey);
        }
    }

    @Override
    public BigInteger getBigInteger(String paramKey, BigInteger defaultValue) {
        try {
            BigInteger value = this.properties.getBigInteger(paramKey);
            return value == null ? defaultValue : value;
        }
        catch (Exception e) {
            throw new WTCException(e, "Param resolve exception: " + paramKey);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String paramKey, BigDecimal defaultValue) {
        try {
            BigDecimal value = this.properties.getBigDecimal(paramKey);
            return value == null ? defaultValue : value;
        }
        catch (Exception e) {
            throw new WTCException(e, "Param resolve exception: " + paramKey);
        }
    }

    @Override
    public Date getDate(String paramKey, Date defaultValue) {
        try {
            Date value = this.properties.getDate(paramKey);
            return value == null ? defaultValue : value;
        }
        catch (Exception e) {
            throw new WTCException(e, "Param resolve exception: " + paramKey);
        }
    }

    @Override
    public LocalDate getLocalDate(String paramKey, LocalDate defaultValue) {
        Date date;
        Object value = this.properties.get((Object)paramKey);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        try {
            date = TypeUtils.castToDate((Object)value);
        }
        catch (Exception e) {
            throw new WTCException(e, "Param resolve exception: " + paramKey);
        }
        if (date == null) {
            return defaultValue;
        }
        return WTCDateUtils.toLocalDate(date);
    }

    @Override
    public LocalDateTime getLocalDateTime(String paramKey, LocalDateTime defaultValue) {
        Date date;
        Object value = this.properties.get((Object)paramKey);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        try {
            date = TypeUtils.castToDate((Object)value);
        }
        catch (Exception e) {
            throw new WTCException(e, "Param resolve exception: " + paramKey);
        }
        if (date == null) {
            return defaultValue;
        }
        return WTCDateUtils.toLocalDateTime(date);
    }

    @Override
    public LocalTime getLocalTime(String paramKey, LocalTime defaultValue) {
        Integer integer;
        Object value = this.properties.get((Object)paramKey);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        try {
            integer = TypeUtils.castToInt((Object)value);
        }
        catch (Exception e) {
            throw new WTCException(e, "Param resolve exception: " + paramKey);
        }
        if (integer == null) {
            return defaultValue;
        }
        return LocalTime.ofSecondOfDay(integer.intValue());
    }

    @Override
    public Object get(String paramKey) {
        return this.properties.get((Object)paramKey);
    }

    @Override
    public Map<String, Object> getAllParams() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public boolean contains(String paramKey) {
        return this.properties.containsKey((Object)paramKey);
    }
}

