/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.unittest;

import java.time.LocalDate;
import java.util.Collection;
import java.util.function.Consumer;
import junit.framework.AssertionFailedError;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.unittest.AbstractBaseUnitTestPlugIn;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.wtc.wtbs.common.unittest.ViewInfoUtil;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;

public class CommonTestUtils {
    private static final Log log = LogFactory.getLog(CommonTestUtils.class);

    public static String commonSearch(String number, String formId, AbstractJUnitTestPlugIn junit) {
        String param = "[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[{\"FieldName\":[\"number\",\"name\"],\"Value\":[\"" + number + "\"]}],[{\"FieldName\":[\"enable\"],\"Value\":[\"\"],\"Compare\":[\"\"]}],\"" + formId + "\"],\"postData\":[{},[]]}]";
        String callBackArg = junit.batchInvokeAction(junit.getView(), param);
        return callBackArg;
    }

    public static String save(IFormView editView, AbstractJUnitTestPlugIn junit) {
        String result = junit.batchInvokeAction(editView, "[{\"key\":\"tbmain\",\"methodName\":\"itemClick\",\"args\":[\"bar_save\",\"save\"],\"postData\":[{},[]]}]");
        return result;
    }

    public static String btSave(IFormView editView, AbstractJUnitTestPlugIn junit) {
        String param = "[{\"key\":\"btnsave\",\"methodName\":\"click\",\"args\":[],\"postData\":[{},[]]}]";
        String result = junit.batchInvokeAction(editView, param);
        return result;
    }

    public static IFormView entryRowClick(Object pk, String number, AbstractJUnitTestPlugIn junit) {
        return ViewInfoUtil.getView(junit.getView(), CommonTestUtils.getEntryRowClickParams(pk, number), junit);
    }

    public static String batchInvokeActionLog(String action, IFormView view, String params, AbstractBaseUnitTestPlugIn plugIn) {
        log.info("ut_action_name: {}", (Object)action);
        log.info("ut_action_params: {}", (Object)params);
        String result = plugIn.batchInvokeAction(view.getFormShowParameter().getServiceAppId(), view, params);
        log.info("ut_action_result: {}", (Object)result);
        return result;
    }

    public static String batchInvokeActionAssertSuccess(String action, IFormView view, String params, AbstractBaseUnitTestPlugIn plugIn) {
        String result = CommonTestUtils.batchInvokeActionLog(action, view, params, plugIn);
        KDAssert.assertInvokeAction((String)result);
        return result;
    }

    public static String batchInvokeActionLog(String action, String appId, IFormView view, String params, AbstractBaseUnitTestPlugIn plugIn) {
        log.info("ut_action_name: {}", (Object)action);
        log.info("ut_action_params: {}", (Object)params);
        String result = plugIn.batchInvokeAction(appId, view, params);
        log.info("ut_action_result: {}", (Object)result);
        KDAssert.assertInvokeAction((String)result);
        return result;
    }

    public static String getEntryRowClickParams(Object pk, String number) {
        return String.format("[{\"key\":\"billlistap\",\"methodName\":\"entryRowClick\",\"args\":[0],\"postData\":[{\"billlistap\":{\"fieldKey\":\"number\",\"row\":0,\"selRows\":[0],\"selDatas\":[[\"%1$s\",\"%2$s\",\"100000\",\"%2$s\",\"A\"]],\"isClientNewRow\":false,\"clientNewRows\":\"\"}},[]]},{\"key\":\"billlistap\",\"methodName\":\"hyperLinkClick\",\"args\":[\"number\",0],\"postData\":[{},[]]}]", pk, number);
    }

    public static void setCommonParams(IFormView editView, String number) {
        IDataModel model = editView.getModel();
        model.setValue("number", (Object)number);
        model.setValue("name", (Object)number);
        model.setValue("bsed", (Object)HRDateTimeUtils.localDate2Date((LocalDate)LocalDate.now()));
    }

    public static void addSimpleDateRange(IFormView view, AbstractJUnitTestPlugIn plugIn) {
        String pageId = view.getPageCache().get("childpageId");
        IFormView dateRangeView = plugIn.getView().getView(pageId);
        String params = "[{\"key\":\"targetconditionap\",\"methodName\":\"setValue\",\"args\":[\"{\\\"conditionList\\\":[{\\\"index\\\":0,\\\"name\\\":\\\"T01\\\",\\\"displayParam\\\":null,\\\"param\\\":null,\\\"paramType\\\":null,\\\"target\\\":null,\\\"operators\\\":null,\\\"valueType\\\":\\\"2\\\",\\\"objectId\\\":\\\"\\\",\\\"objectNumber\\\":\\\"\\\"}],\\\"conditionExpressList\\\":[{\\\"name\\\":\\\"T01\\\"}],\\\"conditionExpressStr\\\":\\\"T01\\\"}\"],\"postData\":[]}]";
        plugIn.batchInvokeAction(dateRangeView, params);
        params = "[{\"key\":\"targetconditionap\",\"methodName\":\"setValue\",\"args\":[\"{\\\"conditionList\\\":[{\\\"index\\\":0,\\\"name\\\":\\\"T01\\\",\\\"displayParam\\\":\\\"\u65e5\u671f\u8303\u56f4.\u65e5\u671f\u5c5e\u6027\\\",\\\"param\\\":\\\"simpledaterange.wtbd_simpledaterangestd.dateattribute\\\",\\\"paramType\\\":\\\"string\\\",\\\"target\\\":false,\\\"operators\\\":\\\"==\\\",\\\"valueType\\\":\\\"2\\\",\\\"objectId\\\":\\\"\\\",\\\"objectNumber\\\":\\\"\\\"}],\\\"conditionExpressList\\\":[{\\\"name\\\":\\\"T01\\\"}],\\\"conditionExpressStr\\\":\\\"T01\\\"}\"],\"postData\":[]}]";
        plugIn.batchInvokeAction(dateRangeView, params);
        params = "[{\"key\":\"targetconditionap\",\"methodName\":\"setValue\",\"args\":[\"{\\\"conditionList\\\":[{\\\"index\\\":0,\\\"name\\\":\\\"T01\\\",\\\"displayParam\\\":\\\"\u65e5\u671f\u8303\u56f4.\u65e5\u671f\u5c5e\u6027\\\",\\\"param\\\":\\\"simpledaterange.wtbd_simpledaterangestd.dateattribute\\\",\\\"paramType\\\":\\\"string\\\",\\\"target\\\":false,\\\"operators\\\":\\\"==\\\",\\\"valueType\\\":\\\"2\\\",\\\"displayValue\\\":\\\"\u5de5\u4f5c\u65e5\\\",\\\"value\\\":\\\"DS-0001\\\",\\\"objectId\\\":\\\"\\\",\\\"objectNumber\\\":\\\"\\\"}],\\\"conditionExpressList\\\":[{\\\"name\\\":\\\"T01\\\"}],\\\"conditionExpressStr\\\":\\\"T01\\\"}\"],\"postData\":[]}]";
        plugIn.batchInvokeAction(dateRangeView, params);
    }

    public static void addDateRange(IFormView view, AbstractJUnitTestPlugIn plugIn) {
        String pageId = view.getPageCache().get("childpageId");
        IFormView dateRangeView = view.getView(pageId);
        String params = "[{\"key\":\"targetconditionap\",\"methodName\":\"setValue\",\"args\":[\"{\\\"conditionList\\\":[{\\\"index\\\":0,\\\"name\\\":\\\"T01\\\",\\\"displayParam\\\":null,\\\"param\\\":null,\\\"paramType\\\":null,\\\"target\\\":null,\\\"operators\\\":null,\\\"valueType\\\":\\\"2\\\",\\\"objectId\\\":\\\"\\\",\\\"objectNumber\\\":\\\"\\\"}],\\\"conditionExpressList\\\":[{\\\"name\\\":\\\"T01\\\"}],\\\"conditionExpressStr\\\":\\\"T01\\\"}\"],\"postData\":[]}]";
        plugIn.batchInvokeAction(dateRangeView, params);
        params = "[{\"key\":\"targetconditionap\",\"methodName\":\"setValue\",\"args\":[\"{\\\"conditionList\\\":[{\\\"index\\\":0,\\\"name\\\":\\\"T01\\\",\\\"displayParam\\\":\\\"\u65e5\u671f\u8303\u56f4.\u65e5\u671f\u5c5e\u6027\\\",\\\"param\\\":\\\"daterange.wtbd_daterangestd.dateattribute\\\",\\\"paramType\\\":\\\"string\\\",\\\"target\\\":false,\\\"operators\\\":\\\"==\\\",\\\"valueType\\\":\\\"2\\\",\\\"objectId\\\":\\\"\\\",\\\"objectNumber\\\":\\\"\\\"}],\\\"conditionExpressList\\\":[{\\\"name\\\":\\\"T01\\\"}],\\\"conditionExpressStr\\\":\\\"T01\\\"}\"],\"postData\":[]}]";
        plugIn.batchInvokeAction(dateRangeView, params);
        params = "[{\"key\":\"targetconditionap\",\"methodName\":\"setValue\",\"args\":[\"{\\\"conditionList\\\":[{\\\"index\\\":0,\\\"name\\\":\\\"T01\\\",\\\"displayParam\\\":\\\"\u65e5\u671f\u8303\u56f4.\u65e5\u671f\u5c5e\u6027\\\",\\\"param\\\":\\\"daterange.wtbd_daterangestd.dateattribute\\\",\\\"paramType\\\":\\\"string\\\",\\\"target\\\":false,\\\"operators\\\":\\\"==\\\",\\\"valueType\\\":\\\"2\\\",\\\"displayValue\\\":\\\"\u5de5\u4f5c\u65e5\\\",\\\"value\\\":\\\"DS-0001\\\",\\\"objectId\\\":\\\"\\\",\\\"objectNumber\\\":\\\"\\\"}],\\\"conditionExpressList\\\":[{\\\"name\\\":\\\"T01\\\"}],\\\"conditionExpressStr\\\":\\\"T01\\\"}\"],\"postData\":[]}]";
        plugIn.batchInvokeAction(dateRangeView, params);
    }

    public static <T> void assertFail(Consumer<T> consumer, T plugin) {
        try {
            consumer.accept(plugin);
        }
        catch (AssertionFailedError error) {
            log.error("AssertionFailedError", (Throwable)error);
        }
    }

    public static Object getFirstRowPkVal(AbstractListView listView) {
        ListSelectedRowCollection rows = listView.getCurrentListAllRowCollection();
        if (CollectionUtils.isNotEmpty((Collection)rows)) {
            ListSelectedRow row = rows.get(0);
            return row.getPrimaryKeyValue();
        }
        return null;
    }
}

