/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.unittest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.unittest.AbstractBaseUnitTestPlugIn;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.unittest.CommonTestUtils;
import kd.wtc.wtbs.common.unittest.InvokeUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class ViewInfoUtil {
    private static final Log log = LogFactory.getLog(ViewInfoUtil.class);
    private static Pattern PATTERN = Pattern.compile(",\"pageId\":\"(.+?)\"");

    public static String getChildPageId(String params, AbstractJUnitTestPlugIn junit) {
        String callBackArg = InvokeUtil.invokeAction(params, junit);
        return ViewInfoUtil.getChildPageId(callBackArg);
    }

    public static String getChildPageId(IFormView parentView, String param, AbstractJUnitTestPlugIn junit) {
        String callBack = InvokeUtil.invokeAction(parentView, param, junit);
        return ViewInfoUtil.getChildPageId(callBack);
    }

    public static IFormView getChildView(IFormView parentView, String param, AbstractJUnitTestPlugIn junit) {
        String callBack = InvokeUtil.invokeAction(parentView, param, junit);
        String childPageId = ViewInfoUtil.getChildPageId(callBack);
        if (HRStringUtils.isNotEmpty((String)childPageId)) {
            junit.loadData(childPageId);
            return junit.getView(childPageId);
        }
        log.info("\u6253\u5f00\u9875\u9762\u5f02\u5e38, param:{}, params:{}", (Object)param, (Object)callBack);
        return null;
    }

    public static String getChildPageId(String response) {
        if (HRStringUtils.isEmpty((String)response)) {
            return null;
        }
        List results = (List)SerializationUtils.fromJsonString((String)response, List.class);
        String newPageId = null;
        for (int i = 0; i < results.size(); ++i) {
            ArrayList result = (ArrayList)((Map)results.get(i)).get("p");
            for (int j = 0; j < result.size(); ++j) {
                Map map;
                String temp;
                if (!(result.get(j) instanceof Map) || (temp = (String)(map = (Map)result.get(j)).get("pageId")) == null) continue;
                newPageId = temp;
            }
        }
        if (StringUtils.isBlank(newPageId)) {
            newPageId = ViewInfoUtil.getChildPageId(response, "");
        }
        return newPageId;
    }

    public static String getChildPageId(String response, String keyword) {
        Matcher matcher;
        String regex = "";
        Pattern pattern = PATTERN;
        if (HRStringUtils.isNotEmpty((String)keyword)) {
            regex = String.format("\"%s\".+?\"pageId\":\"(.+?)\"", keyword);
        }
        if (HRStringUtils.isNotEmpty((String)regex)) {
            pattern = Pattern.compile(regex);
        }
        if ((matcher = pattern.matcher(response)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static List<String> getChildPageIdList(String response) {
        Matcher matcher = PATTERN.matcher(response);
        ArrayList<String> pageIdList = Lists.newArrayListWithExpectedSize(10);
        while (matcher.find()) {
            pageIdList.add(matcher.group(1));
        }
        return pageIdList;
    }

    public static String getPageIdFromCallBackArg(String callBackArg) {
        Pattern p;
        Matcher m;
        String pageId = "";
        List results = (List)SerializationUtils.fromJsonString((String)callBackArg, List.class);
        for (int i = 0; i < results.size(); ++i) {
            ArrayList result = (ArrayList)((Map)results.get(i)).get("p");
            for (int j = 0; j < result.size(); ++j) {
                if (!(result.get(j) instanceof Map)) continue;
                Map map = (Map)result.get(j);
                pageId = (String)map.get("pageId");
            }
        }
        if (HRStringUtils.isEmpty((String)pageId) && (m = (p = Pattern.compile(",\"pageId\":\"(.+?)\"")).matcher(callBackArg)).find()) {
            pageId = m.group(1);
        }
        return pageId;
    }

    public static String getChildPageId(List<?> paraList) {
        String childPageId = "";
        List<?> results = paraList;
        ArrayList list = new ArrayList();
        for (Map result : results) {
            for (Map.Entry entry : result.entrySet()) {
                Object entryValue = entry.getValue();
                list.clear();
                if (entryValue instanceof List) {
                    list = (ArrayList)entryValue;
                }
                for (Object obj : list) {
                    if (!(obj instanceof Map)) continue;
                    Map mapStr = (Map)obj;
                    if (mapStr.containsKey("pageId") && mapStr.containsKey("parentPageId")) {
                        childPageId = (String)mapStr.get("pageId");
                        return childPageId;
                    }
                    Map mapObj = (Map)obj;
                    for (Map.Entry objEntry : mapObj.entrySet()) {
                        Object objValue = objEntry.getValue();
                        if (!(objValue instanceof List)) continue;
                        ViewInfoUtil.rmParamNotMap((List)objValue);
                        childPageId = ViewInfoUtil.getChildPageId((List)objValue);
                    }
                }
            }
        }
        return childPageId;
    }

    private static void rmParamNotMap(List<?> list) {
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof Map) continue;
            iterator.remove();
        }
    }

    public static IFormView getView(IFormView parentView, String param, AbstractJUnitTestPlugIn junit) {
        String result = junit.batchInvokeAction(parentView, param);
        return ViewInfoUtil.getChildView(result, junit);
    }

    private static IFormView getChildView(String result, AbstractJUnitTestPlugIn plugIn) {
        List results = (List)SerializationUtils.fromJsonString((String)result, List.class);
        String pageId = ViewInfoUtil.getChildPageId(results);
        if (HRStringUtils.isEmpty((String)pageId)) {
            KDAssert.fail((String)result);
        }
        plugIn.loadData(pageId);
        return plugIn.getView(pageId);
    }

    public static IFormView getView(String result, AbstractJUnitTestPlugIn junit) {
        String pageId = ViewInfoUtil.getChildPageId(result);
        if (HRStringUtils.isEmpty((String)pageId)) {
            KDAssert.fail((String)result);
        }
        junit.loadData(pageId);
        return junit.getView(pageId);
    }

    public static IFormView getView(String result, AbstractJUnitTestPlugIn plugIn, String formId) {
        IFormView detailView = ViewInfoUtil.getView(result, plugIn);
        if (!StringUtils.equals((CharSequence)formId, (CharSequence)detailView.getFormShowParameter().getFormId())) {
            detailView = detailView.getParentView();
        }
        if (!StringUtils.equals((CharSequence)formId, (CharSequence)detailView.getFormShowParameter().getFormId())) {
            KDAssert.fail((String)ResManager.loadKDString((String)"\u83b7\u53d6\u9875\u9762{0}\u5931\u8d25\uff0cresult:\n{1}", (String)"ViewInfoUtil_2", (String)"wtc-wtbs-common", (Object[])new Object[]{formId, result}));
        }
        return detailView;
    }

    public static IFormView getView(String name, IFormView parentView, String params, AbstractJUnitTestPlugIn plugIn) {
        log.info("ut_action_name: {}", (Object)name);
        log.info("ut_action_params: {}", (Object)params);
        String result = plugIn.batchInvokeAction(parentView, params);
        log.info("ut_action_result: {}", (Object)result);
        return ViewInfoUtil.getChildView(result, plugIn);
    }

    public static IFormView getView(String name, String appId, IFormView parentView, String params, AbstractJUnitTestPlugIn plugIn) {
        log.info("ut_action_name: {}", (Object)name);
        log.info("ut_action_params: {}", (Object)params);
        String result = plugIn.batchInvokeAction(parentView, params);
        log.info("ut_action_result: {}", (Object)result);
        String childPageId = ViewInfoUtil.getChildPageId(result);
        IFormView view = parentView.getViewNoPlugin(childPageId);
        KDAssert.assertNotNull((String)("result=" + result + ",childPageId=" + childPageId), (Object)view);
        String loadDataParams = "[{\"key\":\"\",\"methodName\":\"loadData\",\"args\":[],\"postData\":[]}]";
        CommonTestUtils.batchInvokeActionLog("loadData", appId, view, loadDataParams, (AbstractBaseUnitTestPlugIn)plugIn);
        return view;
    }

    public static List<String> getArgIdFromCallBackArg(String args) {
        List results = (List)SerializationUtils.fromJsonString((String)args, List.class);
        for (Map objectArrayListMap : results) {
            ArrayList result = (ArrayList)objectArrayListMap.get("p");
            for (Object o : result) {
                Map map;
                if (!(o instanceof Map) || (map = (Map)o).get("args") == null) continue;
                List argsList = (List)map.get("args");
                return argsList;
            }
        }
        return null;
    }
}

