/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.util;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.BillTypeNameCacheDto;

@Deprecated
public class BillTypeNameCache {
    private static final Log log = LogFactory.getLog(BillTypeNameCache.class);
    private final Long billTypeId;
    private final Map<String, BillTypeNameCacheDto> cache;

    public BillTypeNameCache(Long billTypeId) {
        this.billTypeId = billTypeId;
        this.cache = new HashMap<String, BillTypeNameCacheDto>(16);
    }

    public String getBillName() {
        String billName = "";
        BillTypeNameCacheDto dto = this.getCacheNameDto();
        billName = dto == null ? "" : dto.getBillName();
        if (log.isDebugEnabled()) {
            log.debug("BillTypeNameCache.getBillName,billName={}", (Object)billName);
        }
        return billName;
    }

    public String getCNBillName() {
        String billName = "";
        BillTypeNameCacheDto dto = this.getCacheNameDto();
        billName = dto == null ? "" : dto.getCnBillName();
        if (log.isDebugEnabled()) {
            log.debug("BillTypeNameCache.getBillName,billName={}", (Object)billName);
        }
        return billName;
    }

    private BillTypeNameCacheDto getCacheNameDto() {
        BillTypeNameCacheDto dto = this.cache.get(this.getKey());
        if (dto == null || System.currentTimeMillis() > dto.getTimeOut()) {
            dto = this.flushCacheMap();
        }
        return dto;
    }

    private BillTypeNameCacheDto flushCacheMap() {
        ILocaleString billNameLS = this.loadBillName();
        if (billNameLS == null) {
            return null;
        }
        String billName = billNameLS.getLocaleValue();
        String cnBillName = billNameLS.getLocaleValue_zh_CN();
        BillTypeNameCacheDto cacheDto = new BillTypeNameCacheDto(billName, cnBillName);
        this.cache.put(this.getKey(), cacheDto);
        return cacheDto;
    }

    private ILocaleString loadBillName() {
        ILocaleString billName = null;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbd_billtype");
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter id = new QFilter("id", "=", (Object)this.billTypeId);
        DynamicObject[] dys = helper.query("id,name", new QFilter[]{enable, status, id});
        if (dys.length > 0) {
            DynamicObject dy = dys[0];
            billName = dy.getLocaleString("name");
        }
        if (log.isDebugEnabled()) {
            log.info("BillTypeNameCache.loadBillName,billId={},billName={}", (Object)this.billTypeId, (Object)billName);
        }
        return billName;
    }

    private String getKey() {
        return this.billTypeId + RequestContext.get().getAccountId() + Lang.get().getLangTag();
    }
}

