/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.util;

import java.util.HashMap;
import java.util.Map;
import kd.wtc.wtbs.common.util.WTCCollections;

public class MapBuilder {
    private Map<String, Object> map;

    private MapBuilder(int size) {
        this.map = new HashMap<String, Object>(size);
    }

    private MapBuilder(Map<String, Object> data) {
        this.map = data;
    }

    public static MapBuilder newInstance(int size) {
        return new MapBuilder(size);
    }

    public static MapBuilder newInstance() {
        return new MapBuilder(16);
    }

    public static MapBuilder newInstance(Map<String, Object> data) {
        if (data == null) {
            return new MapBuilder(16);
        }
        return new MapBuilder(data);
    }

    public static MapBuilder newInstance(String key, Object value) {
        MapBuilder mapBuilder = new MapBuilder(4);
        mapBuilder.map.put(key, value);
        return mapBuilder;
    }

    public static Map<String, Object> toSingleMap(String key, Object value) {
        return WTCCollections.modifiableMap(key, value);
    }

    public MapBuilder setAttribute(String key, Object value) {
        this.map.put(key, value);
        return this;
    }

    public MapBuilder setAll(Map<String, Object> data) {
        if (data != null) {
            this.map.putAll(data);
        }
        return this;
    }

    public MapBuilder replaceKeyIfExist(String srcKey, String tarKey) {
        if (this.map.containsKey(srcKey)) {
            this.map.put(tarKey, this.map.remove(srcKey));
        }
        return this;
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public <T> T getAttributeValue(String key) {
        return (T)this.map.get(key);
    }

    public Map<String, Object> toMap() {
        return this.map;
    }

    public String toString() {
        return "MapBuilder{map=" + this.map + '}';
    }
}

