/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.util;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppCustomParam;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.wtc.wtbs.common.enums.BillSystemParamConfigEnum;
import kd.wtc.wtbs.common.enums.StoreSystemParamConfigEnum;
import kd.wtc.wtbs.common.enums.bill.BillOpenStyleEnum;
import kd.wtc.wtbs.common.model.bill.BillSystemParam;
import kd.wtc.wtbs.common.model.bill.BillSystemParamRange;
import kd.wtc.wtbs.common.util.WTCOrgUnitServiceHelper;
import kd.wtc.wtbs.common.util.WTTESystemParamQueryUtil;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class SystemParamQueryUtil {
    private static final Log Log = LogFactory.getLog(SystemParamQueryUtil.class);
    private static final String SYSTEM_DES = "systemdes";
    private static final String IS_DISPLAY_TAG = "isdisplaytag";
    private static final String VACATION_TAG = "vacationtag";
    private static final String TRAVEL_TAG = "traveltag";
    private static final String WORK_CALENDAR = "workcalendar";
    private static final String ROSTER = "roster";
    private static final String MAX_CAPACITY = "maxcapacity";
    private static final String UPLOAD_TYPES = "uploadtypes";
    private static final String MAX_UPLOAD_NUMS = "maxuploadnums";
    private static final String ATTACHMENT_FORMAT = "attachmentformat";
    private static final String INSHIFTOT = "inshiftot";
    private static final String WTTE = "wtte";
    private static final String BILL = "bill";
    private static final String VACATION_BILL = "vacationbill";
    private static final String ADJUSTMENT_BILL = "adjustmentbill";
    private static final String EVECTION_BILL = "evectionbill";
    private static final String OVERTIME_BILL = "overtimebill";
    private static final String SUPPLEMENT_BILL = "supplementbill";
    private static final String ACCESSTAG = "accesstag";
    public static final String SHOW_STACKTRACE = "showstacktrace";
    public static final String SIGNCARDMAXDATE = "signcardmaxdate";
    public static final String CHECKSUBMITTYPE = "checksubmittype";
    public static final String SUPCOUNTCALTYPE = "supcountcaltype";
    public static final String TIE_PLAN_ID = "tieplanid";
    public static final String STYLE_VA_CHOSE = "stylevachose";
    public static final String STYLE_OT_CHOSE = "styleotchose";
    public static final String STYLE_TRIP_CHOSE = "styletripchose";
    private static final String KEY_ATTSECRET = "attsecret";
    private static final String KEY_EID = "eid";
    public static final String ALLOW_EXT_BILL_ENTRY_FIELDS = "allowExtBillEntryFields";
    public static final String KD_WTC_WTSS_UNCHECKRIGTH2OPENOTHERBILL = "kd_wtc_wtss_uncheckrigth2openotherbill";

    public static Boolean isFrozenOpen() {
        long orgId = SystemParamQueryUtil.getWTCRootOrg();
        String appId = AppMetadataCache.getAppInfo((String)WTTE).getId();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        return (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"needfreeze");
    }

    public static Date getDefaultReCalDate(long orgId) {
        String appId = AppMetadataCache.getAppInfo((String)WTTE).getId();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        String dateStr = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"recaldate");
        Date reCalDate = null;
        try {
            reCalDate = HRDateTimeUtils.parseDate((String)dateStr, (String)"yyyy-MM-dd");
        }
        catch (ParseException exception) {
            return null;
        }
        return reCalDate;
    }

    public static BillSystemParam getBillSystemParam() {
        return SystemParamQueryUtil.getBillSystemParam(null);
    }

    public static BillSystemParam getBillSystemParam(Long orgId) {
        String appId = AppMetadataCache.getAppInfo((String)"wtp").getId();
        if (orgId == null) {
            orgId = SystemParamQueryUtil.getWTCRootOrg();
        }
        AppParam appParam = new AppParam(appId, orgId);
        Map map = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        BillSystemParam billSystemParam = BillSystemParam.builder().systemdes((String)map.get(SYSTEM_DES)).maxcapacity((Integer)map.get(MAX_CAPACITY)).maxuploadnums((Integer)map.get(MAX_UPLOAD_NUMS)).attachmentFormat((String)map.get(ATTACHMENT_FORMAT)).inShiftOt((Boolean)map.get(INSHIFTOT)).build();
        billSystemParam.setAccessTag((Boolean)map.get(ACCESSTAG));
        billSystemParam.setSignCardMaxDate(map.getOrDefault(SIGNCARDMAXDATE, 90));
        billSystemParam.setCheckSubmitType(map.getOrDefault(CHECKSUBMITTYPE, "2"));
        billSystemParam.setSupCountCalType(map.getOrDefault(SUPCOUNTCALTYPE, "1"));
        String defaultStyle = BillOpenStyleEnum.MULTI.getCode();
        billSystemParam.setBillStyleVa(map.getOrDefault(STYLE_VA_CHOSE, defaultStyle));
        billSystemParam.setBillStyleOt(map.getOrDefault(STYLE_OT_CHOSE, defaultStyle));
        billSystemParam.setBillStyleTrip(map.getOrDefault(STYLE_TRIP_CHOSE, defaultStyle));
        return billSystemParam;
    }

    public static boolean isFrozenAddSignCard() {
        long orgId = SystemParamQueryUtil.getWTCRootOrg();
        String appId = AppMetadataCache.getAppInfo((String)WTTE).getId();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        if (SystemParamQueryUtil.isFrozenOpen().booleanValue()) {
            Map map = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
            Object supplyOriginalCard = map.get("supplyoriginalcard");
            if (supplyOriginalCard == null) {
                return false;
            }
            return (Boolean)supplyOriginalCard;
        }
        return false;
    }

    public static Object loadAppParameterFromCache(String key, String appInfoKey) {
        long orgId = SystemParamQueryUtil.getWTCRootOrg();
        String appId = AppMetadataCache.getAppInfo((String)appInfoKey).getId();
        Log.debug("key:{}, appInfoKey:{}, orgId:{}, appId:{}", new Object[]{key, appInfoKey, orgId, appId});
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)key);
    }

    public static boolean queryRosterFrozenParam() {
        Boolean frozenOpen = SystemParamQueryUtil.isFrozenOpen();
        if (Boolean.FALSE.equals(frozenOpen)) {
            return false;
        }
        Object schedule = WTTESystemParamQueryUtil.loadAppParameterFromCache("schedule");
        Boolean isOpenSchedule = Boolean.FALSE;
        if (schedule instanceof Boolean) {
            isOpenSchedule = (Boolean)schedule;
        }
        return Boolean.TRUE.equals(isOpenSchedule);
    }

    public static Object getPublicParameter(String key) {
        return SystemParamServiceHelper.getPublicParameter((String)key);
    }

    public static BillSystemParamRange getBillSystemParamRange(BillSystemParamConfigEnum applyBillInfoEnum) {
        String appId = AppMetadataCache.getAppInfo((String)"wtp").getId();
        long orgId = SystemParamQueryUtil.getWTCRootOrg();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        Map systemParamMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        boolean flag = (Boolean)systemParamMap.get(applyBillInfoEnum.getKey());
        Log.info("all param ={}", (Object)systemParamMap);
        if (flag) {
            Object unitObj;
            BillSystemParamRange billSystemParamRange = new BillSystemParamRange();
            Object rangeObj = systemParamMap.get(applyBillInfoEnum.getRangeFieldName());
            if (rangeObj != null) {
                billSystemParamRange.setRange(Integer.parseInt(rangeObj.toString()));
            }
            if ((unitObj = systemParamMap.get(applyBillInfoEnum.getUnitFieldName())) != null) {
                billSystemParamRange.setUnit(String.valueOf(unitObj));
            }
            return billSystemParamRange;
        }
        return null;
    }

    public static Boolean store(StoreSystemParamConfigEnum storeSystemParamConfigEnum) {
        long orgId = SystemParamQueryUtil.getWTCRootOrg();
        String appId = AppMetadataCache.getAppInfo((String)WTTE).getId();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        return (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)storeSystemParamConfigEnum.getKey());
    }

    public static <T> T getValueByAppNumAndKey(String appNumber, String Key) {
        long orgId = SystemParamQueryUtil.getWTCRootOrg();
        String appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        return (T)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)Key);
    }

    public static long getDefaultTiePlanId() {
        long orgId;
        long tiePlanId = 0L;
        String appId = AppMetadataCache.getAppInfo((String)WTTE).getId();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId = SystemParamQueryUtil.getWTCRootOrg()));
        Object object = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)TIE_PLAN_ID);
        if (null != object) {
            if (object instanceof Map) {
                Object tempPlanId = ((Map)object).get("id");
                if (null != tempPlanId) {
                    tiePlanId = Long.parseLong(tempPlanId.toString());
                }
            } else if (object instanceof DynamicObject) {
                tiePlanId = ((DynamicObject)object).getLong("id");
            } else {
                Log.warn("getDefaultTiePlanId error: return data illegal, class:{}", object.getClass());
            }
        }
        return tiePlanId;
    }

    public static String getPunchCardAttSecret() {
        String appId = AppMetadataCache.getAppInfo((String)"wtis").getId();
        long orgId = SystemParamQueryUtil.getWTCRootOrg();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        Object object = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)KEY_ATTSECRET);
        return (String)object;
    }

    public static String getAppCustomParameter(String key) {
        AppCustomParam param = new AppCustomParam();
        param.setAppId(AppMetadataCache.getAppInfo((String)"wtp").getId());
        param.setSearchKeySet(Sets.newHashSet(key));
        Map paramMap = SystemParamServiceHelper.loadAppCustomParameterFromCache((AppCustomParam)param);
        if (paramMap == null || paramMap.get(key) == null) {
            return "";
        }
        return (String)paramMap.get(key);
    }

    public static long getWTCRootOrg() {
        return WTCOrgUnitServiceHelper.getHRDefaultRootOrgId();
    }
}

