/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.util;

import java.util.Arrays;

public class TimeUtils {
    public static final int SECOND = 0;
    public static final int MINUTE = 1;
    public static final int HOUR = 2;
    public static final int DAY = 3;
    private final int[] maxFields = new int[]{59, 59, 23, 0x7FFFFFFE};
    private final int[] minFields = new int[]{0, 0, 0, Integer.MIN_VALUE};
    private String timeSeparator = ":";
    private int[] fields = new int[4];

    public TimeUtils() {
        this(0, 0, 0, 0);
    }

    public TimeUtils(int hour, int minute) {
        this(0, hour, minute, 0);
    }

    public TimeUtils(int hour, int minute, int second) {
        this(0, hour, minute, second);
    }

    public TimeUtils(String time) {
        this(time, null);
    }

    public TimeUtils(int day, int hour, int minute, int second) {
        this.initialize(day, hour, minute, second);
    }

    public TimeUtils(String time, String timeSeparator) {
        if (timeSeparator != null) {
            this.timeSeparator = timeSeparator;
        }
        this.parseTime(time);
    }

    public void set(int field, int value) {
        if (value < this.minFields[field]) {
            throw new IllegalArgumentException(value + ", time value must be positive.");
        }
        this.fields[field] = value % (this.maxFields[field] + 1);
        int carry = value / (this.maxFields[field] + 1);
        if (carry > 0) {
            int upFieldValue = this.get(field + 1);
            this.set(field + 1, upFieldValue + carry);
        }
    }

    public int get(int field) {
        if (field < 0 || field > this.fields.length - 1) {
            throw new IllegalArgumentException(field + ", field value is error.");
        }
        return this.fields[field];
    }

    public TimeUtils addTime(TimeUtils time) {
        TimeUtils result = new TimeUtils();
        int up = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            int sum = this.fields[i] + time.fields[i] + up;
            up = sum / (this.maxFields[i] + 1);
            result.fields[i] = sum % (this.maxFields[i] + 1);
        }
        return result;
    }

    public TimeUtils subtractTime(TimeUtils time) {
        TimeUtils result = new TimeUtils();
        int down = 0;
        int k = this.fields.length - 1;
        for (int i = 0; i < k; ++i) {
            int difference = this.fields[i] + down;
            if (difference >= time.fields[i]) {
                difference -= time.fields[i];
                down = 0;
            } else {
                difference += this.maxFields[i] + 1 - time.fields[i];
                down = -1;
            }
            result.fields[i] = difference;
        }
        result.fields[3] = this.getField(3) - this.getField(time, 3) + down;
        return result;
    }

    private int getField(int fieldType) {
        return this.fields[fieldType];
    }

    private int getField(TimeUtils time, int fieldType) {
        return time.fields[fieldType];
    }

    public String getTimeSeparator() {
        return this.timeSeparator;
    }

    public void setTimeSeparator(String timeSeparator) {
        this.timeSeparator = timeSeparator;
    }

    private void initialize(int day, int hour, int minute, int second) {
        this.set(3, day);
        this.set(2, hour);
        this.set(1, minute);
        this.set(0, second);
    }

    private void parseTime(String time) {
        if (time == null) {
            this.initialize(0, 0, 0, 0);
            return;
        }
        String t = time;
        int field = 3;
        this.set(field--, 0);
        int p = -1;
        while ((p = t.indexOf(this.timeSeparator)) > -1) {
            this.parseTimeField(time, t.substring(0, p), field--);
            t = t.substring(p + this.timeSeparator.length());
        }
        this.parseTimeField(time, t, field--);
    }

    private void parseTimeField(String time, String t, int field) {
        if (field < 0 || t.length() < 1) {
            this.parseTimeException(time);
        }
        char[] chs = t.toCharArray();
        int n = 0;
        for (int i = 0; i < chs.length; ++i) {
            if (chs[i] <= ' ') continue;
            if (chs[i] >= '0' && chs[i] <= '9') {
                n = n * 10 + chs[i] - 48;
                continue;
            }
            this.parseTimeException(time);
        }
        this.set(field, n);
    }

    private void parseTimeException(String time) {
        throw new IllegalArgumentException(time + ", time format error, HH" + this.timeSeparator + "mm" + this.timeSeparator + "ss");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append(this.getField(3)).append(',').append(' ');
        this.buildString(sb, 2).append(this.timeSeparator);
        this.buildString(sb, 1).append(this.timeSeparator);
        this.buildString(sb, 0);
        return sb.toString();
    }

    public String getHourMinuteString() {
        StringBuilder sb = new StringBuilder(16);
        this.buildString(sb, 2).append(this.timeSeparator);
        this.buildString(sb, 1);
        return sb.toString();
    }

    private StringBuilder buildString(StringBuilder sb, int field) {
        if (this.fields[field] < 10) {
            sb.append('0');
        }
        return sb.append(this.fields[field]);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.fields);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeUtils other = (TimeUtils)obj;
        return Arrays.equals(this.fields, other.fields);
    }
}

