/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.orm.util.CollectionUtils;

public class WTCBatchHandleUtils {
    public static <T, U, R> void batchHandleCollection(Collection<R> returnList, List<T> dataList, int maxValue, U u, BiFunction<List<T>, U, Collection<R>> function) {
        if (CollectionUtils.isEmpty(dataList) || returnList == null) {
            return;
        }
        List copeDataList = dataList.stream().distinct().collect(Collectors.toList());
        int size = copeDataList.size();
        for (int index = 0; index < size; index += maxValue) {
            List consumerList;
            Collection<R> apply;
            int end = index + maxValue;
            int limit = maxValue;
            if (end > size) {
                end = size;
                limit = maxValue - (end - size);
            }
            if ((apply = function.apply(consumerList = copeDataList.stream().skip(index).limit(limit).collect(Collectors.toList()), u)) == null || apply.isEmpty()) continue;
            returnList.addAll(apply);
        }
    }

    public static <T, U, K, V> void batchHandleMap(Map<K, V> returnMap, List<T> dataList, int maxValue, U u, BiFunction<List<T>, U, Map<K, V>> function) {
        if (CollectionUtils.isEmpty(dataList) || returnMap == null) {
            return;
        }
        List copeDataList = dataList.stream().distinct().collect(Collectors.toList());
        int size = copeDataList.size();
        for (int index = 0; index < size; index += maxValue) {
            List consumerList;
            Map<K, V> apply;
            int end = index + maxValue;
            int limit = maxValue;
            if (end > size) {
                end = size;
                limit = maxValue - (end - size);
            }
            if ((apply = function.apply(consumerList = copeDataList.stream().skip(index).limit(limit).collect(Collectors.toList()), u)) == null || apply.isEmpty()) continue;
            returnMap.putAll(apply);
        }
    }

    public static <T, K, V> void batchHandleMap(Map<K, V> returnMap, List<T> dataList, int maxValue, Function<List<T>, Map<K, V>> function) {
        if (CollectionUtils.isEmpty(dataList) || returnMap == null) {
            return;
        }
        List copeDataList = dataList.stream().distinct().collect(Collectors.toList());
        int size = copeDataList.size();
        for (int index = 0; index < size; index += maxValue) {
            List consumerList;
            Map<K, V> apply;
            int end = index + maxValue;
            int limit = maxValue;
            if (end > size) {
                end = size;
                limit = maxValue - (end - size);
            }
            if ((apply = function.apply(consumerList = copeDataList.stream().skip(index).limit(limit).collect(Collectors.toList()))) == null || apply.isEmpty()) continue;
            returnMap.putAll(apply);
        }
    }
}

