/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class WTCCollections {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !WTCCollections.isEmpty(collection);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !WTCCollections.isEmpty(map);
    }

    public static <T> boolean addIfNotFull(Collection<T> collection, T t, int maxCapacity) {
        if (maxCapacity <= 0 || collection.size() >= maxCapacity) {
            return false;
        }
        collection.add(t);
        return true;
    }

    public static <T> List<T> unmodifiableList(@Nullable List<? extends T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public static <T> Stream<T> nonNullStream(Collection<T> cols) {
        return cols.stream().filter(Objects::nonNull);
    }

    public static <T> List<T> modifiableEmptyList() {
        return new ArrayList(0);
    }

    public static <T> List<T> modifiableList(T ... obj) {
        if (obj == null) {
            return WTCCollections.modifiableEmptyList();
        }
        return new ArrayList<T>(Arrays.asList(obj));
    }

    public static <T> List<T> modifiableListWithCap(int initialArraySize) {
        WTCCollections.checkNonnegative(initialArraySize, "initialArraySize");
        return new ArrayList(initialArraySize);
    }

    private static int checkNonnegative(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(name + " cannot be negative but was: " + value);
        }
        return value;
    }

    public static <T> Set<T> modifiableEmptySet() {
        return new HashSet(0);
    }

    public static <T> Set<T> modifiableSet(T ... obj) {
        if (obj == null) {
            return WTCCollections.modifiableEmptySet();
        }
        return new HashSet<T>(Arrays.asList(obj));
    }

    public static <K, V> Map<K, V> modifiableEmptyMap() {
        return new HashMap(0);
    }

    public static <K, V> Map<K, V> modifiableMap(K key, V val) {
        HashMap<K, V> map = new HashMap<K, V>(4);
        map.put(key, val);
        return map;
    }

    public static <T> List<T> subList(List<T> list, int fromIndex, int toIndex) {
        if (WTCCollections.isEmpty(list) || fromIndex < 0 || toIndex <= fromIndex) {
            return Collections.emptyList();
        }
        return list.stream().skip(fromIndex).limit(toIndex - fromIndex).collect(Collectors.toList());
    }

    private WTCCollections() {
    }
}

