/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class WTCConcurrentHashSet<E>
extends AbstractSet<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 6316777033551717407L;
    protected final ConcurrentHashMap<E, Boolean> map;

    public WTCConcurrentHashSet() {
        this.map = new ConcurrentHashMap();
    }

    public WTCConcurrentHashSet(int initialCapacity) {
        this.map = new ConcurrentHashMap(initialCapacity);
    }

    public WTCConcurrentHashSet(Collection<? extends E> collection) {
        this.map = new ConcurrentHashMap(Math.max((int)((float)collection.size() / 0.75f) + 1, 16));
        this.addAll(collection);
    }

    @Override
    public Iterator<E> iterator() {
        return ((ConcurrentHashMap.KeySetView)this.map.keySet()).iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        return this.map.containsKey(obj);
    }

    @Override
    public boolean add(E ekey) {
        return this.map.put(ekey, Boolean.TRUE) == null;
    }

    @Override
    public boolean remove(Object obj) {
        return this.map.remove(obj) == Boolean.TRUE;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public String toString() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.map.keySet())).toString();
    }
}

