/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.DateUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class WTCDateUtils {
    private static final Log log = WTCLogFactory.getLog(WTCDateUtils.class);
    public static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMMDD = "yyyy-MM-dd";
    public static final String YYYYMMDDHHMMSS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMMDDHHMM = "yyyy-MM-dd HH:mm";
    public static final String HM = "h:m";

    public static boolean hasIntersectionLCRC(Date start1, Date end1, Date start2, Date end2) {
        return end1.getTime() >= start2.getTime() && start1.getTime() <= end2.getTime();
    }

    public static boolean hasIntersectionLCRO(Date start1, Date end1, Date start2, Date end2) {
        return end1.getTime() > start2.getTime() && start1.getTime() < end2.getTime();
    }

    public static Date getShiftZeroMomentDate(Date base, int offset) {
        return WTCDateUtils.getZeroDate(WTCDateUtils.getCustomDate(base, offset));
    }

    public static Date getShiftLastMomentDate(Date base, int offset) {
        return WTCDateUtils.getDayLastDate(WTCDateUtils.getCustomDate(base, offset));
    }

    public static Date getFirstDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int firstDay = cal.getMinimum(5);
        cal.set(5, firstDay);
        return cal.getTime();
    }

    public static Date getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        return cal.getTime();
    }

    public static LocalDateTime toLocalDateTime(Date date, LocalTime localTime) {
        if (null == date || localTime == null) {
            return null;
        }
        return LocalDateTime.of(WTCDateUtils.toLocalDate(date), localTime);
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        if (null == date) {
            return null;
        }
        return LocalDateTime.ofInstant(date.toInstant(), KDDateUtils.getSysTimeZone().toZoneId());
    }

    public static LocalDate toLocalDate(Date date) {
        if (null == date) {
            return null;
        }
        return date.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate();
    }

    public static Date toDate(LocalDateTime localDateTime) {
        if (null == localDateTime) {
            return null;
        }
        return Date.from(localDateTime.atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
    }

    public static Date toDate(LocalDate localDate) {
        if (null == localDate) {
            return null;
        }
        return Date.from(localDate.atStartOfDay(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
    }

    public static Date toDate(Date date, LocalTime localTime) {
        if (null == date || null == localTime) {
            return null;
        }
        return WTCDateUtils.toDate(WTCDateUtils.toLocalDateTime(date, localTime));
    }

    public static Date getZeroDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDayLastDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getDayBegin() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getDayBegin(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getDayEnd() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Date getBeginDayOfYesterday() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(WTCDateUtils.getDayBegin());
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static Date getEndDayOfYesterday() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(WTCDateUtils.getDayEnd());
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static Date getBeginDayOfTomorrow() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(WTCDateUtils.getDayBegin());
        ((Calendar)cal).add(5, 1);
        return cal.getTime();
    }

    public static Date getEndDayOfTomorrow() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(WTCDateUtils.getDayEnd());
        ((Calendar)cal).add(5, 1);
        return cal.getTime();
    }

    public static Date getBeginDayOfWeek() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek);
        return WTCDateUtils.getDayStartTime(cal.getTime());
    }

    public static Date getBeginDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek);
        return WTCDateUtils.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(Objects.requireNonNull(WTCDateUtils.getBeginDayOfWeek()));
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return WTCDateUtils.getDayEndTime(weekEndSta);
    }

    public static Date getEndDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(Objects.requireNonNull(WTCDateUtils.getBeginDayOfWeek(date)));
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return WTCDateUtils.getDayEndTime(weekEndSta);
    }

    public static int getDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(7) - 1;
        if (w == 0) {
            return 7;
        }
        return w;
    }

    public static Date getCustomDate(Date date, Integer custom) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, custom);
        return cal.getTime();
    }

    public static Date getCustomMouth(Date date, Integer custom) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, custom);
        return cal.getTime();
    }

    public static Date getBeforeDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date getNextDate(Date date) {
        return WTCDateUtils.getCustomDate(date, 1);
    }

    public static Date getBeginDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(WTCDateUtils.getNowYear(), WTCDateUtils.getNowMonth() - 1, 1);
        return WTCDateUtils.getDayStartTime(calendar.getTime());
    }

    public static Date getBeginDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(HRDateTimeUtils.getYear((Date)date), WTCDateUtils.getNowMonth(date) - 1, 1);
        return WTCDateUtils.getDayStartTime(calendar.getTime());
    }

    public static Date getEndDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(WTCDateUtils.getNowYear(), WTCDateUtils.getNowMonth() - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(WTCDateUtils.getNowYear(), WTCDateUtils.getNowMonth() - 1, day);
        return WTCDateUtils.getDayEndTime(calendar.getTime());
    }

    public static Date getEndDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int nowYear = HRDateTimeUtils.getYear((Date)date);
        int nowMonth = WTCDateUtils.getNowMonth(date);
        calendar.set(nowYear, nowMonth - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(nowYear, nowMonth - 1, day);
        return WTCDateUtils.getDayEndTime(calendar.getTime());
    }

    public static Date getEndDayOfMonth(Date date, boolean isUpdateHMS) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int nowYear = HRDateTimeUtils.getYear((Date)date);
        int nowMonth = WTCDateUtils.getNowMonth(date);
        calendar.set(nowYear, nowMonth - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(nowYear, nowMonth - 1, day);
        if (!isUpdateHMS) {
            return calendar.getTime();
        }
        return WTCDateUtils.getDayEndTime(calendar.getTime());
    }

    public static Date getStartDayOfQuarter() {
        LocalDate today = LocalDate.now();
        Month month = today.getMonth();
        Month firstMonthOfQuarter = month.firstMonthOfQuarter();
        LocalDate resDate = LocalDate.of(today.getYear(), firstMonthOfQuarter, 1);
        return WTCDateUtils.toDate(resDate);
    }

    public static Date getStartDayOfQuarter(Date date) {
        LocalDate today = WTCDateUtils.toLocalDate(date);
        if (today == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"WTCDateUtils_0", (String)"wtc-wtbs-common", (Object[])new Object[0]));
        }
        Month month = today.getMonth();
        Month firstMonthOfQuarter = month.firstMonthOfQuarter();
        today = LocalDate.of(today.getYear(), firstMonthOfQuarter, 1);
        return WTCDateUtils.toDate(today);
    }

    public static Date getEndDayOfQuarter() {
        LocalDate today = LocalDate.now();
        LocalDate resDate = LocalDate.now();
        if (today == null) {
            today = resDate;
        }
        Month month = today.getMonth();
        Month firstMonthOfQuarter = month.firstMonthOfQuarter();
        Month endMonthOfQuarter = Month.of(firstMonthOfQuarter.getValue() + 2);
        resDate = LocalDate.of(today.getYear(), endMonthOfQuarter, endMonthOfQuarter.length(today.isLeapYear()));
        return WTCDateUtils.toDate(resDate);
    }

    public static Date getEndDayOfQuarter(Date date) {
        LocalDate today = WTCDateUtils.toLocalDate(date);
        if (today == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"WTCDateUtils_0", (String)"wtc-wtbs-common", (Object[])new Object[0]));
        }
        Month month = today.getMonth();
        Month firstMonthOfQuarter = month.firstMonthOfQuarter();
        Month endMonthOfQuarter = Month.of(firstMonthOfQuarter.getValue() + 2);
        today = LocalDate.of(today.getYear(), endMonthOfQuarter, endMonthOfQuarter.length(today.isLeapYear()));
        return WTCDateUtils.toDate(today);
    }

    public static Date getBeginDayOfNextWeek() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek + 7);
        return WTCDateUtils.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfNextWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(Objects.requireNonNull(WTCDateUtils.getBeginDayOfNextWeek()));
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return WTCDateUtils.getDayEndTime(weekEndSta);
    }

    public static Date getBeginDayOfLastWeek() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek - 7);
        return WTCDateUtils.getDayStartTime(cal.getTime());
    }

    public static int getDayOfWeekInCalendar(int dayOfWeek) {
        if (dayOfWeek < 0) {
            return 0;
        }
        return dayOfWeek + 1 > 7 ? (dayOfWeek + 1) % 7 : dayOfWeek + 1;
    }

    public static Date getBeginDayOfLastWeek(Date date, int firstDayOfWeek) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.setFirstDayOfWeek(firstDayOfWeek);
        cal.add(3, -1);
        cal.set(7, firstDayOfWeek);
        return WTCDateUtils.getZeroDate(cal.getTime());
    }

    public static Date getEndDayOfLastWeek(Date date, int firstDayOfWeek) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.setFirstDayOfWeek(firstDayOfWeek);
        cal.add(3, -1);
        int lastDayOfWeek = firstDayOfWeek + 6;
        cal.set(7, lastDayOfWeek > 7 ? lastDayOfWeek % 7 : lastDayOfWeek);
        return WTCDateUtils.getZeroDate(cal.getTime());
    }

    public static Date getBeginDayOfWeek(Date date, int firstDayOfWeek) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.setFirstDayOfWeek(firstDayOfWeek);
        cal.set(7, firstDayOfWeek);
        return WTCDateUtils.getZeroDate(cal.getTime());
    }

    public static Date getEndDayOfWeek(Date date, int firstDayOfWeek) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.setFirstDayOfWeek(firstDayOfWeek);
        int lastDayOfWeek = firstDayOfWeek + 6;
        cal.set(7, lastDayOfWeek > 7 ? lastDayOfWeek % 7 : lastDayOfWeek);
        return WTCDateUtils.getZeroDate(cal.getTime());
    }

    public static Date getBeginDayOfNextWeek(Date date, int firstDayOfWeek) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.setFirstDayOfWeek(firstDayOfWeek);
        cal.add(3, 1);
        cal.set(7, firstDayOfWeek);
        return WTCDateUtils.getZeroDate(cal.getTime());
    }

    public static Date getEndDayOfNextWeek(Date date, int firstDayOfWeek) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.setFirstDayOfWeek(firstDayOfWeek);
        cal.add(3, 1);
        int lastDayOfWeek = firstDayOfWeek + 6;
        cal.set(7, lastDayOfWeek > 7 ? lastDayOfWeek % 7 : lastDayOfWeek);
        return WTCDateUtils.getZeroDate(cal.getTime());
    }

    public static Date getYesterday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, -1);
        return WTCDateUtils.getZeroDate(cal.getTime());
    }

    public static Date getEndDayOfLastWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(Objects.requireNonNull(WTCDateUtils.getBeginDayOfLastWeek()));
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return WTCDateUtils.getDayEndTime(weekEndSta);
    }

    public static Date getBeginDayOfYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, WTCDateUtils.getNowYear());
        cal.set(2, 0);
        cal.set(5, 1);
        return WTCDateUtils.getDayStartTime(cal.getTime());
    }

    public static Date getBeginDayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 0);
        cal.set(5, 1);
        return WTCDateUtils.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, WTCDateUtils.getNowYear());
        cal.set(2, 11);
        cal.set(5, 31);
        return WTCDateUtils.getDayEndTime(cal.getTime());
    }

    public static Date getEndDayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 11);
        cal.set(5, 31);
        return WTCDateUtils.getDayEndTime(cal.getTime());
    }

    @Deprecated
    public static Date getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    public static Date getDayStart(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null == d) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WTCDateUtils_2", (String)"wtc-wtbs-common", (Object[])new Object[0]));
        }
        calendar.setTime(d);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    @Deprecated
    public static Date getDayEndTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Date(calendar.getTimeInMillis());
    }

    public static Date getDayEnd(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null == d) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WTCDateUtils_2", (String)"wtc-wtbs-common", (Object[])new Object[0]));
        }
        calendar.setTime(d);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Date(calendar.getTimeInMillis());
    }

    public static Integer getNowYear() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(1);
    }

    public static int getNowMonth() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(2) + 1;
    }

    public static int getNowMonth(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(2) + 1;
    }

    public static String secondToTime(long second, String format) {
        long hours = second / 3600L;
        long minutes = (second %= 3600L) / 60L;
        format = format.replaceFirst("h", WTCDateUtils.getDateStr(hours));
        format = format.replaceFirst("m", WTCDateUtils.getDateStr(minutes));
        format = format.replaceFirst("s", WTCDateUtils.getDateStr(second %= 60L));
        return format;
    }

    private static String getDateStr(Long value) {
        StringBuilder builder = new StringBuilder();
        if (value < 10L) {
            builder.append('0');
        }
        builder.append(value);
        return builder.toString();
    }

    public static LocalTime secondToTime(long second) {
        long hours = (second %= 86400L) / 3600L;
        long minutes = (second %= 3600L) / 60L;
        return LocalTime.of((int)hours, (int)minutes);
    }

    public static int calcDuringSecond(LocalDateTime beginDate, LocalDateTime endDate) {
        return (int)Duration.between(beginDate, endDate).toMillis() / 1000;
    }

    public static int daysBetween(Date startDate, Date endDate) {
        Calendar cStart = Calendar.getInstance();
        Calendar cEnd = Calendar.getInstance();
        cStart.setTime(startDate);
        cEnd.setTime(endDate);
        WTCDateUtils.setTimeToMidnight(cStart);
        WTCDateUtils.setTimeToMidnight(cEnd);
        long startMs = cStart.getTimeInMillis();
        long endMs = cEnd.getTimeInMillis();
        long intervalMs = endMs - startMs;
        return WTCDateUtils.millisecondsToDays(intervalMs);
    }

    public static void setTimeToMidnight(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
    }

    private static int millisecondsToDays(long intervalMs) {
        return (int)(intervalMs / 86400000L);
    }

    public static Date str2Date(String str, String format) {
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(str);
        }
        catch (ParseException var5) {
            return null;
        }
    }

    public static String date2Str(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static Date date2date(Date date, String pattern) {
        String formatStr = WTCDateUtils.date2Str(date, pattern);
        return WTCDateUtils.str2Date(formatStr, pattern);
    }

    public static Date getLastDayOfMonth(String yearMonth) {
        int year = Integer.parseInt(yearMonth.split("-")[0]);
        int month = Integer.parseInt(yearMonth.split("-")[1]);
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        int lastDay = cal.getMinimum(5);
        cal.set(5, lastDay - 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getBeginDayOfMonth(String yearMonth) {
        int year = Integer.parseInt(yearMonth.split("-")[0]);
        int month = Integer.parseInt(yearMonth.split("-")[1]);
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static boolean betweenDay(Date verifyDate, Date startDate, Date endDate) {
        if (verifyDate == null || startDate == null || endDate == null) {
            throw new IllegalArgumentException("date can not be null");
        }
        return verifyDate.getTime() >= startDate.getTime() && verifyDate.getTime() <= endDate.getTime();
    }

    public static int monthBetween(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return 0;
        }
        Calendar cStart = Calendar.getInstance();
        Calendar cEnd = Calendar.getInstance();
        cStart.setTime(startDate);
        cEnd.setTime(endDate);
        int yearDiff = (cStart.get(1) - cEnd.get(1)) * 12;
        int monthDiff = cStart.get(2) - cEnd.get(2);
        return Math.abs(yearDiff + monthDiff);
    }

    public static boolean betweenDayNotEquals(Date verifyDate, Date startDate, Date endDate) {
        if (verifyDate == null || startDate == null || endDate == null) {
            throw new IllegalArgumentException("date can not be null");
        }
        return verifyDate.getTime() > startDate.getTime() && verifyDate.getTime() < endDate.getTime();
    }

    public static boolean betweenTimeEquals(Date verifyDate, Date startDate, Date endDate) {
        if (verifyDate == null || startDate == null || endDate == null) {
            throw new IllegalArgumentException("date can not be null");
        }
        return verifyDate.getTime() >= startDate.getTime() && verifyDate.getTime() <= endDate.getTime();
    }

    public static boolean betweenDateNotEquals(Date verifyDate, Date startDate, Date endDate) {
        if (verifyDate == null || startDate == null || endDate == null) {
            throw new IllegalArgumentException("date can not be null");
        }
        return DateUtils.truncatedCompareTo((Date)verifyDate, (Date)startDate, (int)5) > 0 && DateUtils.truncatedCompareTo((Date)verifyDate, (Date)endDate, (int)5) < 0;
    }

    public static boolean betweenDate(LocalDate verifyDate, LocalDate startDate, LocalDate endDate) {
        if (verifyDate == null || startDate == null || endDate == null) {
            throw new IllegalArgumentException("date can not be null");
        }
        return verifyDate.compareTo(startDate) >= 0 && verifyDate.compareTo(endDate) <= 0;
    }

    public static boolean isOverlappingNotEquals(Date startDate1, Date endDate1, Date startDate2, Date endDate2) {
        return WTCDateUtils.betweenDateNotEquals(startDate1, startDate2, endDate2) || WTCDateUtils.betweenDateNotEquals(endDate1, startDate2, endDate2) || WTCDateUtils.betweenDateNotEquals(startDate2, startDate1, endDate1);
    }

    public static boolean isOverlapping(Date startDate1, Date endDate1, Date startDate2, Date endDate2) {
        return !startDate1.before(endDate1) || !startDate2.before(endDate2) || endDate2.compareTo(startDate1) > 0 && startDate2.compareTo(endDate1) < 0;
    }

    public static List<Date> getDays(Date start, Date end) {
        ArrayList<Date> result = new ArrayList<Date>(10);
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(start);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(end);
        while (startCal.before(endCal)) {
            result.add(startCal.getTime());
            startCal.add(6, 1);
        }
        result.add(startCal.getTime());
        return result;
    }

    public static long getDateInsectionTimes(Date start, Date end, Date start2, Date end2) {
        if (start.after(end2) || start2.after(end)) {
            return 0L;
        }
        Date validStart = WTCDateUtils.getLatestDate(start, start2);
        Date validEnd = WTCDateUtils.getEarlistDate(end, end2);
        return validEnd != null && validStart != null ? (validEnd.getTime() - validStart.getTime()) / 1000L : 0L;
    }

    public static Date getEarlistDate(Date ... dates) {
        Date res = null;
        for (Date date : dates) {
            res = res == null ? date : (date == null ? res : (date.after(res) ? res : date));
        }
        return res;
    }

    public static Date getLatestDate(Date ... dates) {
        Date res = null;
        for (Date date : dates) {
            res = res == null ? date : (date == null ? res : (date.after(res) ? date : res));
        }
        return res;
    }

    public static Date getDate(Date date, Integer second) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(13, second);
        return cal.getTime();
    }

    public static Date getMaxEndDate() {
        Date endDate = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(YYYYMMDD);
            endDate = sdf.parse("2999-12-31");
        }
        catch (Exception var3) {
            log.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef");
        }
        return endDate;
    }

    public static Date getMinEndDate() {
        Date endDate = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(YYYYMMDD);
            endDate = sdf.parse("1900-01-01");
        }
        catch (Exception var3) {
            log.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef");
        }
        return endDate;
    }

    public static Date getDayStartSec(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    public static LocalDate getLocalDateByCalendarIns(Calendar calendar) {
        return LocalDate.of(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    @Deprecated
    public static long nano2millis(long nano) {
        return nano / 1000000L;
    }

    public static String format(LocalDate localDate) {
        if (localDate == null) {
            return "";
        }
        return localDate.format(DateTimeFormatter.ofPattern(YYYYMMDD));
    }

    public static String format(LocalDate localDate, String format) {
        if (localDate == null) {
            return "";
        }
        return localDate.format(DateTimeFormatter.ofPattern(format));
    }

    public static Date getMinDate(Date ... dateArr) {
        Date min = null;
        for (Date date : dateArr) {
            if (date == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"WTCDateUtils_1", (String)"wtc-wtbs-common", (Object[])new Object[0]));
            }
            if (min == null) {
                min = date;
            }
            if (min.compareTo(date) <= 0) continue;
            min = date;
        }
        return min;
    }

    public static Date getMaxDate(Date ... dateArr) {
        Date max = null;
        for (Date date : dateArr) {
            if (date == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"WTCDateUtils_1", (String)"wtc-wtbs-common", (Object[])new Object[0]));
            }
            if (max == null) {
                max = date;
            }
            if (max.compareTo(date) >= 0) continue;
            max = date;
        }
        return max;
    }

    public static Date getMinDate(Date date1, Date date2) {
        return date1.compareTo(date2) > 0 ? date2 : date1;
    }

    public static Date getMaxDate(Date date1, Date date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        return date1.compareTo(date2) > 0 ? date1 : date2;
    }

    public static Date addDays(Date date, int days) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static Date add(Date date, int unit, int time) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(unit, time);
        return calendar.getTime();
    }

    public static Date parseDate(String s, String fmt) throws ParseException {
        return WTCDateUtils.parseDate(s, fmt, null);
    }

    public static Date parseDate(String s, String fmt, TimeZone timezone) throws ParseException {
        return WTCDateUtils.parseDate(s, fmt, timezone, null);
    }

    public static Date parseDate(String s, String fmt, TimeZone timezone, Locale locale) throws ParseException {
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(fmt, locale);
        if (timezone == null) {
            timezone = KDDateUtils.getSysTimeZone();
        }
        df.setTimeZone(timezone);
        df.setLenient(false);
        return df.parse(s);
    }

    public static int getDay(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(5);
    }

    public static int getSecondOfDay(Date date) {
        LocalDateTime localDateTime = date.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDateTime();
        LocalTime localTime = LocalTime.of(localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
        return localTime.toSecondOfDay();
    }

    public static int getSecondsOfDay(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = KDDateUtils.getSysTimeZone().toZoneId();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalTime localTime = localDateTime.toLocalTime();
        return localTime.getHour() * 3600 + localTime.getMinute() * 60 + localTime.getSecond();
    }

    public static boolean compareDateWithDayTime(Date date1, Date date2) {
        SimpleDateFormat format = new SimpleDateFormat(YYYYMMDD);
        if (date1 == null || date2 == null) {
            return false;
        }
        return format.format(date1).equals(format.format(date2));
    }

    public static List<Date> getDateRange(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            throw new IllegalArgumentException("startTime and endTime should not be null");
        }
        Date startTime = WTCDateUtils.getDayStartTime(startDate);
        Date endTime = WTCDateUtils.getDayStartTime(endDate);
        ArrayList<Date> dateRange = Lists.newArrayListWithExpectedSize(10);
        Date lastDate = startTime;
        while (lastDate.getTime() <= endTime.getTime()) {
            dateRange.add(lastDate);
            lastDate = HRDateTimeUtils.addDay((Date)lastDate, (long)1L);
        }
        return dateRange;
    }

    public static Date cutDateSecondAndMillisecond(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("input date should not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static LinkedHashSet<LocalDate> getLocalDateRange(Date date1, Date date2) {
        LinkedHashSet<LocalDate> localeDate = new LinkedHashSet<LocalDate>(16);
        if (date1 == null || date2 == null) {
            return localeDate;
        }
        List<Date> dateRange = WTCDateUtils.getDateRange(date1, date2);
        for (Date date : dateRange) {
            localeDate.add(WTCDateUtils.toLocalDate(date));
        }
        return localeDate;
    }

    public static List<Tuples.Tuple2<LocalDate, LocalDate>> getTimeCross(Tuples.Tuple2<LocalDate, LocalDate> group1, Tuples.Tuple2<LocalDate, LocalDate> group2) {
        boolean checkNull;
        boolean bl = checkNull = group1 == null || group2 == null;
        if (checkNull) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ea4\u96c6\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WTCDateUtils_3", (String)"wtc-wtbs-common", (Object[])new Object[0]));
        }
        LocalDate groupStartFirst = (LocalDate)group1.item1;
        LocalDate groupEndFirst = (LocalDate)group1.item2;
        LocalDate groupStartSecond = (LocalDate)group2.item1;
        LocalDate groupEndSecond = (LocalDate)group2.item2;
        boolean bl2 = checkNull = groupStartFirst == null || groupEndFirst == null || groupStartSecond == null || groupEndSecond == null;
        if (checkNull) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ea4\u96c6\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WTCDateUtils_3", (String)"wtc-wtbs-common", (Object[])new Object[0]));
        }
        if (groupStartFirst.isAfter(groupEndFirst) || groupStartSecond.isAfter(groupEndSecond)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u5141\u8bb8\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\u3002", (String)"WTCDateUtils_4", (String)"wtc-wtbs-common", (Object[])new Object[0]));
        }
        List allDate = Lists.newArrayList(groupStartFirst, groupEndFirst, groupStartSecond, groupEndSecond).stream().sorted().collect(Collectors.toList());
        Optional eleFromList = WTCCollectionIndexUtil.getEleFromList(allDate, 0);
        if (!eleFromList.isPresent()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WTCDateUtils_5", (String)"wtc-wtbs-common", (Object[])new Object[0]));
        }
        if (groupEndFirst.isBefore(groupStartSecond) || groupStartFirst.isAfter(groupEndSecond)) {
            return Collections.emptyList();
        }
        if (groupStartFirst.isBefore(groupStartSecond) && groupStartSecond.isBefore(groupEndFirst) && groupEndFirst.isBefore(groupEndSecond)) {
            return Lists.newArrayList(new Tuples.Tuple2<LocalDate, LocalDate>(groupStartSecond, groupEndFirst));
        }
        if (groupStartFirst.isBefore(groupStartSecond) && groupStartSecond.isEqual(groupEndFirst) && groupEndFirst.isBefore(groupEndSecond)) {
            return Lists.newArrayList(new Tuples.Tuple2<LocalDate, LocalDate>(groupStartSecond, groupEndFirst));
        }
        if (groupStartFirst.isBefore(groupStartSecond) && groupStartSecond.isBefore(groupEndSecond) && groupEndSecond.isBefore(groupEndFirst)) {
            return Lists.newArrayList(new Tuples.Tuple2<LocalDate, LocalDate>(groupStartSecond, groupEndSecond));
        }
        if (groupStartFirst.isBefore(groupStartSecond) && groupStartSecond.isEqual(groupEndSecond) && groupEndSecond.isBefore(groupEndFirst)) {
            return Lists.newArrayList(new Tuples.Tuple2<LocalDate, LocalDate>(groupStartSecond, groupEndSecond));
        }
        if (groupStartSecond.isBefore(groupStartFirst) && groupStartFirst.isBefore(groupEndSecond) && groupEndSecond.isBefore(groupEndFirst)) {
            return Lists.newArrayList(new Tuples.Tuple2<LocalDate, LocalDate>(groupStartFirst, groupEndSecond));
        }
        if (groupStartSecond.isBefore(groupStartFirst) && groupStartFirst.isEqual(groupEndSecond) && groupEndSecond.isBefore(groupEndFirst)) {
            return Lists.newArrayList(new Tuples.Tuple2<LocalDate, LocalDate>(groupStartFirst, groupEndSecond));
        }
        if (groupStartSecond.isBefore(groupStartFirst) && groupStartFirst.isBefore(groupEndFirst) && groupEndFirst.isBefore(groupEndSecond)) {
            return Lists.newArrayList(new Tuples.Tuple2<LocalDate, LocalDate>(groupStartFirst, groupEndFirst));
        }
        if (groupStartSecond.isBefore(groupStartFirst) && groupStartFirst.isEqual(groupEndFirst) && groupEndFirst.isBefore(groupEndSecond)) {
            return Lists.newArrayList(new Tuples.Tuple2<LocalDate, LocalDate>(groupStartFirst, groupEndFirst));
        }
        if (groupStartFirst.isEqual(groupStartSecond) && groupEndFirst.isBefore(groupEndSecond)) {
            return Lists.newArrayList(new Tuples.Tuple2<LocalDate, LocalDate>(groupStartFirst, groupEndFirst));
        }
        if (groupStartFirst.isEqual(groupStartSecond) && groupEndSecond.isBefore(groupEndFirst)) {
            return Lists.newArrayList(new Tuples.Tuple2<LocalDate, LocalDate>(groupStartSecond, groupEndSecond));
        }
        if (groupStartFirst.isBefore(groupStartSecond) && groupEndFirst.isEqual(groupEndSecond)) {
            return Lists.newArrayList(new Tuples.Tuple2<LocalDate, LocalDate>(groupStartSecond, groupEndSecond));
        }
        if (groupStartSecond.isBefore(groupStartFirst) && groupEndFirst.isEqual(groupEndSecond)) {
            return Lists.newArrayList(new Tuples.Tuple2<LocalDate, LocalDate>(groupStartFirst, groupEndFirst));
        }
        if (groupStartFirst.isEqual(groupStartSecond) && groupEndFirst.isEqual(groupEndSecond)) {
            return Lists.newArrayList(new Tuples.Tuple2<LocalDate, LocalDate>(groupStartFirst, groupStartSecond));
        }
        log.warn("WTCDateUtils_getTimeCross \u672a\u8bc6\u522b\u7684\u4ea4\u96c6\u573a\u666f \u3002 groupStartFirst = {},groupStartSecond ={},groupEndFirst = {},groupEndSecond = {}", new Object[]{groupStartFirst, groupStartSecond, groupEndFirst, groupEndSecond});
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u7684\u4ea4\u96c6\u573a\u666f\u3002", (String)"WTCDateUtils_6", (String)"wtc-wtbs-common", (Object[])new Object[0]));
    }
}

