/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.util;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.IFormat;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.service.InteTimeZone;
import kd.bos.service.KDDateUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class WTCInteDateUtil {
    private static final Log LOG = WTCLogFactory.getLog(WTCInteDateUtil.class);

    public static String formatByModel(String entityNumber, String fieldKey, Date date) {
        if (date == null) {
            return "";
        }
        BillEntityType type = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
        DateTimeProp property = (DateTimeProp)type.findProperty(fieldKey);
        return WTCInteDateUtil.formatDateByFieldProp(property, date, 0L);
    }

    public static String formatDateBySysTzAndUserFmt(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat userSimpleDateFormat = WTCInteDateUtil.getUserSimpleDateFormat();
        userSimpleDateFormat.setTimeZone(WTCInteDateUtil.getSysTimeZone().getTimeZone());
        return userSimpleDateFormat.format(date);
    }

    public static String formatLocalDateBySysTzAndUserFmt(LocalDate localDate) {
        if (localDate == null) {
            return "";
        }
        try {
            return WTCInteDateUtil.formatDateBySysTzAndUserFmt(Date.from(localDate.atStartOfDay(KDDateUtils.getSysTimeZone().toZoneId()).toInstant()));
        }
        catch (Exception ex) {
            LOG.warn("formatLocalDateBySysTzAndUserFmt.warn", (Throwable)ex);
            return "";
        }
    }

    public static String formatDateStrBySysTzAndUserFmt(String dateStr, String oriDateFmt) {
        if (WTCStringUtils.isEmpty(dateStr) || WTCStringUtils.isEmpty(oriDateFmt)) {
            return "";
        }
        Date date = WTCDateUtils.str2Date(dateStr, oriDateFmt);
        if (date == null) {
            return "";
        }
        return WTCInteDateUtil.formatDateBySysTzAndUserFmt(date);
    }

    public static String formatByUserTzAndFmt(Date date) {
        if (date == null) {
            return "";
        }
        return WTCInteDateUtil.formatDateTime(date, null, null);
    }

    public static String formatBySysTzAndUserFmt(Date date) {
        if (date == null) {
            return "";
        }
        return WTCInteDateUtil.formatDateTime(date, null, WTCInteDateUtil.getSysTimeZone().getTimeZone());
    }

    public static String formatDateTime(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        return WTCInteDateUtil.formatDateTime(date, pattern, null);
    }

    public static String formatDateTime(Date date, TimeZone timeZone) {
        if (date == null) {
            return "";
        }
        return WTCInteDateUtil.formatDateTime(date, null, timeZone);
    }

    public static String formatDateTime(Date date, String pattern, TimeZone timeZone) {
        SimpleDateFormat format;
        if (date == null) {
            return "";
        }
        if (HRStringUtils.isEmpty((String)pattern)) {
            format = WTCInteDateUtil.getUserDateTimeFormat();
            if (format == null) {
                format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            }
        } else {
            format = new SimpleDateFormat(pattern);
        }
        if (timeZone != null) {
            format.setTimeZone(timeZone);
        } else {
            InteTimeZone userTimeZone = WTCInteDateUtil.getUserTimeZone();
            format.setTimeZone(userTimeZone.getTimeZone());
        }
        String result = format.format(date);
        return result;
    }

    public static String formatTimeByUserFmt(Date date) {
        if (date == null) {
            return "";
        }
        String timeFormat = WTCInteDateUtil.getUserTimeFormat();
        return WTCDateUtils.date2Str(date, timeFormat);
    }

    public static String formatTimeByUserFmt(long time) {
        LocalTime localTime = LocalTime.ofSecondOfDay(time);
        LocalDate localDate = LocalDate.now();
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        Date date = WTCDateUtils.toDate(localDateTime);
        return WTCInteDateUtil.formatTimeByUserFmt(date);
    }

    public static SimpleDateFormat getUserSimpleDateFormat() {
        return WTCInteDateUtil.getUserSimpleDateFormat(RequestContext.get().getCurrUserId());
    }

    public static SimpleDateFormat getUserSimpleDateFormat(long userId) {
        IFormat iFormat = FormatFactory.get((FormatTypes)FormatTypes.Date);
        FormatObject userFormat = InteServiceHelper.getUserFormat((Long)userId);
        Format format = iFormat.getFormat(userFormat);
        SimpleDateFormat dateFormat = (SimpleDateFormat)format;
        dateFormat.setTimeZone(WTCInteDateUtil.getSysTimeZone().getTimeZone());
        return dateFormat;
    }

    @Deprecated
    public static String getUserDateFormat() {
        return WTCInteDateUtil.getUserDateFormat(RequestContext.get().getCurrUserId());
    }

    @Deprecated
    public static String getUserDateFormat(long userId) {
        String dateFormat = InteServiceHelper.getDateFormat((Long)userId);
        if (HRStringUtils.isEmpty((String)dateFormat)) {
            dateFormat = "yyyy-MM-dd";
        }
        return dateFormat;
    }

    public static String getUserTimeFormat() {
        return WTCInteDateUtil.getUserTimeFormat(RequestContext.get().getCurrUserId());
    }

    public static String getUserTimeFormat(long userId) {
        String timeFormat;
        Map formatMap = InteServiceHelper.getTimeFormat((Long)userId);
        if (formatMap == null) {
            timeFormat = "HH:mm:ss";
        } else {
            timeFormat = (String)formatMap.get("timeFormat");
            if (HRStringUtils.isEmpty((String)timeFormat)) {
                timeFormat = "HH:mm:ss";
            }
        }
        return timeFormat;
    }

    public static SimpleDateFormat getUserDateTimeFormat() {
        return WTCInteDateUtil.getUserDateTimeFormat(RequestContext.get().getCurrUserId());
    }

    public static SimpleDateFormat getUserDateTimeFormat(long userId) {
        FormatObject userFormat = InteServiceHelper.getUserFormat((Long)userId);
        IFormat format = FormatFactory.get((FormatTypes)FormatTypes.Time);
        return (SimpleDateFormat)format.getFormat(userFormat);
    }

    public static InteTimeZone getUserTimeZone() {
        return WTCInteDateUtil.getUserTimeZone(RequestContext.get().getCurrUserId());
    }

    public static InteTimeZone getUserTimeZone(long userId) {
        DynamicObject userTimezone = InteServiceHelper.getUserTimezone((Long)userId);
        return new InteTimeZone(userTimezone);
    }

    public static InteTimeZone getSysTimeZone() {
        DynamicObject sysTimezone = InteServiceHelper.getSysTimezone();
        return new InteTimeZone(sysTimezone);
    }

    public static int getUserFirstDayOfWeek() {
        Map calendarFormatMap;
        Object firstDayOfWeekObj;
        Object calendarFormatObj;
        IInteService iInteService = (IInteService)ServiceFactory.getService(IInteService.class);
        Map userFmtMap = iInteService.getUserFormat(Long.valueOf(RequestContext.get().getCurrUserId()));
        int firstDayOfWeek = 1;
        if (userFmtMap != null && (calendarFormatObj = userFmtMap.get("calendarFormat")) instanceof Map && (firstDayOfWeekObj = (calendarFormatMap = (Map)calendarFormatObj).get("firstDayOfWeek")) != null) {
            try {
                firstDayOfWeek = Integer.parseInt(firstDayOfWeekObj.toString());
            }
            catch (NumberFormatException nfe) {
                LOG.info("getUserFirstDayOfWeek.get.warn:{}", (Object)nfe);
                return firstDayOfWeek;
            }
        }
        return firstDayOfWeek;
    }

    public static Date getUserDate(Date date) {
        String userNowTimeStr = WTCInteDateUtil.formatDateTime(date, "yyyy-MM-dd HH:mm:ss", WTCInteDateUtil.getUserTimeZone().getTimeZone());
        return WTCDateUtils.str2Date(userNowTimeStr, "yyyy-MM-dd HH:mm:ss");
    }

    private static String formatDateByFieldProp(DateTimeProp prop, Date date, Long orgId) {
        if (Objects.isNull(date)) {
            return "";
        }
        IFormat format = prop.getRegionType() == FormatTypes.Time.getValue() ? FormatFactory.get((FormatTypes)FormatTypes.Time) : FormatFactory.get((FormatTypes)FormatTypes.Date);
        FormatObject formatObject = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
        InteTimeZone timeZone = prop.getTimeZone(orgId);
        if (formatObject != null && formatObject.isTimeNotEmpty()) {
            formatObject.getTimeFormat().setTimeArea(timeZone.getTimeArea());
            formatObject.getDateFormat().setTimeArea(timeZone.getTimeArea());
        }
        String formatString = format.getFormat(formatObject).format(date);
        return formatString;
    }
}

