/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.bundle.Resources;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.lang.Lang;
import kd.bos.service.ServiceFactory;
import kd.bos.util.CollectionUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class WTCResManager {
    public static String loadKDString(String description, String resourceID, String systemType, Object ... args) {
        return ResManager.loadKDString((String)description, (String)resourceID, (String)systemType, (Object[])args);
    }

    private static String getDefaultString(ILocaleString localeString) {
        if (WTCStringUtils.isEmpty(localeString.getLocaleValue())) {
            return "";
        }
        return localeString.getLocaleValue();
    }

    private static Object[] remakeArgs(Lang lang, Object ... args) {
        ArrayList<Object> list = new ArrayList<Object>(args.length);
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg instanceof ILocaleString) {
                ILocaleString localeString = (ILocaleString)arg;
                if (lang == Lang.zh_CN) {
                    if (WTCStringUtils.isEmpty(localeString.getLocaleValue_zh_CN())) {
                        list.add(WTCResManager.getDefaultString(localeString));
                        continue;
                    }
                    list.add(localeString.getLocaleValue_zh_CN());
                    continue;
                }
                if (lang == Lang.zh_TW) {
                    if (WTCStringUtils.isEmpty(localeString.getLocaleValue_zh_TW())) {
                        list.add(WTCResManager.getDefaultString(localeString));
                        continue;
                    }
                    list.add(localeString.getLocaleValue_zh_TW());
                    continue;
                }
                if (lang == Lang.en_US) {
                    if (WTCStringUtils.isEmpty(localeString.getLocaleValue_en())) {
                        list.add(WTCResManager.getDefaultString(localeString));
                        continue;
                    }
                    list.add(localeString.getLocaleValue_en());
                    continue;
                }
                if (WTCStringUtils.isEmpty(localeString.getLocaleValue())) {
                    list.add("{" + i + "}");
                    continue;
                }
                list.add(localeString.getLocaleValue());
                continue;
            }
            list.add(arg);
        }
        return list.toArray();
    }

    public static void setLocaleString(ILocaleString holderString, String description, String resourceID, String systemType, Object ... args) {
        LocaleString localeString = ResManager.getLocaleString((String)description, (String)resourceID, (String)systemType);
        if (localeString == null) {
            throw new KDBizException("get locale string error.");
        }
        if (holderString.isEmpty()) {
            List<Lang> enableLangList = WTCResManager.getEnableLangList();
            for (Lang lang : enableLangList) {
                holderString.put((Object)lang.toString(), (Object)"");
            }
            holderString.put((Object)"GLang", (Object)"");
        }
        boolean hasGLang = false;
        for (String key : holderString.keySet()) {
            if (key.equals("GLang")) {
                hasGLang = true;
                continue;
            }
            if (WTCStringUtils.isEmpty((String)localeString.getItem(key))) continue;
            Object[] cnArgs = WTCResManager.remakeArgs(Lang.from((String)key), args);
            holderString.setItem(key, (Object)Resources.format((String)((String)localeString.getItem(key)), (Object[])cnArgs));
        }
        if (hasGLang) {
            holderString.setItem("GLang", (Object)holderString.getLocaleValue());
        }
    }

    private static List<Lang> getEnableLangList() {
        ArrayList<Lang> enableLangList = new ArrayList<Lang>();
        try {
            if (RequestContext.get() == null || RequestContext.get().getAccountId() == null) {
                enableLangList.add(Lang.zh_CN);
                enableLangList.add(Lang.en_US);
                enableLangList.add(Lang.zh_TW);
                return enableLangList;
            }
            IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
            List langList = service.getEnabledLang();
            if (CollectionUtils.isEmpty((Collection)langList)) {
                enableLangList.add(Lang.zh_CN);
                enableLangList.add(Lang.en_US);
                enableLangList.add(Lang.zh_TW);
                return enableLangList;
            }
            for (EnabledLang enabledLang : langList) {
                enableLangList.add(Lang.from((String)enabledLang.getNumber()));
            }
        }
        catch (Exception var9) {
            enableLangList.add(Lang.zh_CN);
            enableLangList.add(Lang.en_US);
            enableLangList.add(Lang.zh_TW);
        }
        return enableLangList;
    }
}

