/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import kd.bos.logging.Log;
import kd.wtc.wtbs.common.lang.WTCException;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.util.WTCAssert;

public class WTCResourceUtils {
    private static final Log log = WTCLogFactory.getLog(WTCResourceUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T readObject(String resourceLocation, Class<T> clazz) {
        try (InputStream input = WTCResourceUtils.getURL(resourceLocation).openStream();){
            Object object = JSONObject.parseObject((InputStream)input, (Charset)Charset.defaultCharset(), clazz, (Feature[])new Feature[0]);
            return (T)object;
        }
        catch (FileNotFoundException e) {
            log.warn("Could Not Find Resource By Name: {}", (Object)resourceLocation);
            return null;
        }
        catch (Exception e) {
            throw new WTCException(e, "Json File Read Error By Resource Name: " + resourceLocation);
        }
    }

    @Nullable
    public static Map<String, Object> readMap(String resourceLocation) {
        Stream<String> ctnStream = null;
        try {
            URL input = WTCResourceUtils.getURL(resourceLocation);
            ctnStream = Files.lines(Paths.get(input.toURI()), Charset.defaultCharset());
            String ctn = ctnStream.collect(Collectors.joining());
            JSONObject jSONObject = JSONObject.parseObject((String)ctn);
            return jSONObject;
        }
        catch (FileNotFoundException e) {
            log.warn("Could Not Find Resource By Name: {}", (Object)resourceLocation);
            Map<String, Object> map = null;
            return map;
        }
        catch (Exception e) {
            throw new WTCException(e, "Json File Read Error By Resource Name: " + resourceLocation);
        }
        finally {
            if (null != ctnStream) {
                ctnStream.close();
            }
        }
    }

    public static URL getURL(String resourceLocation) throws FileNotFoundException, MalformedURLException {
        WTCAssert.nonNull((Object)resourceLocation, "Resource location must not be null");
        if (resourceLocation.startsWith("classpath:")) {
            URL url;
            String path = resourceLocation.substring("classpath:".length());
            ClassLoader cl = WTCResourceUtils.getDefaultClassLoader();
            URL uRL = url = cl != null ? cl.getResource(path) : ClassLoader.getSystemResource(path);
            if (url == null) {
                String description = "class path resource [" + path + "]";
                throw new FileNotFoundException(description + " cannot be resolved to URL because it does not exist");
            }
            return url;
        }
        return new URL(resourceLocation);
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = WTCResourceUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }
}

