/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class WTCStringUtils {
    private static final int INITCAPACITY_ARRAYLIST = 10;

    public static String joinStr(String ... params) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String str : params) {
            stringBuilder.append(str);
        }
        return stringBuilder.toString();
    }

    public static String joinOnComma(String ... params) {
        return StringUtils.join((Object[])params, (String)",");
    }

    public static String joinOnDot(String ... params) {
        return StringUtils.join((Object[])params, (String)".");
    }

    public static String join(List<String> array, String separator) {
        return StringUtils.join(array, (String)separator);
    }

    public static String[] split(String line, int seperator) {
        int j;
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).length() == 0) {
            return null;
        }
        if (line.indexOf(seperator) < 0) {
            return new String[]{line};
        }
        ArrayList<String> v = new ArrayList<String>(10);
        int i = 0;
        while ((j = line.indexOf(seperator, i)) >= 0) {
            v.add(line.substring(i, j).trim());
            i = j + 1;
        }
        v.add(line.substring(i).trim());
        return v.toArray(new String[v.size()]);
    }

    public static String[] split(String line, String seperator) {
        int j;
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).length() == 0) {
            return new String[]{""};
        }
        if (!line.contains(seperator)) {
            return new String[]{line};
        }
        ArrayList<String> v = new ArrayList<String>(10);
        int i = 0;
        while ((j = line.indexOf(seperator, i)) >= 0) {
            v.add(line.substring(i, j).trim());
            i = j + seperator.length();
        }
        v.add(line.substring(i).trim());
        return v.toArray(new String[v.size()]);
    }

    public static final boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static final boolean isNotEmpty(String s) {
        return !WTCStringUtils.isEmpty(s);
    }

    public static boolean equals(String s1, String s2) {
        if (WTCStringUtils.isEmpty(s1)) {
            return WTCStringUtils.isEmpty(s2);
        }
        return s1.equals(s2);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (WTCStringUtils.isEmpty(s1)) {
            return WTCStringUtils.isEmpty(s2);
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static final String replace(String chars, String oldChars, String newChars) {
        if (oldChars == null) {
            return null;
        }
        StringBuilder str = new StringBuilder(chars);
        int begin = chars.indexOf(oldChars);
        if (begin < 0) {
            return str.toString();
        }
        int end = begin + oldChars.length();
        str.replace(begin, end, newChars);
        return str.toString();
    }

    public static String delPrefixWithIgnoreCase(String str, String prefix) {
        if (str == null) {
            return null;
        }
        if (prefix == null) {
            return str.toLowerCase(Locale.ROOT);
        }
        if (prefix.length() > str.length()) {
            return str;
        }
        return str.toLowerCase(Locale.ROOT).substring(prefix.length());
    }

    public static String trim(String str) {
        return str != null ? str.trim() : null;
    }

    public static boolean patternMatch(String regex, String matchString) {
        if (HRStringUtils.isEmpty((String)regex)) {
            return false;
        }
        return Pattern.matches(regex, matchString);
    }

    public static String toStr(Object obj) {
        return WTCStringUtils.toStr(obj, "");
    }

    public static String toStr(Object obj, String defaultValue) {
        return obj == null ? defaultValue : obj.toString();
    }

    public static String trimNonNull(Object obj) {
        return WTCStringUtils.toStr(obj, "").trim();
    }

    public static String format(String format, Object ... args) {
        return String.format(Locale.ROOT, format, args);
    }

    public static String subStr(String str, int maxLen) {
        if (str == null) {
            return "";
        }
        if (str.length() <= maxLen) {
            return str;
        }
        return str.substring(0, maxLen);
    }
}

