/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kd.bos.context.OperationContext;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.WaitingRejectedHandler;
import kd.bos.threads.impl.ThreadPoolImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCAssert;

public final class WTCThreadPools {
    private static final Map<String, ThreadPool> poolMap = new ConcurrentHashMap<String, ThreadPool>();
    private static final int MAX_CACHED_THREAD_SIZE = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtbs.threadpool.cached.maxthread.size", 100000);
    private static final int MAX_WORK_QUEUE_SIZE = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtbs.threadpool.fix.maxqueue.size", 100000);
    private static final int MAX_CORE_THREAD_SIZE = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtbs.threadpool.fix.maxcorethread.size", 30);
    private static final int MAX_FIXED_THREAD_SIZE = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtbs.threadpool.fix.maxfixedthread.size", 1000);

    public static ThreadPool newCachedThreadPool(String poolName, int coreThread, int maxThread) {
        return WTCThreadPools.newCachedThreadPool(poolName, coreThread, maxThread, 0, null);
    }

    public static ThreadPool newCachedThreadPool(String poolName, int coreThread, int maxThread, int numOfWorkQueue) {
        return WTCThreadPools.newCachedThreadPool(poolName, coreThread, maxThread, numOfWorkQueue, null);
    }

    public static ThreadPool newCachedThreadPool(String poolName, int coreThread, int maxThread, int numOfWorkQueue, OperationContext operationContext) {
        WTCAssert.notBlank(poolName, "poolName could not be blank");
        WTCAssert.isTrue(maxThread > 0, () -> "maxThread could not less than or equal to 0,maxThread=" + maxThread);
        WTCAssert.isTrue(coreThread > 0, () -> "coreThread could not less than or equal to 0,coreThread=" + coreThread);
        return poolMap.computeIfAbsent(poolName, pn -> {
            Consumer<Boolean> consumer = v -> WTCThreadPools.removeFromMap(poolName);
            return new ThreadPoolImpl(WTCThreadPools.createCachedExecutorService(pn, coreThread, maxThread, numOfWorkQueue), operationContext, consumer);
        });
    }

    private static ExecutorService createCachedExecutorService(final String poolName, int coreThread, int maxThread, int numOfWorkQueue) {
        SynchronousQueue<Runnable> blockingDeque;
        if (maxThread > MAX_CACHED_THREAD_SIZE) {
            maxThread = MAX_CACHED_THREAD_SIZE;
        }
        if (coreThread > MAX_CORE_THREAD_SIZE) {
            coreThread = MAX_CORE_THREAD_SIZE;
        }
        if (numOfWorkQueue <= 1) {
            blockingDeque = new SynchronousQueue();
        } else {
            if (numOfWorkQueue > MAX_WORK_QUEUE_SIZE) {
                numOfWorkQueue = MAX_WORK_QUEUE_SIZE;
            }
            blockingDeque = new LinkedBlockingQueue(numOfWorkQueue);
        }
        return ThreadLifeCycleManager.wrapExecutorService((ExecutorService)new ThreadPoolExecutor(coreThread, maxThread, 20L, TimeUnit.SECONDS, blockingDeque, new ThreadFactory(){
            private final AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable command) {
                return new Thread(command, poolName + "-" + this.atomicInteger.incrementAndGet());
            }
        }, (RejectedExecutionHandler)new WaitingRejectedHandler()));
    }

    public static ThreadPool newFixedThreadPool(String poolName, int nThreads, int numOfWorkQueue) {
        return WTCThreadPools.newFixedThreadPool(poolName, nThreads, numOfWorkQueue, null);
    }

    public static ThreadPool newFixedThreadPool(String poolName, int nThreads, int numOfWorkQueue, OperationContext oc) {
        WTCAssert.notBlank(poolName, "poolName could not be blank");
        WTCAssert.isTrue(nThreads > 0, () -> "nThreads could not less than or equals to 0, nThreads=" + nThreads);
        return poolMap.computeIfAbsent(poolName, pn -> {
            Consumer<Boolean> consumer = v -> WTCThreadPools.removeFromMap(pn);
            return new ThreadPoolImpl(WTCThreadPools.createFixedThreadPool(pn, nThreads, numOfWorkQueue), oc, consumer);
        });
    }

    private static void removeFromMap(String poolName) {
        poolMap.remove(poolName);
    }

    private static ExecutorService createFixedThreadPool(final String poolName, int nThreads, int numOfWorkQueue) {
        if (nThreads > MAX_FIXED_THREAD_SIZE) {
            nThreads = MAX_FIXED_THREAD_SIZE;
        }
        return ThreadLifeCycleManager.wrapExecutorService((ExecutorService)new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(numOfWorkQueue), new ThreadFactory(){
            private final AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable command) {
                return new Thread(command, poolName + "-" + this.atomicInteger.incrementAndGet());
            }
        }, (RejectedExecutionHandler)new WaitingRejectedHandler()));
    }

    private WTCThreadPools() {
    }
}

