/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.wtc.wtbs.common.enums.BillTypeConstants;
import kd.wtc.wtbs.common.enums.WTTESystemParamEnum;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCOrgUnitServiceHelper;

public class WTTESystemParamQueryUtil {
    private static final Log LOG = LogFactory.getLog(WTTESystemParamQueryUtil.class);
    private static final String KEY_BILLTYPEKEY = "billtypekey";
    public static final String KEY_ACTUALDATA = "actualdata";

    private WTTESystemParamQueryUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String getBillTypeKey(long billTypeId) {
        return KEY_BILLTYPEKEY + billTypeId;
    }

    public static JSONObject getBillTypeData() {
        String data = (String)WTTESystemParamQueryUtil.loadAppParameterFromCache(KEY_ACTUALDATA);
        return JSON.parseObject((String)data);
    }

    public static boolean getFreezeSystemParam(WTTESystemParamEnum wTTESystemParamEnum) {
        Object needFreezeValue = WTTESystemParamQueryUtil.loadAppParameterFromCache(WTTESystemParamEnum.NEED_FREEZE.getKey());
        if (needFreezeValue != null && ((Boolean)needFreezeValue).booleanValue()) {
            Object freezeTypeValue = WTTESystemParamQueryUtil.loadAppParameterFromCache(wTTESystemParamEnum.getKey());
            return freezeTypeValue != null && (Boolean)freezeTypeValue != false;
        }
        return false;
    }

    public static boolean getBillTypeSystemParam(long billTypeId) {
        if (billTypeId == 0L) {
            return false;
        }
        if (!SystemParamQueryUtil.isFrozenOpen().booleanValue()) {
            return false;
        }
        boolean bill = WTTESystemParamQueryUtil.getFreezeSystemParam(WTTESystemParamEnum.BILL);
        if (!bill) {
            return false;
        }
        JSONObject json = WTTESystemParamQueryUtil.getBillTypeData();
        String billTypeKey = WTTESystemParamQueryUtil.getBillTypeKey(billTypeId);
        if (json == null) {
            return WTTESystemParamQueryUtil.isDefaultSetTrue(billTypeKey);
        }
        Object value = json.get((Object)billTypeKey);
        if (value == null) {
            return WTTESystemParamQueryUtil.isDefaultSetTrue(billTypeKey);
        }
        return (Boolean)value;
    }

    private static boolean isDefaultSetTrue(String billTypeKey) {
        String vocationKey = WTTESystemParamQueryUtil.getBillTypeKey(BillTypeConstants.VOCATION_ID);
        String supplyKey = WTTESystemParamQueryUtil.getBillTypeKey(BillTypeConstants.SUPPLY_SIGN_ID);
        return vocationKey.equals(billTypeKey) || supplyKey.equals(billTypeKey);
    }

    public static Object loadAppParameterFromCache(String key) {
        long orgId = WTTESystemParamQueryUtil.getWTCRootOrg();
        String appId = AppMetadataCache.getAppInfo((String)"wtte").getId();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)key);
    }

    public static boolean getExPushBlock() {
        long orgId = WTTESystemParamQueryUtil.getWTCRootOrg();
        String appId = AppMetadataCache.getAppInfo((String)"wtp").getId();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        return (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"openblock");
    }

    public static Integer getExPushThresholdValue() {
        long orgId = WTTESystemParamQueryUtil.getWTCRootOrg();
        String appId = AppMetadataCache.getAppInfo((String)"wtp").getId();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        return (Integer)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"thresholdvalue");
    }

    public static List<Long> getExPushBlockingNotification() {
        long orgId = WTTESystemParamQueryUtil.getWTCRootOrg();
        String appId = AppMetadataCache.getAppInfo((String)"wtp").getId();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        Object obj = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"blockingnotification");
        ArrayList<Long> notification = new ArrayList<Long>();
        if (obj != null) {
            ArrayList list = (ArrayList)obj;
            for (HashMap map : list) {
                Object id;
                Object attBase = map.get("fbasedataid");
                if (attBase == null || (id = ((HashMap)attBase).get("id")) == null) continue;
                notification.add(Long.parseLong(id.toString()));
            }
        }
        return notification;
    }

    public static LinkedHashMap<String, Object> getExPushBlockNoticeTpl() {
        long orgId = WTTESystemParamQueryUtil.getWTCRootOrg();
        String appId = AppMetadataCache.getAppInfo((String)"wtp").getId();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        LinkedHashMap msgTmp = null;
        Object object = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"noticetpl");
        if (null != object) {
            msgTmp = (LinkedHashMap)object;
        }
        return msgTmp;
    }

    private static long getWTCRootOrg() {
        return WTCOrgUnitServiceHelper.getHRDefaultRootOrgId();
    }
}

