/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.util.timewatch;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;

public final class TimeRecordEntity
implements Serializable {
    private static final long serialVersionUID = -5581499936143246920L;
    private String methodKey;
    private String tag;
    private Queue<Float> times;
    private float averageTime;
    private float totalTime;
    private int maxLen;
    private float maxTime;
    private float minTime = Float.MAX_VALUE;
    private int counter;
    private String traceId;

    public String getMethodKey() {
        return this.methodKey;
    }

    void setMethodKey(String methodKey) {
        this.methodKey = methodKey;
    }

    public String getTag() {
        return this.tag;
    }

    void setTag(String tag) {
        this.tag = tag;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public Collection<Float> getTimes() {
        return Collections.unmodifiableCollection(this.times);
    }

    public float getAverageTime() {
        return this.averageTime;
    }

    public synchronized int getMaxLen() {
        return this.maxLen;
    }

    public synchronized void setMaxLen(int maxLen) {
        this.maxLen = maxLen;
        Queue<Float> old = this.times;
        this.times = new ArrayDeque<Float>(maxLen);
        if (old != null) {
            this.times.addAll(old);
            this.clipHead();
        }
    }

    private void clipHead() {
        while (this.times.size() > this.maxLen) {
            this.times.poll();
        }
    }

    public float getMaxTime() {
        return this.maxTime;
    }

    public float getMinTime() {
        return this.minTime;
    }

    public int getCounter() {
        return this.counter;
    }

    public float getTotalTime() {
        return this.totalTime;
    }

    synchronized void addTime(float time, String traceId) {
        this.averageTime = (this.averageTime * (float)this.counter + time) / (float)(this.counter + 1);
        this.times.add(Float.valueOf(time));
        ++this.counter;
        this.logTraceId(time, traceId);
        this.minTime = Math.min(time, this.minTime);
        this.maxTime = Math.max(time, this.maxTime);
        this.totalTime += time;
        this.clipHead();
    }

    synchronized void reset() {
        this.maxTime = 0.0f;
        this.minTime = Float.MAX_VALUE;
        this.averageTime = 0.0f;
        this.counter = 0;
        this.totalTime = 0.0f;
        this.times.clear();
    }

    private void logTraceId(float time, String traceId) {
        if (traceId.equalsIgnoreCase(this.traceId)) {
            return;
        }
        if (Float.compare(time, this.maxTime) > 0) {
            this.traceId = traceId;
        }
    }
}

