/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.util.timewatch;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import kd.bos.context.RequestContext;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.timewatch.TimeRecordEntity;
import kd.wtc.wtbs.common.util.timewatch.TimeWatchConfig;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.objectweb.asm.Type;

public class TimeRecordInterceptor<T>
implements MethodInterceptor {
    String tag;
    final T delegate;
    private final Map<Integer, String> codeMethodMap;
    private final Map<String, TimeRecordEntity> methodRecordMap;
    final TimeWatchConfig config;

    protected TimeRecordInterceptor(@NotNull String tag, @NotNull Map<String, TimeRecordEntity> methodRecordMap, @NotNull TimeWatchConfig config) {
        this(null, tag, methodRecordMap, config);
    }

    protected TimeRecordInterceptor(T obj, @NotNull String tag, @NotNull Map<String, TimeRecordEntity> methodRecordMap, @NotNull TimeWatchConfig config) {
        this.tag = tag;
        this.delegate = obj;
        this.methodRecordMap = methodRecordMap;
        this.config = config;
        this.codeMethodMap = new ConcurrentHashMap<Integer, String>();
    }

    protected String getUniqueMethodKey(MethodProxy methodProxy) {
        String name = methodProxy.getSignature().getName();
        Type[] argumentTypes = methodProxy.getSignature().getArgumentTypes();
        if (argumentTypes != null && argumentTypes.length > 0) {
            List typeNames = Stream.of(argumentTypes).map(type -> {
                String[] splits = type.getClassName().split("\\.");
                return splits[splits.length - 1];
            }).collect(Collectors.toList());
            return name + "(" + String.join((CharSequence)",", typeNames) + ")";
        }
        return name + "()";
    }

    protected TimeRecordEntity createTimeRecord(String methodKey) {
        TimeRecordEntity entity = new TimeRecordEntity();
        entity.setTag(this.tag);
        entity.setMethodKey(methodKey);
        entity.setMaxLen(this.config.getTimeRecordMaxLen());
        return entity;
    }

    public Object intercept(Object obj, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        String traceId = RequestContext.get().getTraceId();
        String spanName = method.getDeclaringClass().getSimpleName() + "#" + method.getName();
        try (TraceSpan serviceSpan = this.createSpan(spanName);){
            String key;
            int code = methodProxy.getSignature().hashCode();
            if (this.codeMethodMap.get(code) != null) {
                key = this.codeMethodMap.get(code);
            } else {
                key = this.getUniqueMethodKey(methodProxy);
                this.codeMethodMap.put(code, key);
            }
            TimeRecordEntity record = this.methodRecordMap.computeIfAbsent(key, this::createTimeRecord);
            if (HRStringUtils.isEmpty((String)record.getTraceId())) {
                record.setTraceId(traceId);
            }
            long t1 = System.nanoTime();
            Object result = this.delegate != null ? methodProxy.invoke(this.delegate, objects) : methodProxy.invokeSuper(obj, objects);
            long deltaNano = System.nanoTime() - t1;
            float value = (float)deltaNano / 1000000.0f;
            record.addTime(value, traceId);
            Object object = result;
            return object;
        }
    }

    private TraceSpan createSpan(String spanName) {
        return Tracer.create((String)"WTCServiceSpan", (String)spanName, (boolean)true);
    }
}

