/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.util.timewatch;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.wtc.wtbs.common.util.timewatch.TimeRecordEntity;
import kd.wtc.wtbs.common.util.timewatch.TimeRecordInterceptor;
import kd.wtc.wtbs.common.util.timewatch.TimeWatchConfig;
import net.sf.cglib.proxy.Enhancer;

public class TimeWatchDynamicProxyFactory {
    private Map<String, Map<String, TimeRecordEntity>> tagTimeRecordMap;
    private final TimeWatchConfig timeWatchConfig;

    public static TimeWatchDynamicProxyFactory getInstance() {
        return TimeWatchDynamicProxyFactoryHolder.INSTANCE;
    }

    private TimeWatchDynamicProxyFactory(TimeWatchConfig timeWatchConfig) {
        this.timeWatchConfig = timeWatchConfig;
        this.initRecordMap();
    }

    private void initRecordMap() {
        this.tagTimeRecordMap = new ConcurrentHashMap<String, Map<String, TimeRecordEntity>>(2);
    }

    private Map<String, TimeRecordEntity> getTimeRecordMapByTag(String tag) {
        return this.tagTimeRecordMap.computeIfAbsent(tag, key -> new ConcurrentHashMap(2));
    }

    private boolean isDisableProxy() {
        return this.timeWatchConfig.isDisableProxy() || EnvTypeHelper.getCurrentEnvType() == EnvTypeHelper.EnvType.Product;
    }

    public <T> T createProxy(@NotEmpty String tag, @NotNull T obj) {
        if (this.isDisableProxy()) {
            return obj;
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(obj.getClass());
        enhancer.setCallback(new TimeRecordInterceptor<T>(obj, tag, this.getTimeRecordMapByTag(tag), this.timeWatchConfig));
        return (T)enhancer.create();
    }

    public <T> T createProxy(String tag, Class<? extends T> clazz) {
        if (this.isDisableProxy()) {
            try {
                return clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setCallback(new TimeRecordInterceptor(tag, this.getTimeRecordMapByTag(tag), this.timeWatchConfig));
        return (T)enhancer.create();
    }

    public <T> T createProxy(String tag, Class<? extends T> clazz, Class<?>[] argTypes, Object[] args) {
        if (this.isDisableProxy()) {
            try {
                Constructor<T> declaredConstructor = clazz.getDeclaredConstructor(argTypes);
                return declaredConstructor.newInstance(args);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setCallback(new TimeRecordInterceptor(tag, this.getTimeRecordMapByTag(tag), this.timeWatchConfig));
        return (T)enhancer.create((Class[])argTypes, args);
    }

    public byte[] convert2Excel() {
        ArrayList<TimeRecordEntity> lists = new ArrayList<TimeRecordEntity>();
        for (Map.Entry<String, Map<String, TimeRecordEntity>> entry : this.tagTimeRecordMap.entrySet()) {
            for (Map.Entry<String, TimeRecordEntity> entry1 : entry.getValue().entrySet()) {
                lists.add(entry1.getValue());
            }
        }
        lists.sort((o1, o2) -> {
            if (o1.getTag().compareTo(o2.getTag()) == 0) {
                return o1.getMethodKey().compareTo(o2.getMethodKey());
            }
            return o1.getTag().compareTo(o2.getTag());
        });
        ArrayList<List<Object>> datas = new ArrayList<List<Object>>(lists.size() + 1);
        List<Object> header = Arrays.asList(ResManager.loadKDString((String)"\u6807\u7b7e", (String)"TimeWatchDynamicProxyFactory_0", (String)"wtc-wtbs-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u65b9\u6cd5", (String)"TimeWatchDynamicProxyFactory_1", (String)"wtc-wtbs-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u603b\u8017\u65f6(ms)", (String)"TimeWatchDynamicProxyFactory_2", (String)"wtc-wtbs-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5e73\u5747\u8017\u65f6(ms)", (String)"TimeWatchDynamicProxyFactory_3", (String)"wtc-wtbs-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6700\u5927\u8017\u65f6(ms)", (String)"TimeWatchDynamicProxyFactory_4", (String)"wtc-wtbs-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6700\u5c0f\u8017\u65f6(ms)", (String)"TimeWatchDynamicProxyFactory_5", (String)"wtc-wtbs-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6700\u5927\u8017\u65f6traceId", (String)"TimeWatchDynamicProxyFactory_8", (String)"wtc-wtbs-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6b21\u6570", (String)"TimeWatchDynamicProxyFactory_6", (String)"wtc-wtbs-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6700\u8fd1\u8017\u65f6\u6570\u636e", (String)"TimeWatchDynamicProxyFactory_7", (String)"wtc-wtbs-common", (Object[])new Object[0]));
        datas.add(header);
        for (TimeRecordEntity entity : lists) {
            ArrayList<Object> arrayList = new ArrayList<Object>(8);
            arrayList.add(entity.getTag());
            arrayList.add(entity.getMethodKey());
            arrayList.add(Float.valueOf(entity.getTotalTime()));
            arrayList.add(Float.valueOf(entity.getAverageTime()));
            arrayList.add(Float.valueOf(entity.getMaxTime()));
            arrayList.add(Float.valueOf(entity.getMinTime()));
            arrayList.add(entity.getTraceId());
            arrayList.add(String.valueOf(entity.getCounter()));
            arrayList.addAll(entity.getTimes());
            datas.add(arrayList);
        }
        StringBuilder sb = new StringBuilder();
        for (List list : datas) {
            String rowStr = list.stream().map(o -> String.valueOf(o).replace(",", "\uff0c")).collect(Collectors.joining(","));
            sb.append(rowStr);
            sb.append("\r\n");
        }
        return sb.toString().getBytes(Charset.forName("gbk"));
    }

    public void clearTimeRecord() {
        for (Map.Entry<String, Map<String, TimeRecordEntity>> entry : this.tagTimeRecordMap.entrySet()) {
            for (Map.Entry<String, TimeRecordEntity> entry1 : entry.getValue().entrySet()) {
                TimeRecordEntity entity = entry1.getValue();
                entity.reset();
            }
        }
    }

    private static class TimeWatchDynamicProxyFactoryHolder {
        private static final TimeWatchDynamicProxyFactory INSTANCE = new TimeWatchDynamicProxyFactory(new TimeWatchConfig());

        private TimeWatchDynamicProxyFactoryHolder() {
        }
    }
}

