/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.validate.context.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Properties;
import javax.validation.ConstraintValidator;
import kd.wtc.wtbs.common.validate.context.WTCValidatorContext;
import kd.wtc.wtbs.common.validate.context.impl.AbstractWTCValicatorContext;
import kd.wtc.wtbs.common.validate.exceptions.KdVerifyException;
import kd.wtc.wtbs.common.validate.utils.WTCValidator;

public class DefaultValidatorContext
extends AbstractWTCValicatorContext
implements WTCValidatorContext {
    private static boolean INITED = false;
    private static final String PROP_FILE = "validator.properties";

    public DefaultValidatorContext() {
        this.init();
    }

    public final synchronized void init() {
        if (INITED) {
            return;
        }
        try (InputStream in = WTCValidator.class.getClassLoader().getResourceAsStream(PROP_FILE);){
            Properties properties = new Properties();
            properties.load(in);
            Collection<Object> values = properties.values();
            for (Object element : values) {
                Class<?>[] annoClass;
                Class<ConstraintValidator<Annotation, Object>> validatorClass;
                try {
                    validatorClass = Class.forName((String)element);
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                if (!ConstraintValidator.class.isAssignableFrom(validatorClass) || Modifier.isAbstract(validatorClass.getModifiers()) || (annoClass = DefaultValidatorContext.getInterfaceT(validatorClass)) == null || annoClass.length != 2) continue;
                Class<?> checkerType = annoClass[0];
                Class<?> annoType = annoClass[annoClass.length - 1];
                this.putVal(checkerType, annoType, validatorClass);
            }
            INITED = true;
        }
        catch (IOException e) {
            throw new KdVerifyException("0X0001", "init validator context error.check your system propertyvalidator.properties");
        }
    }

    private static Class<?>[] getInterfaceT(Class<ConstraintValidator<Annotation, Object>> cls) {
        Type[] interfaces;
        Class<?>[] result = null;
        for (Type superInterface : interfaces = cls.getGenericInterfaces()) {
            Class c;
            ParameterizedType parameterizedType = (ParameterizedType)superInterface;
            Type rawType = parameterizedType.getRawType();
            if (!(rawType instanceof Class) || !ConstraintValidator.class.equals((Object)(c = (Class)rawType))) continue;
            Type[] typesT = parameterizedType.getActualTypeArguments();
            result = DefaultValidatorContext.checkTypes(typesT);
            break;
        }
        return result;
    }

    private static Class<?>[] checkTypes(Type[] typesT) {
        Class[] classes = new Class[typesT.length];
        for (int index = 0; index < typesT.length; ++index) {
            Type type = typesT[index];
            Class<?> cls = DefaultValidatorContext.checkType(type);
            if (cls == null) {
                return null;
            }
            classes[index] = cls;
        }
        return classes;
    }

    private static Class<?> checkType(Type type) {
        Class<?> clazz = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type t = pt.getActualTypeArguments()[0];
            clazz = DefaultValidatorContext.checkType(t);
        } else if (type instanceof Class) {
            clazz = (Class<?>)type;
        }
        return clazz;
    }
}

