/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.validate.entity;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Payload;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Email;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Negative;
import javax.validation.constraints.NegativeOrZero;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;

public class Rule {
    private String key;
    private Class<?> type;
    private boolean required;
    private final List<? extends Annotation> annotations;

    private Rule(String key, Class<?> type, Boolean required, List<? extends Annotation> annotations) {
        this.key = key;
        this.type = type;
        this.required = required;
        this.annotations = annotations;
    }

    public static RuleBuilder builder(String key) {
        return new RuleBuilder().key(key);
    }

    public String getKey() {
        return this.key;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public List<? extends Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public static class RuleBuilder {
        private String key;
        private Class<?> type = Object.class;
        private Boolean required = Boolean.FALSE;
        private final List<Annotation> annotations = new ArrayList<Annotation>(10);

        RuleBuilder() {
        }

        public RuleBuilder key(String key) {
            this.key = key;
            return this;
        }

        public RuleBuilder type(Class<?> type) {
            this.type = type;
            return this;
        }

        public RuleBuilder required() {
            this.required = Boolean.TRUE;
            return this;
        }

        public RuleBuilder notBlank(final String message) {
            NotBlank notBlank = new NotBlank(){

                public Class<? extends Annotation> annotationType() {
                    return NotBlank.class;
                }

                public String message() {
                    return message;
                }

                public Class<?>[] groups() {
                    return null;
                }

                public Class<? extends Payload>[] payload() {
                    return null;
                }
            };
            this.annotations.add((Annotation)notBlank);
            return this;
        }

        public RuleBuilder notNull(final String message) {
            NotNull notNull = new NotNull(){

                public Class<? extends Annotation> annotationType() {
                    return NotNull.class;
                }

                public String message() {
                    return message;
                }

                public Class<?>[] groups() {
                    return null;
                }

                public Class<? extends Payload>[] payload() {
                    return null;
                }
            };
            this.annotations.add((Annotation)notNull);
            return this;
        }

        public RuleBuilder notEmpty(final String message) {
            NotEmpty notEmpty = new NotEmpty(){

                public Class<? extends Annotation> annotationType() {
                    return NotEmpty.class;
                }

                public String message() {
                    return message;
                }

                public Class<?>[] groups() {
                    return null;
                }

                public Class<? extends Payload>[] payload() {
                    return null;
                }
            };
            this.annotations.add((Annotation)notEmpty);
            return this;
        }

        public RuleBuilder size(final int min, final int max, final String message) {
            Size size = new Size(){

                public Class<? extends Annotation> annotationType() {
                    return Size.class;
                }

                public String message() {
                    return message;
                }

                public Class<?>[] groups() {
                    return null;
                }

                public Class<? extends Payload>[] payload() {
                    return null;
                }

                public int min() {
                    return min;
                }

                public int max() {
                    return max;
                }
            };
            this.annotations.add((Annotation)size);
            return this;
        }

        public RuleBuilder email(final String regExp, final String message) {
            Email email = new Email(){

                public Class<? extends Annotation> annotationType() {
                    return Email.class;
                }

                public String message() {
                    return message;
                }

                public Class<?>[] groups() {
                    return null;
                }

                public Class<? extends Payload>[] payload() {
                    return null;
                }

                public String regexp() {
                    return regExp;
                }

                public Pattern.Flag[] flags() {
                    return new Pattern.Flag[0];
                }
            };
            this.annotations.add((Annotation)email);
            return this;
        }

        public RuleBuilder decimalMin(final String value, final String message) {
            DecimalMin decimalMin = new DecimalMin(){

                public Class<? extends Annotation> annotationType() {
                    return DecimalMin.class;
                }

                public String message() {
                    return message;
                }

                public Class<?>[] groups() {
                    return null;
                }

                public Class<? extends Payload>[] payload() {
                    return null;
                }

                public String value() {
                    return value;
                }

                public boolean inclusive() {
                    return true;
                }
            };
            this.annotations.add((Annotation)decimalMin);
            return this;
        }

        public RuleBuilder decimalMax(final String value, final String message) {
            DecimalMax annotation = new DecimalMax(){

                public Class<? extends Annotation> annotationType() {
                    return DecimalMax.class;
                }

                public String message() {
                    return message;
                }

                public Class<?>[] groups() {
                    return null;
                }

                public Class<? extends Payload>[] payload() {
                    return null;
                }

                public String value() {
                    return value;
                }

                public boolean inclusive() {
                    return true;
                }
            };
            this.annotations.add((Annotation)annotation);
            return this;
        }

        public RuleBuilder min(final long value, final String message) {
            Min min = new Min(){

                public Class<? extends Annotation> annotationType() {
                    return Min.class;
                }

                public String message() {
                    return message;
                }

                public Class<?>[] groups() {
                    return null;
                }

                public Class<? extends Payload>[] payload() {
                    return null;
                }

                public long value() {
                    return value;
                }
            };
            this.annotations.add((Annotation)min);
            return this;
        }

        public RuleBuilder max(final long value, final String message) {
            Max max = new Max(){

                public Class<? extends Annotation> annotationType() {
                    return Max.class;
                }

                public String message() {
                    return message;
                }

                public Class<?>[] groups() {
                    return null;
                }

                public Class<? extends Payload>[] payload() {
                    return null;
                }

                public long value() {
                    return value;
                }
            };
            this.annotations.add((Annotation)max);
            return this;
        }

        public RuleBuilder negative(final String message) {
            Negative negative = new Negative(){

                public Class<? extends Annotation> annotationType() {
                    return Negative.class;
                }

                public String message() {
                    return message;
                }

                public Class<?>[] groups() {
                    return null;
                }

                public Class<? extends Payload>[] payload() {
                    return null;
                }
            };
            this.annotations.add((Annotation)negative);
            return this;
        }

        public RuleBuilder negativeOrZero(final String message) {
            NegativeOrZero negativeOrZero = new NegativeOrZero(){

                public Class<? extends Annotation> annotationType() {
                    return NegativeOrZero.class;
                }

                public String message() {
                    return message;
                }

                public Class<?>[] groups() {
                    return null;
                }

                public Class<? extends Payload>[] payload() {
                    return null;
                }
            };
            this.annotations.add((Annotation)negativeOrZero);
            return this;
        }

        public RuleBuilder positive(final String message) {
            Positive positive = new Positive(){

                public Class<? extends Annotation> annotationType() {
                    return Positive.class;
                }

                public String message() {
                    return message;
                }

                public Class<?>[] groups() {
                    return null;
                }

                public Class<? extends Payload>[] payload() {
                    return null;
                }
            };
            this.annotations.add((Annotation)positive);
            return this;
        }

        public RuleBuilder positiveOrZero(final String message) {
            NegativeOrZero positiveOrZero = new NegativeOrZero(){

                public Class<? extends Annotation> annotationType() {
                    return PositiveOrZero.class;
                }

                public String message() {
                    return message;
                }

                public Class<?>[] groups() {
                    return null;
                }

                public Class<? extends Payload>[] payload() {
                    return null;
                }
            };
            this.annotations.add((Annotation)positiveOrZero);
            return this;
        }

        public RuleBuilder assertTrue(final String message) {
            AssertTrue assertTrue = new AssertTrue(){

                public Class<? extends Annotation> annotationType() {
                    return Positive.class;
                }

                public String message() {
                    return message;
                }

                public Class<?>[] groups() {
                    return null;
                }

                public Class<? extends Payload>[] payload() {
                    return null;
                }
            };
            this.annotations.add((Annotation)assertTrue);
            return this;
        }

        public RuleBuilder assertFalse(final String message) {
            AssertFalse assertFalse = new AssertFalse(){

                public Class<? extends Annotation> annotationType() {
                    return PositiveOrZero.class;
                }

                public String message() {
                    return message;
                }

                public Class<?>[] groups() {
                    return null;
                }

                public Class<? extends Payload>[] payload() {
                    return null;
                }
            };
            this.annotations.add((Annotation)assertFalse);
            return this;
        }

        public RuleBuilder digits(final int integer, final int fraction, final String message) {
            Digits digits = new Digits(){

                public Class<? extends Annotation> annotationType() {
                    return Digits.class;
                }

                public String message() {
                    return message;
                }

                public Class<?>[] groups() {
                    return null;
                }

                public Class<? extends Payload>[] payload() {
                    return null;
                }

                public int integer() {
                    return integer;
                }

                public int fraction() {
                    return fraction;
                }
            };
            this.annotations.add((Annotation)digits);
            return this;
        }

        public Rule build() {
            return new Rule(this.key, this.type, this.required, this.annotations);
        }
    }
}

