/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.validate.utils;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.wtc.wtbs.common.validate.context.WTCValidatorContext;
import kd.wtc.wtbs.common.validate.entity.Rule;
import kd.wtc.wtbs.common.validate.entity.ValidResult;
import kd.wtc.wtbs.common.validate.entity.ValidResultItem;
import kd.wtc.wtbs.common.validate.exceptions.KdVerifyException;
import kd.wtc.wtbs.common.validate.utils.WTCValidator;

public class WTCValidValidator
extends WTCValidator {
    private WTCValidator validator;

    public WTCValidValidator() {
        this.validator = new WTCValidator();
    }

    public WTCValidValidator(WTCValidatorContext validatorContext) {
        this.validator = new WTCValidator(validatorContext);
    }

    @Override
    public ValidResult verifyMapWithRule(Map<String, Object> valueMap, Rule ... rules) {
        ValidResult validResult = this.validator.verifyMapWithRule(valueMap, rules);
        if (!validResult.isSuccess()) {
            String resultMessage = Optional.ofNullable(validResult.getItems()).orElseGet(ArrayList::new).stream().map(ValidResultItem::getMessage).collect(Collectors.joining());
            throw new KdVerifyException("WTCVALID_001", resultMessage);
        }
        return validResult;
    }

    @Override
    public ValidResult verify(Object entity) {
        ValidResult validResult = this.validator.verify(entity);
        if (!validResult.isSuccess()) {
            String resultMessage = Optional.ofNullable(validResult.getItems()).orElseGet(ArrayList::new).stream().map(ValidResultItem::getMessage).collect(Collectors.joining());
            throw new KdVerifyException("WTCVALID_002", resultMessage);
        }
        return validResult;
    }

    @Override
    public ValidResult verifyBeanWithRule(Object bean, Rule ... rules) {
        ValidResult validResult = this.validator.verifyBeanWithRule(bean, new Rule[0]);
        if (!validResult.isSuccess()) {
            String resultMessage = Optional.ofNullable(validResult.getItems()).orElseGet(ArrayList::new).stream().map(ValidResultItem::getMessage).collect(Collectors.joining());
            throw new KdVerifyException("WTCVALID_003", resultMessage);
        }
        return validResult;
    }
}

