/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.validate.utils;

import com.kingdee.bos.qing.util.MapUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.common.validate.context.WTCValidatorContext;
import kd.wtc.wtbs.common.validate.context.impl.DefaultValidatorContext;
import kd.wtc.wtbs.common.validate.entity.Rule;
import kd.wtc.wtbs.common.validate.entity.ValidResult;
import kd.wtc.wtbs.common.validate.entity.ValidResultItem;

public class WTCValidator {
    private static final String PROP_SYS_CHECK = "sys.check";
    private static final Log LOGGER = LogFactory.getLog(WTCValidator.class);
    private final WTCValidatorContext context;
    private final WTCValidatorContext defaultContext;
    private static final int MAX_CACHE_SIZE = 100000;

    public WTCValidator() {
        this.context = this.defaultContext = new DefaultValidatorContext();
    }

    public WTCValidator(WTCValidatorContext validatorContext) {
        this.defaultContext = new DefaultValidatorContext();
        this.context = validatorContext;
    }

    public ValidResult verifyMapWithRule(Map<String, Object> valueMap, Rule ... rules) {
        String check = System.getProperty(PROP_SYS_CHECK);
        if (!StringUtils.equals((CharSequence)check, (CharSequence)Boolean.TRUE.toString())) {
            return ValidResult.success();
        }
        if (ArrayUtils.isEmpty((Object[])rules)) {
            return ValidResult.success();
        }
        boolean validResult = true;
        ArrayList<ValidResultItem> items = new ArrayList<ValidResultItem>(10);
        for (Rule rule : rules) {
            String propertyName = rule.getKey();
            if (StringUtils.isBlank((CharSequence)propertyName)) continue;
            Object value = valueMap.get(propertyName);
            Class<Object> parameterClass = rule.getType();
            if (value != null) {
                if (parameterClass != null && !value.getClass().isAssignableFrom(parameterClass)) {
                    items.add(new ValidResultItem(propertyName, "typeErr", "typeValidator"));
                    continue;
                }
                parameterClass = value.getClass();
            }
            if (parameterClass == null) {
                parameterClass = Object.class;
            }
            if (rule.getRequired().booleanValue() && !valueMap.containsKey(propertyName)) {
                items.add(new ValidResultItem(propertyName, "requiredErr", "requiredValidator"));
                validResult = false;
                continue;
            }
            boolean fieldValidResult = this.validByRule(rule, parameterClass, value, propertyName, items);
            validResult = validResult && fieldValidResult;
        }
        return new ValidResult(validResult, items);
    }

    private boolean validByRule(Rule rule, Class<?> fieldClass, Object fieldValue, String propertyName, List<ValidResultItem> items) {
        boolean fieldValidResult = true;
        List<? extends Annotation> annotationList = rule.getAnnotations();
        for (Annotation annotation : annotationList) {
            Map<Class<?>, Class<?>> annotationValidatorMap = this.context.getValidatorMap(annotation.annotationType());
            if (MapUtils.isEmpty(annotationValidatorMap)) continue;
            Set<Map.Entry<Class<?>, Class<?>>> annoEntrySet = annotationValidatorMap.entrySet();
            for (Map.Entry<Class<?>, Class<?>> entry : annoEntrySet) {
                Class<?> validator = entry.getValue();
                if (!entry.getKey().isAssignableFrom(fieldClass)) continue;
                boolean checkValid = WTCValidator.doValidate(validator, fieldValue, annotation);
                boolean bl = fieldValidResult = fieldValidResult && checkValid;
                if (checkValid) continue;
                String message = WTCValidator.getAnnotationMessage(annotation);
                items.add(new ValidResultItem(propertyName, message, validator.getSimpleName()));
            }
        }
        return fieldValidResult;
    }

    private static <T extends Annotation> String getAnnotationMessage(T annotation) {
        Method[] methods;
        Class<?> c = annotation.getClass();
        for (Method method : methods = c.getDeclaredMethods()) {
            if (!method.getName().equals("message") || !String.class.equals(method.getReturnType())) continue;
            try {
                ReflectionUtils.makeAccessible((Method)method);
                return (String)method.invoke(annotation, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return null;
            }
        }
        return null;
    }

    public ValidResult verifyBeanWithRule(Object bean, Rule ... rules) {
        String check = System.getProperty(PROP_SYS_CHECK);
        if (!StringUtils.equals((CharSequence)check, (CharSequence)Boolean.TRUE.toString())) {
            return ValidResult.success();
        }
        if (ArrayUtils.isEmpty((Object[])rules)) {
            return ValidResult.success();
        }
        boolean validResult = true;
        Class<?> beanClass = bean.getClass();
        List<Field> fields = WTCValidator.getAllFields(beanClass);
        Map<String, Field> fieldMap = fields.stream().collect(Collectors.toMap(Field::getName, element -> element, (e1, e2) -> e1));
        ArrayList<ValidResultItem> items = new ArrayList<ValidResultItem>(10);
        for (Rule rule : rules) {
            Field field;
            String propertyName = rule.getKey();
            if (StringUtils.isEmpty((CharSequence)propertyName) || (field = fieldMap.get(propertyName)) == null) continue;
            Class<?> fieldType = field.getType();
            Object value = null;
            ReflectionUtils.makeAccessible((Field)field);
            try {
                value = field.get(bean);
            }
            catch (IllegalAccessException e) {
                LOGGER.warn("validUnknownError{}", (Object)e.getMessage());
            }
            boolean fieldValidResult = this.validByRule(rule, fieldType, value, propertyName, items);
            validResult = validResult && fieldValidResult;
        }
        return new ValidResult(validResult, items);
    }

    public ValidResult verify(Object entity) {
        String check = System.getProperty(PROP_SYS_CHECK);
        if (!StringUtils.equals((CharSequence)check, (CharSequence)Boolean.TRUE.toString())) {
            return ValidResult.success();
        }
        Class<?> clazz = entity.getClass();
        Map<Field, List<Annotation>> beanFieldMap = this.createCache(entity);
        boolean result = true;
        Set<Map.Entry<Field, List<Annotation>>> entries = beanFieldMap.entrySet();
        ArrayList<ValidResultItem> items = new ArrayList<ValidResultItem>(10);
        for (Map.Entry<Field, List<Annotation>> entry : entries) {
            boolean fieldValidResult = true;
            Field field = entry.getKey();
            ReflectionUtils.makeAccessible((Field)field);
            Object fieldVal = null;
            try {
                fieldVal = field.get(entity);
            }
            catch (IllegalAccessException e) {
                LOGGER.warn("validUnknownError", (Throwable)e);
            }
            List<Annotation> annotations = entry.getValue();
            Class<?> typeClass = field.getType();
            for (Annotation annotation : annotations) {
                Map<Class<?>, Class<?>> annotationValidatorMap = this.context.getValidatorMap(annotation.annotationType());
                if (MapUtils.isEmpty(annotationValidatorMap)) continue;
                Set<Map.Entry<Class<?>, Class<?>>> annotationValidatorEntries = annotationValidatorMap.entrySet();
                for (Map.Entry<Class<?>, Class<?>> annotationValidatorEntry : annotationValidatorEntries) {
                    Class<?> validator = annotationValidatorEntry.getValue();
                    Class<?> key = annotationValidatorEntry.getKey();
                    if (!key.isAssignableFrom(typeClass)) continue;
                    boolean checkValid = WTCValidator.doValidate(validator, fieldVal, annotation);
                    boolean bl = fieldValidResult = fieldValidResult && checkValid;
                    if (checkValid) continue;
                    String message = WTCValidator.getAnnotationMessage(annotation);
                    ValidResultItem item = new ValidResultItem();
                    item.setMessage(validator.getSimpleName());
                    item.setMessage(message);
                    item.setPropertyName(field.getName());
                    items.add(item);
                }
            }
            result = result && fieldValidResult;
        }
        return new ValidResult(result, items);
    }

    private static <T extends Annotation> boolean doValidate(Class<?> validator, Object val, T annotation) {
        try {
            ConstraintValidator instance = (ConstraintValidator)validator.newInstance();
            instance.initialize(annotation);
            return instance.isValid(val, null);
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.warn("validUnknownError{}", (Object)e.getMessage());
            return true;
        }
    }

    private Map<Field, List<Annotation>> createCache(Object bean) {
        Class<?> clazz = bean.getClass();
        List<Field> fields = WTCValidator.getAllFields(clazz);
        HashMap<Field, List<Annotation>> beanFieldMap = new HashMap<Field, List<Annotation>>(fields.size());
        for (Field field : fields) {
            Annotation[] annotations = field.getDeclaredAnnotations();
            beanFieldMap.put(field, Arrays.asList(annotations));
        }
        return beanFieldMap;
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        List<Field> fieldList = new ArrayList<Field>(fields.length);
        fieldList.addAll(Arrays.asList(fields));
        while (!clazz.equals(Object.class)) {
            clazz = clazz.getSuperclass();
            fields = clazz.getDeclaredFields();
            fieldList.addAll(Arrays.asList(fields));
        }
        fieldList = WTCValidator.filterFields(fieldList);
        return fieldList;
    }

    private static List<Field> filterFields(List<Field> fields) {
        HashMap<String, Set> map = new HashMap<String, Set>(fields.size());
        ArrayList<Field> result = new ArrayList<Field>(fields.size());
        for (Field field : fields) {
            Set set = map.getOrDefault(field.getName(), new HashSet());
            map.put(field.getName(), set);
            if (set.contains(field.getType())) continue;
            set.add(field.getType());
            result.add(field);
        }
        return result;
    }
}

