/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.validate.validator.internal.constraintvalidators.bv.number;

import java.util.OptionalInt;

public final class InfinityNumberComparatorHelper {
    public static final OptionalInt LESS_THAN = OptionalInt.of(-1);
    public static final OptionalInt FINITE_VALUE = OptionalInt.empty();
    public static final OptionalInt GREATER_THAN = OptionalInt.of(1);

    private InfinityNumberComparatorHelper() {
    }

    public static OptionalInt infinityCheck(Double number, OptionalInt treatNanAs) {
        OptionalInt result = FINITE_VALUE;
        if (number != null) {
            double n = number;
            if (n == Double.NEGATIVE_INFINITY) {
                result = LESS_THAN;
            } else if (number.isNaN()) {
                result = treatNanAs;
            } else if (n == Double.POSITIVE_INFINITY) {
                result = GREATER_THAN;
            }
        }
        return result;
    }

    public static OptionalInt infinityCheck(Float number, OptionalInt treatNanAs) {
        OptionalInt result = FINITE_VALUE;
        if (number.equals(Float.valueOf(Float.NEGATIVE_INFINITY))) {
            result = LESS_THAN;
        } else if (number.isNaN()) {
            result = treatNanAs;
        } else if (number.equals(Float.valueOf(Float.POSITIVE_INFINITY))) {
            result = GREATER_THAN;
        }
        return result;
    }
}

