/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.opplugin.web.bill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbs.common.enums.WTCBillChangeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCMaps;

public class WTCBillReplenishOriginalOp
extends HRDataBaseOp {
    private static Map<String, WTCBillChangeEnum> map = new HashMap<String, WTCBillChangeEnum>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(WTCBillChangeEnum.BUSTRIP.getFILTER());
        e.getFieldKeys().add(WTCBillChangeEnum.BUSTRIP.getPARENT());
        e.getFieldKeys().add(WTCBillChangeEnum.VACATION.getFILTER());
        e.getFieldKeys().add(WTCBillChangeEnum.VACATION.getPARENT());
        e.getFieldKeys().add("originalid");
        e.getFieldKeys().add(WTCBillChangeEnum.OTAPPLY.getPARENT());
        e.getFieldKeys().add(WTCBillChangeEnum.OTAPPLY.getFILTER());
        e.getFieldKeys().add(WTCBillChangeEnum.SUP.getPARENT());
        e.getFieldKeys().add(WTCBillChangeEnum.SUP.getFILTER());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs ee) {
        HashMap changeBillParentIds = new HashMap(4);
        HashMap changeBillDysMap = new HashMap(4);
        Arrays.stream(ee.getDataEntities()).forEach(dy -> {
            String dyTypeName = dy.getDataEntityType().getName();
            WTCBillChangeEnum billEnum = map.get(dyTypeName);
            if (billEnum != null && dy.getLong("originalid") == 0L) {
                if (!dy.getBoolean("ischange")) {
                    dy.set("originalid", (Object)dy.getLong("id"));
                } else {
                    ArrayList<Long> parentIds = (ArrayList<Long>)changeBillParentIds.get(dyTypeName);
                    Long parentId = dy.getLong(billEnum.getPARENT());
                    if (WTCCollections.isEmpty((Collection)parentIds)) {
                        parentIds = new ArrayList<Long>();
                    }
                    parentIds.add(parentId);
                    changeBillParentIds.put(dyTypeName, parentIds);
                    HashMap<Long, DynamicObject> parentMap = (HashMap<Long, DynamicObject>)changeBillDysMap.get(dyTypeName);
                    if (WTCCollections.isEmpty((Map)parentMap)) {
                        parentMap = new HashMap<Long, DynamicObject>(1);
                    }
                    parentMap.put(parentId, (DynamicObject)dy);
                    changeBillDysMap.put(dyTypeName, parentMap);
                }
            }
        });
        if (WTCMaps.isNotEmpty(changeBillParentIds)) {
            Set entries = changeBillParentIds.entrySet();
            entries.forEach(entry -> {
                HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)((String)entry.getKey()));
                DynamicObject[] dynamicObjects = serviceHelper.query("id,originalid", new QFilter("id", "in", entry.getValue()).toArray());
                Map dyMap = (Map)changeBillDysMap.get(entry.getKey());
                for (DynamicObject parent : dynamicObjects) {
                    DynamicObject dy = (DynamicObject)dyMap.get(parent.getLong("id"));
                    if (dy == null) continue;
                    dy.set("originalid", (Object)parent.getLong("originalid"));
                }
            });
        }
        super.beginOperationTransaction(ee);
    }

    static {
        map.put("wtam_busitripbill", WTCBillChangeEnum.BUSTRIP);
        map.put("wtam_busitripselfbill", WTCBillChangeEnum.BUSTRIP);
        map.put("wtam_busibillchange", WTCBillChangeEnum.BUSTRIP);
        map.put("wtam_busiselfbillchange", WTCBillChangeEnum.BUSTRIP);
        map.put("wtom_otbillchange", WTCBillChangeEnum.OTAPPLY);
        map.put("wtom_otselfbillchange", WTCBillChangeEnum.OTAPPLY);
        map.put("wtom_overtimeapplybill", WTCBillChangeEnum.OTAPPLY);
        map.put("wtom_otbillself", WTCBillChangeEnum.OTAPPLY);
        map.put("wtabm_vaapply", WTCBillChangeEnum.VACATION);
        map.put("wtabm_vaapplyself", WTCBillChangeEnum.VACATION);
        map.put("wtabm_vaupdate", WTCBillChangeEnum.VACATION);
        map.put("wtabm_vaupdateself", WTCBillChangeEnum.VACATION);
        map.put("wtpm_supsignpc", WTCBillChangeEnum.SUP);
        map.put("wtpm_supsignpcchange", WTCBillChangeEnum.SUP);
        map.put("wtpm_supsignself", WTCBillChangeEnum.SUP);
        map.put("wtpm_supsignselfchange", WTCBillChangeEnum.SUP);
    }
}

