/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.opplugin.web.bill.batchbill;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.opplugin.web.bill.batchbill.validator.BatchBillTplValidator;

public class BatchBillTplOp
extends HRDataBaseOp {
    private long currUserId = 0L;
    private Date currDateTime = null;
    private static final Map<String, String> BILLAUDITSTATUS_MAP = Maps.newHashMapWithExpectedSize((int)16);
    private static final Map<String, String> BILLNOENTITY_MAP = Maps.newHashMapWithExpectedSize((int)16);
    private static final List<String> HANDLEOPERATEOPS;

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        List props = BillCommonService.collectEntityAllProp((MainEntityType)this.billEntityType);
        args.getFieldKeys().addAll(props);
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new BatchBillTplValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        String operateKey = args.getOperationKey();
        if (!HANDLEOPERATEOPS.contains(operateKey)) {
            return;
        }
        for (DynamicObject batchBillDy : dataEntities) {
            this.setSubmitInfo(batchBillDy, operateKey);
            this.setBillStatus(batchBillDy);
            this.setOriginalId(batchBillDy, false);
            this.setBatchBillEntryBillNo(batchBillDy);
            DynamicObjectCollection singleBillColl = batchBillDy.getDynamicObjectCollection("entryentity");
            for (int index = 0; index < singleBillColl.size(); ++index) {
                DynamicObject singleBillDy = (DynamicObject)singleBillColl.get(index);
                singleBillDy.set("entrycreator", batchBillDy.get("creator"));
                singleBillDy.set("entrycreatetime", batchBillDy.get("createtime"));
                singleBillDy.set("entrymodifier", batchBillDy.get("modifier"));
                singleBillDy.set("entrymodifytime", batchBillDy.get("modifytime"));
                singleBillDy.set("entryauditor", batchBillDy.get("auditor"));
                singleBillDy.set("entryauditdate", batchBillDy.get("auditdate"));
                singleBillDy.set("entrysubmitter", batchBillDy.get("submitter"));
                singleBillDy.set("entrysubmittime", batchBillDy.get("submittime"));
                Object entryOrg = singleBillDy.get("entryorg");
                if (entryOrg == null) {
                    DynamicObject attFileVDy = singleBillDy.getDynamicObject("attfilebasef7");
                    if (attFileVDy != null) {
                        singleBillDy.set("entryorg", attFileVDy.get("org"));
                    } else {
                        singleBillDy.set("entryorg", batchBillDy.get("org"));
                    }
                }
                singleBillDy.set("entryisexistsworkflow", batchBillDy.get("isexistsworkflow"));
                singleBillDy.set("entryauditstatus", batchBillDy.get("auditstatus"));
                singleBillDy.set("entrybillstatus", batchBillDy.get("billstatus"));
                singleBillDy.set("entryischangebill", batchBillDy.get("ischangebill"));
                this.setOriginalId(singleBillDy, true);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    private void setOriginalId(DynamicObject batchBillDy, boolean isEntry) {
        boolean isChangeBill = isEntry ? batchBillDy.getBoolean("entryischangebill") : batchBillDy.getBoolean("ischangebill");
        if (!isChangeBill) {
            if (isEntry) {
                batchBillDy.set("entryoriginalid", batchBillDy.get("id"));
            } else {
                batchBillDy.set("originalid", batchBillDy.get("id"));
            }
        }
    }

    private void setBillStatus(DynamicObject batchBillDy) {
        String billStatus = batchBillDy.getString("billstatus");
        String auditStatus = BILLAUDITSTATUS_MAP.get(billStatus);
        batchBillDy.set("auditstatus", (Object)auditStatus);
    }

    private void setSubmitInfo(DynamicObject batchBillDy, String operateKey) {
        if ("submit".equals(operateKey) || "submiteffect".equals(operateKey)) {
            this.initCurrInfo();
            batchBillDy.set("submitter", (Object)this.currUserId);
            batchBillDy.set("submittime", (Object)this.currDateTime);
        }
    }

    private void setBatchBillEntryBillNo(DynamicObject batchBillDy) {
        DynamicObjectCollection singleBillColl = batchBillDy.getDynamicObjectCollection("entryentity");
        List billNoEmptys = singleBillColl.stream().filter(item -> HRStringUtils.isEmpty((String)item.getString("entrybillno"))).collect(Collectors.toList());
        if (WTCCollections.isEmpty(billNoEmptys)) {
            return;
        }
        String[] numbers = null;
        String entityId = batchBillDy.getDynamicObjectType().getName();
        String entryBillNoEntityId = BILLNOENTITY_MAP.get(entityId);
        if (WTCCollections.isNotEmpty(billNoEmptys) && HRStringUtils.isNotEmpty((String)entryBillNoEntityId)) {
            long orgId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)batchBillDy, (String)"org");
            DynamicObject entryBillDy = HRBaseServiceHelper.create((String)entryBillNoEntityId).generateEmptyDynamicObject();
            numbers = CodeRuleServiceHelper.getBatchNumber((String)entryBillNoEntityId, (DynamicObject)entryBillDy, (String)String.valueOf(orgId), (int)billNoEmptys.size());
        }
        if (numbers != null && numbers.length > 0) {
            for (int index = 0; index < billNoEmptys.size(); ++index) {
                this.setEntryBillNo((DynamicObject)billNoEmptys.get(index), numbers, index);
            }
        }
    }

    private void setEntryBillNo(DynamicObject singleBillDy, String[] numbers, int index) {
        if (HRStringUtils.isEmpty((String)singleBillDy.getString("entrybillno")) && numbers != null && numbers.length > index) {
            singleBillDy.set("entrybillno", (Object)numbers[index]);
        }
    }

    private void initCurrInfo() {
        if (this.currUserId == 0L) {
            this.currUserId = RequestContext.get().getCurrUserId();
        }
        if (this.currDateTime == null) {
            this.currDateTime = WTCDateUtils.toDate((LocalDateTime)LocalDateTime.now());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
    }

    static {
        BILLAUDITSTATUS_MAP.put("A", "A");
        BILLAUDITSTATUS_MAP.put("B", "B");
        BILLAUDITSTATUS_MAP.put("C", "C");
        BILLAUDITSTATUS_MAP.put("D", "B");
        BILLAUDITSTATUS_MAP.put("E", "A");
        BILLAUDITSTATUS_MAP.put("F", "F");
        BILLAUDITSTATUS_MAP.put("G", "A");
        BILLNOENTITY_MAP.put("wtabm_batchvaapply", "wtabm_batchvaapply_code");
        BILLNOENTITY_MAP.put("wtabm_batchvaupdate", "wtabm_batchvaupdate_code");
        HANDLEOPERATEOPS = Lists.newArrayList((Object[])new String[]{"save", "submit", "submiteffect", "unsubmit", "discard", "audit", "wfauditnotpass", "wfrejecttosubmit"});
    }
}

