/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.opplugin.web.bill.batchbill;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class BatchBillUpdateAttFileOp
extends HRDataBaseOp {
    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        this.updateAttFileVersion(dataEntities);
    }

    private void updateAttFileVersion(DynamicObject[] dataEntities) {
        HashSet attFileBoIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDy : entryColl) {
                long attFileBoId = entryDy.getLong("attfile.id");
                attFileBoIds.add(attFileBoId);
            }
        }
        String entityNumber = "wtabm_batchvaapply";
        OperateOption option = this.getOption();
        String appId = BillCommonService.getInstance().getAppIdFromOp(option);
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr();
        applyAttr.setAttFileAuthField("attfilebasef7");
        applyAttr.setAttFileF7AuthAppId(appId);
        applyAttr.setAttFileF7AuthEntity(entityNumber);
        String queryProp = "id,boid,textname,personnum";
        Map attFileBoTopMap = BillCommonService.getInstance().getAttFileBoTop1((Set)attFileBoIds, applyAttr, queryProp);
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtp_attfilebase");
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDy : entryColl) {
                long attFileBoId = entryDy.getLong("attfile.id");
                long attFileVId = entryDy.getLong("attfilebasef7.id");
                DynamicObject attFileVersion = (DynamicObject)attFileBoTopMap.get(attFileBoId);
                if (attFileVersion == null || attFileVId == attFileVersion.getLong("id")) continue;
                DynamicObject emptyAttFileDy = serviceHelper.generateEmptyDynamicObject();
                emptyAttFileDy.set("id", (Object)attFileVersion.getLong("id"));
                emptyAttFileDy.set("boid", (Object)attFileVersion.getLong("boid"));
                emptyAttFileDy.set("textname", attFileVersion.get("textname"));
                emptyAttFileDy.set("personnum", attFileVersion.get("personnum"));
                entryDy.set("attfilebasef7", (Object)emptyAttFileDy);
            }
        }
    }
}

