/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.opplugin.web.bill.validator;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyKDStringHelper;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;

public class WTCBillAttFileValidator
extends AbstractValidator {
    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length <= 0) {
            return;
        }
        Map discardAttFileBoIdMap = BillCommonService.getInstance().getDiscardAttFileBoId(this.getDataEntities());
        String billName = this.getBillName();
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject formEntity = dataEntity.getDataEntity();
            DynamicObject attFile = formEntity.getDynamicObject("attfile");
            String attFileNumber = (String)discardAttFileBoIdMap.get(attFile.getLong("id"));
            if (!HRStringUtils.isNotEmpty((String)attFileNumber)) continue;
            this.addErrorMessage(dataEntity, BillUnifyKDStringHelper.notEffAttFile((String)billName, (String)attFileNumber));
        }
    }

    private String getBillName() {
        String entityId = this.getDataEntities()[0].getDataEntity().getDynamicObjectType().getName();
        String appNumber = StringUtils.substring((String)entityId, (int)0, (int)StringUtils.indexOf((CharSequence)entityId, (CharSequence)"_"));
        String billName = "";
        if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtam")) {
            billName = BillTypeEnum.EVECTIONBILL.getBillName();
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtabm")) {
            billName = BillTypeEnum.VACATIONBILL.getBillName();
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtom")) {
            billName = BillTypeEnum.OVERTIMEBILL.getBillName();
        } else if (StringUtils.equals((CharSequence)appNumber, (CharSequence)"wtpm")) {
            billName = BillTypeEnum.SUPPLEMENTBILL.getBillName();
        }
        return billName;
    }
}

