/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.opplugin.web.bill.validator;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.validator.HRCoreBaseBillValidator;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.common.bill.BillApplyTypePlusEnum;
import kd.wtc.wtbs.common.bill.BillCommonKDString;
import kd.wtc.wtbs.common.bill.batchbill.BatchBillKDString;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;

public class WTCBillOtherValidator
extends HRCoreBaseBillValidator {
    private static final Log LOGGER = LogFactory.getLog(WTCBillOtherValidator.class);
    private static final Map<String, Map<BillApplyTypePlusEnum, Map<String, Function<String, String>>>> BILLSTATUSOPMAP_WTAM_OTHER = new HashMap<String, Map<BillApplyTypePlusEnum, Map<String, Function<String, String>>>>(16);
    private static final Map<String, Map<BillApplyTypePlusEnum, Map<String, Function<String, String>>>> BILLSTATUSOPMAP_WTSS = new HashMap<String, Map<BillApplyTypePlusEnum, Map<String, Function<String, String>>>>(16);

    public void validate() {
        Long curAttPersonId;
        String opName = BillUnifyService.getOpName((String)this.getEntityKey(), (String)this.getOperateKey());
        String operateKey = this.getOperateKey();
        OperateOption option = this.getOption();
        String appId = null;
        if (option.containsVariable("currbizappid")) {
            appId = option.getVariableValue("currbizappid");
        }
        curAttPersonId = (curAttPersonId = BillUnifyService.getUserId((OperateOption)option)) == null ? Long.valueOf(0L) : curAttPersonId;
        long currUserId = RequestContext.get().getCurrUserId();
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            Map<String, Function<String, String>> opMsgMap;
            DynamicObject attPerson;
            Object applyType = dataEntity.getValue("applytyperadio");
            if (BillApplyTypeEnum.BATCH.getCode().equals(applyType)) {
                this.addErrorMessage(dataEntity, BatchBillKDString.canNotOpBatchBIll((String)opName));
                continue;
            }
            if (!"1".equals(applyType)) continue;
            DynamicObject creator = (DynamicObject)dataEntity.getValue("creator");
            if (creator == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u521b\u5efa\u4eba\u201d\u3002", (String)"WTCBillOtherValidator_0", (String)"wtc-wtbs-opplugin", (Object[])new Object[0]));
                continue;
            }
            long creatorId = creator.getLong("id");
            String billstatus = String.valueOf(dataEntity.getValue("billstatus"));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("WTCBillOtherValidator_validate creatorId={},billStatus = {}", (Object)creatorId, (Object)billstatus);
            }
            if ((attPerson = (DynamicObject)dataEntity.getValue("personid")) == null) continue;
            BillCommonService billCommonService = BillCommonService.getInstance();
            BillApplyTypePlusEnum billApplyTypePlus = billCommonService.getBillApplyTypePlus(dataEntity.getDataEntity(), curAttPersonId);
            Map<String, Map<BillApplyTypePlusEnum, Map<String, Function<String, String>>>> map = "wtss".equals(appId) ? BILLSTATUSOPMAP_WTSS : BILLSTATUSOPMAP_WTAM_OTHER;
            Map<BillApplyTypePlusEnum, Map<String, Function<String, String>>> buTypeOpMsgMap = map.get(billstatus);
            if (WTCCollections.isEmpty(buTypeOpMsgMap) || WTCCollections.isEmpty(opMsgMap = buTypeOpMsgMap.get(billApplyTypePlus))) continue;
            Function<String, String> msgFun = opMsgMap.get(operateKey);
            if (msgFun != null) {
                this.addErrorMessage(dataEntity, msgFun.apply(opName));
            }
            if (creatorId != currUserId || curAttPersonId.longValue() != attPerson.getLong("id")) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u53ef\u4ee3\u81ea\u5df1\u53d1\u8d77\u7533\u8bf7\u64cd\u4f5c\u3002", (String)"WTCBillOtherValidator_2", (String)"wtc-wtbs-opplugin", (Object[])new Object[0]));
        }
        super.validate();
    }

    static {
        HashMap busTypeOpMapA = new HashMap(16);
        HashMap<String, Function<String, String>> opMsgMapAOther = new HashMap<String, Function<String, String>>(16);
        opMsgMapAOther.put("submit", BillCommonKDString::noAllowHeSelf);
        opMsgMapAOther.put("submiteffect", BillCommonKDString::noAllowHeSelf);
        opMsgMapAOther.put("discard", BillCommonKDString::noAllowHeSelf);
        opMsgMapAOther.put("delete", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapA.put(BillApplyTypePlusEnum.OTHER_FOR_OTHER, opMsgMapAOther);
        HashMap<String, Function<String, String>> opMsgMapAOtherMe = new HashMap<String, Function<String, String>>(16);
        opMsgMapAOtherMe.put("submit", BillCommonKDString::noAllowHeSelf);
        opMsgMapAOtherMe.put("submiteffect", BillCommonKDString::noAllowHeSelf);
        opMsgMapAOtherMe.put("discard", BillCommonKDString::noAllowHeSelf);
        opMsgMapAOtherMe.put("delete", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapA.put(BillApplyTypePlusEnum.OTHER_FOR_ME, opMsgMapAOtherMe);
        BILLSTATUSOPMAP_WTAM_OTHER.put("A", busTypeOpMapA);
        HashMap busTypeOpMapBD = new HashMap(16);
        HashMap<String, Function<String, String>> opMsgMapAOtherMeB = new HashMap<String, Function<String, String>>(16);
        opMsgMapAOtherMeB.put("unsubmit", BillCommonKDString::notAllowOtherForMe);
        busTypeOpMapBD.put(BillApplyTypePlusEnum.OTHER_FOR_ME, opMsgMapAOtherMeB);
        BILLSTATUSOPMAP_WTAM_OTHER.put("B", busTypeOpMapBD);
        BILLSTATUSOPMAP_WTAM_OTHER.put("D", busTypeOpMapBD);
        HashMap busTypeOpMapG = new HashMap(16);
        HashMap<String, Function<String, String>> opMsgMapAOtherG = new HashMap<String, Function<String, String>>(16);
        opMsgMapAOtherG.put("submit", BillCommonKDString::noAllowHeSelf);
        opMsgMapAOtherG.put("discard", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapG.put(BillApplyTypePlusEnum.OTHER_FOR_OTHER, opMsgMapAOtherG);
        HashMap<String, Function<String, String>> opMsgMapAOtherForMeG = new HashMap<String, Function<String, String>>(16);
        opMsgMapAOtherForMeG.put("submit", BillCommonKDString::noAllowHeSelf);
        opMsgMapAOtherForMeG.put("discard", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapG.put(BillApplyTypePlusEnum.OTHER_FOR_ME, opMsgMapAOtherForMeG);
        BILLSTATUSOPMAP_WTAM_OTHER.put("G", busTypeOpMapG);
        HashMap busTypeOpMapOA = new HashMap(16);
        HashMap<String, Function<String, String>> opMsgMapAOtherO = new HashMap<String, Function<String, String>>(16);
        opMsgMapAOtherO.put("submit", BillCommonKDString::noAllowHeSelf);
        opMsgMapAOtherO.put("submiteffect", BillCommonKDString::noAllowHeSelf);
        opMsgMapAOtherO.put("discard", BillCommonKDString::noAllowHeSelf);
        opMsgMapAOtherO.put("delete", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapOA.put(BillApplyTypePlusEnum.OTHER_FOR_OTHER, opMsgMapAOtherO);
        HashMap<String, Function<String, String>> opMsgMapAOtherMeO = new HashMap<String, Function<String, String>>(16);
        opMsgMapAOtherMeO.put("submit", BillCommonKDString::noAllowHeSelf);
        opMsgMapAOtherMeO.put("submiteffect", BillCommonKDString::noAllowHeSelf);
        opMsgMapAOtherMeO.put("discard", BillCommonKDString::noAllowHeSelf);
        opMsgMapAOtherMeO.put("delete", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapOA.put(BillApplyTypePlusEnum.OTHER_FOR_ME, opMsgMapAOtherMeO);
        HashMap<String, Function<String, String>> opMsgMapAMeOtherO = new HashMap<String, Function<String, String>>(16);
        opMsgMapAMeOtherO.put("submiteffect", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapOA.put(BillApplyTypePlusEnum.ME_FOR_OTHER, opMsgMapAMeOtherO);
        BILLSTATUSOPMAP_WTSS.put("A", busTypeOpMapOA);
        HashMap busTypeOpMapBDO = new HashMap(16);
        HashMap<String, Function<String, String>> opMsgMapAOtherMeBO = new HashMap<String, Function<String, String>>(16);
        opMsgMapAOtherMeBO.put("unsubmit", BillCommonKDString::onlyOpSelf);
        busTypeOpMapBDO.put(BillApplyTypePlusEnum.OTHER_FOR_ME, opMsgMapAOtherMeBO);
        HashMap<String, Function<String, String>> opMsgMapAOtherOtherBO = new HashMap<String, Function<String, String>>(16);
        opMsgMapAOtherOtherBO.put("unsubmit", BillCommonKDString::onlyOpSelf);
        busTypeOpMapBDO.put(BillApplyTypePlusEnum.OTHER_FOR_OTHER, opMsgMapAOtherOtherBO);
        BILLSTATUSOPMAP_WTSS.put("B", busTypeOpMapBDO);
        BILLSTATUSOPMAP_WTSS.put("D", busTypeOpMapBDO);
        HashMap busTypeOpMapGO = new HashMap(16);
        HashMap<String, Function<String, String>> opMsgMapAOtherGO = new HashMap<String, Function<String, String>>(16);
        opMsgMapAOtherGO.put("submit", BillCommonKDString::noAllowHeSelf);
        opMsgMapAOtherGO.put("discard", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapGO.put(BillApplyTypePlusEnum.OTHER_FOR_OTHER, opMsgMapAOtherGO);
        HashMap<String, Function<String, String>> opMsgMapAOtherForMeGO = new HashMap<String, Function<String, String>>(16);
        opMsgMapAOtherForMeGO.put("submit", BillCommonKDString::noAllowHeSelf);
        opMsgMapAOtherForMeGO.put("discard", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapGO.put(BillApplyTypePlusEnum.OTHER_FOR_ME, opMsgMapAOtherForMeGO);
        BILLSTATUSOPMAP_WTSS.put("G", busTypeOpMapGO);
    }
}

