/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.opplugin.web.bill.validator;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRCoreBaseBillValidator;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.common.bill.BillApplyTypePlusEnum;
import kd.wtc.wtbs.common.bill.BillCommonKDString;
import kd.wtc.wtbs.common.bill.batchbill.BatchBillKDString;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;

public class WTCBillSelfAttFileAuthValidator
extends HRCoreBaseBillValidator {
    private static final Map<String, Map<BillApplyTypePlusEnum, Map<String, Function<String, String>>>> BILLSTATUSOPMAP_WTAM_OTHER = new HashMap<String, Map<BillApplyTypePlusEnum, Map<String, Function<String, String>>>>(16);
    private static final Map<String, Map<BillApplyTypePlusEnum, Map<String, Function<String, String>>>> BILLSTATUSOPMAP_WTSS = new HashMap<String, Map<BillApplyTypePlusEnum, Map<String, Function<String, String>>>>(16);

    public void validate() {
        super.validate();
        String opName = BillUnifyService.getOpName((String)this.getEntityKey(), (String)this.getOperateKey());
        String operateKey = this.getOperateKey();
        OperateOption option = this.getOption();
        String appId = null;
        if (option.containsVariable("currbizappid")) {
            appId = option.getVariableValue("currbizappid");
        }
        Long curAttPersonId = BillUnifyService.getUserId((OperateOption)option);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            Function<String, String> stringStringFunction;
            Map<String, Function<String, String>> stringFunctionMap;
            Object applyType = dataEntity.getValue("applytyperadio");
            if (BillApplyTypeEnum.BATCH.getCode().equals(applyType)) {
                this.addErrorMessage(dataEntity, BatchBillKDString.canNotOpBatchBIll((String)opName));
                continue;
            }
            if (!"0".equals(applyType)) continue;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String billStatus = dynamicObject.getString("billstatus");
            BillCommonService billCommonService = BillCommonService.getInstance();
            BillApplyTypePlusEnum billApplyTypePlus = billCommonService.getBillApplyTypePlus(dynamicObject, curAttPersonId);
            Map<String, Map<BillApplyTypePlusEnum, Map<String, Function<String, String>>>> map = "wtss".equals(appId) ? BILLSTATUSOPMAP_WTSS : BILLSTATUSOPMAP_WTAM_OTHER;
            Map<BillApplyTypePlusEnum, Map<String, Function<String, String>>> billApplyTypePlusEnumMapMap = map.get(billStatus);
            if (WTCCollections.isEmpty(billApplyTypePlusEnumMapMap) || WTCCollections.isEmpty(stringFunctionMap = billApplyTypePlusEnumMapMap.get(billApplyTypePlus)) || (stringStringFunction = stringFunctionMap.get(operateKey)) == null) continue;
            this.addErrorMessage(dataEntity, stringStringFunction.apply(opName));
        }
    }

    static {
        HashMap busTypeOpMapA = new HashMap(16);
        HashMap<String, Function<String, String>> busTypeOpMapAMsgMapA = new HashMap<String, Function<String, String>>(16);
        busTypeOpMapAMsgMapA.put("submit", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapAMsgMapA.put("submiteffect", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapAMsgMapA.put("discard", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapAMsgMapA.put("delete", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapA.put(BillApplyTypePlusEnum.OTHER_FOR_HERSELF, busTypeOpMapAMsgMapA);
        HashMap<String, Function<String, String>> busTypeOpMapAMsgMapAS = new HashMap<String, Function<String, String>>(16);
        busTypeOpMapAMsgMapAS.put("submiteffect", BillCommonKDString::notAllowOtherPage);
        busTypeOpMapA.put(BillApplyTypePlusEnum.ME_FOR_SELF, busTypeOpMapAMsgMapAS);
        BILLSTATUSOPMAP_WTAM_OTHER.put("A", busTypeOpMapA);
        HashMap busTypeOpMapG = new HashMap(16);
        HashMap<String, Function<String, String>> busTypeOpMapAMsgMapG = new HashMap<String, Function<String, String>>(16);
        busTypeOpMapAMsgMapG.put("submit", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapAMsgMapG.put("discard", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapG.put(BillApplyTypePlusEnum.OTHER_FOR_HERSELF, busTypeOpMapAMsgMapG);
        BILLSTATUSOPMAP_WTAM_OTHER.put("G", busTypeOpMapG);
        HashMap busTypeOpMapOA = new HashMap(16);
        HashMap<String, Function<String, String>> busTypeOpMapAMsgMapOA = new HashMap<String, Function<String, String>>(16);
        busTypeOpMapAMsgMapOA.put("submit", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapAMsgMapOA.put("submiteffect", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapAMsgMapOA.put("discard", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapAMsgMapOA.put("delete", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapOA.put(BillApplyTypePlusEnum.OTHER_FOR_HERSELF, busTypeOpMapAMsgMapOA);
        HashMap<String, Function<String, String>> busTypeOpMapAMsgMapOAS = new HashMap<String, Function<String, String>>(16);
        busTypeOpMapAMsgMapOAS.put("submiteffect", BillCommonKDString::notAllowOtherPage);
        busTypeOpMapOA.put(BillApplyTypePlusEnum.ME_FOR_SELF, busTypeOpMapAMsgMapOAS);
        BILLSTATUSOPMAP_WTSS.put("A", busTypeOpMapOA);
        HashMap busTypeOpMapOBD = new HashMap(16);
        HashMap<String, Function<String, String>> busTypeOpMapAMsgMapOBD = new HashMap<String, Function<String, String>>(16);
        busTypeOpMapAMsgMapOBD.put("unsubmit", BillCommonKDString::onlyOpSelf);
        busTypeOpMapOBD.put(BillApplyTypePlusEnum.OTHER_FOR_HERSELF, busTypeOpMapAMsgMapOBD);
        BILLSTATUSOPMAP_WTSS.put("B", busTypeOpMapOBD);
        BILLSTATUSOPMAP_WTSS.put("D", busTypeOpMapOBD);
        HashMap busTypeOpMapOG = new HashMap(16);
        HashMap<String, Function<String, String>> busTypeOpMapAMsgMapOG = new HashMap<String, Function<String, String>>(16);
        busTypeOpMapAMsgMapOG.put("submit", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapAMsgMapOG.put("discard", BillCommonKDString::noAllowHeSelf);
        busTypeOpMapOG.put(BillApplyTypePlusEnum.OTHER_FOR_HERSELF, busTypeOpMapAMsgMapOG);
        BILLSTATUSOPMAP_WTSS.put("G", busTypeOpMapOG);
    }
}

