/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.opplugin.web.bill.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRCoreBaseBillValidator;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class WTCBillStatusValidator
extends HRCoreBaseBillValidator {
    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        String operateKey = this.getOperateKey();
        Set queryIds = Arrays.stream(dataEntities).map(de -> de.getDataEntity().getLong("id")).collect(Collectors.toSet());
        String name = dataEntities[0].getDataEntity().getDataEntityType().getName();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(name);
        DynamicObject[] dbData = serviceHelper.query("id,billstatus", new QFilter[]{new QFilter("id", "in", queryIds)});
        HashMap idAndStatus = Maps.newHashMapWithExpectedSize((int)dbData.length);
        for (DynamicObject dynamicObject : dbData) {
            idAndStatus.put(dynamicObject.getLong("id"), dynamicObject.getString("billstatus"));
        }
        for (DynamicObject dynamicObject : this.getDataEntities()) {
            Map variables;
            boolean isList;
            String status;
            long billId = dynamicObject.getDataEntity().getLong("id");
            if (billId == 0L || (status = (String)idAndStatus.get(billId)) == null) continue;
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save") && !StringUtils.equalsAny((CharSequence)status, (CharSequence[])new CharSequence[]{"A", "G"})) {
                this.addErrorMessage((ExtendedDataEntity)dynamicObject, ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u6216\u5f85\u91cd\u65b0\u63d0\u4ea4\u7684\u5355\u636e\u624d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"WTCBillStatusValidator_0", (String)"wtc-wtbs-opplugin", (Object[])new Object[0]));
            }
            boolean bl = isList = (variables = this.getOption().getVariables()) != null && variables.containsKey("BILL_LIST_OP") && HRStringUtils.equals((String)((String)variables.get("BILL_LIST_OP")), (String)"BILL_LIST_OP_TRUE");
            if (isList || !StringUtils.equals((CharSequence)operateKey, (CharSequence)"discard") || StringUtils.equalsAny((CharSequence)status, (CharSequence[])new CharSequence[]{"A", "G"})) continue;
            this.addErrorMessage((ExtendedDataEntity)dynamicObject, ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5e9f\u5f03\u6682\u5b58\u6216\u5f85\u91cd\u65b0\u63d0\u4ea4\u7684\u5355\u636e\u3002", (String)"WTCBillStatusValidator_1", (String)"wtc-wtbs-opplugin", (Object[])new Object[0]));
        }
    }
}

