/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.opplugin.web.bill.validator;

import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRCoreBaseBillValidator;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class WTCBillUpdateAttfileValidator
extends HRCoreBaseBillValidator {
    private static final Log LOG = LogFactory.getLog(WTCBillUpdateAttfileValidator.class);

    public void validate() {
        super.validate();
        this.checkAttfileChange();
    }

    private void checkAttfileChange() {
        Set attFIleBoSet = WTCCollections.modifiableEmptySet();
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject formEntity = dataEntity.getDataEntity();
            Object attFileDy = formEntity.get("attfilebasef7");
            if (attFileDy == null) {
                return;
            }
            long attfileBo = formEntity.getLong("attfile.id");
            attFIleBoSet.add(attfileBo);
        }
        BillCommonService billCommonService = new BillCommonService();
        String name = this.getEntityKey();
        if ("wtpm_supsignpc".equals(name)) {
            name = "wtpm_supsignpcqueryconf";
        }
        String appId = "";
        OperateOption option = this.getOption();
        appId = BillCommonService.getInstance().getAppIdFromOp(option);
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr();
        applyAttr.setAttFileAuthField("attfilebasef7");
        applyAttr.setAttFileF7AuthAppId(appId);
        applyAttr.setAttFileF7AuthEntity(name);
        Map attFileVersionMap = billCommonService.getAttFileBoTop1(attFIleBoSet, applyAttr, WTCStringUtils.joinOnComma((String[])new String[]{AttFileQueryParam.baseProperties, "attperson"}));
        Map variables = this.getOption().getVariables();
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject formEntity = dataEntity.getDataEntity();
            String billNo = formEntity.getString("billno");
            long attfile = formEntity.getLong("attfilebasef7.id");
            long attfileBo = formEntity.getLong("attfile.id");
            DynamicObject attFileVersion = (DynamicObject)attFileVersionMap.get(attfileBo);
            if (attFileVersion != null) {
                Long newAttfile = attFileVersion.getLong("id");
                if (newAttfile.equals(attfile)) continue;
                dataEntity.getDataEntity().set("attfilebasef7", (Object)newAttfile);
                dataEntity.getDataEntity().set("attfilebasef7_id", (Object)newAttfile);
                String tipsInfo = ResManager.loadKDString((String)"\u6700\u65b0\u6863\u6848\u7248\u672c\u5df2\u53d1\u751f\u53d8\u66f4", (String)"WTCBillUpdateAttfileValidator_01", (String)"wtc-wtbs-opplugin", (Object[])new Object[0]);
                if (variables != null && variables.containsKey("BILL_LIST_OP") && HRStringUtils.equals((String)((String)variables.get("BILL_LIST_OP")), (String)"BILL_LIST_OP_TRUE")) {
                    return;
                }
                this.addMessage(dataEntity, tipsInfo, ErrorLevel.Warning);
                continue;
            }
            boolean fromDatabase = dataEntity.getDataEntity().getDataEntityState().getFromDatabase();
            String tip = ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u5355\u636e%s\u7684\u6863\u6848\u6743\u9650\u3002", (String)"WTCBillUpdateAttfileValidator_02", (String)"wtc-wtbs-opplugin", (Object[])new Object[]{billNo});
            if (!fromDatabase) {
                tip = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u8be5\u6863\u6848\u3002", (String)"WTCBillSelfAttFileAuthValidator_3", (String)"wtc-wtbs-opplugin", (Object[])new Object[0]);
            }
            this.addErrorMessage(dataEntity, tip);
        }
    }
}

