/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.opplugin.web.his;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.opplugin.web.his.validator.WTCHisModelBsedValidator;

public class WTCHisModelBsedOp
extends HRDataBaseOp {
    private static final Log LOG = LogFactory.getLog(WTCHisModelBsedOp.class);
    private static final String[] HIS_MODEL_TPLS_IDS = new String[]{"254SPHWBTXT3", "254T74KD7RBB", "254ST3FJ2IE1", "254T51N+39IL", "254SW7JZAPXW", "254SYTF=F5VX"};
    private final List<String> fields = new ArrayList<String>();

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        this.checkRefHistModelFields();
        args.getFieldKeys().addAll(this.fields);
        if (!this.fields.isEmpty()) {
            args.getFieldKeys().add("bsed");
            args.getFieldKeys().addAll(this.billEntityType.getAllFields().keySet());
            args.getFieldKeys().addAll(this.billEntityType.getAllEntities().values().stream().filter(entityType -> entityType instanceof EntryType).map(entityType -> entityType.getName() + "." + "seq").collect(Collectors.toList()));
        }
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        if (Arrays.stream(HIS_MODEL_TPLS_IDS).anyMatch(metaId -> this.billEntityType.getInheritPath().contains((CharSequence)metaId))) {
            this.checkRefHistModelFields();
            args.addValidator((AbstractValidator)new WTCHisModelBsedValidator(this.fields));
        }
    }

    private void checkRefHistModelFields() {
        if (!this.fields.isEmpty()) {
            return;
        }
        for (IDataEntityProperty property : this.billEntityType.getAllFields().values()) {
            boolean isMatch;
            RefEntityType refEntityType;
            if (!(property instanceof BasedataProp) || !(((BasedataProp)property).getComplexType() instanceof RefEntityType) || !WTCStringUtils.isNotEmpty((String)(refEntityType = (RefEntityType)((BasedataProp)property).getComplexType()).getInheritPath()) || !(isMatch = Arrays.stream(HIS_MODEL_TPLS_IDS).anyMatch(metaId -> refEntityType.getInheritPath().contains((CharSequence)metaId)))) continue;
            this.fields.add(property.getName());
        }
    }
}

