/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.opplugin.web.his;

import java.util.Arrays;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.history.service.WTCSnapService;
import kd.wtc.wtbs.opplugin.web.his.validator.WTCSnapValidator;

public class WTCSnapSaveOp
extends HRDataBaseOp {
    private static final String HIS_POSTFIX = "his";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new WTCSnapValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Object[] dataEntities = e.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        String hisEntityName = dataEntities[0].getDataEntityType().getName() + HIS_POSTFIX;
        MainEntityType hisEntityType = MetadataServiceHelper.getDataEntityType((String)hisEntityName);
        HRBaseServiceHelper hisHelper = new HRBaseServiceHelper(hisEntityName);
        String operateKey = e.getOperationKey();
        this.saveData(hisEntityType, hisHelper, operateKey, (DynamicObject[])dataEntities);
    }

    private void saveData(MainEntityType hisEntityType, HRBaseServiceHelper hisHelper, String operateKey, DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        DynamicObjectCollection currentCollection = new DynamicObjectCollection();
        if (this.operateOption.containsVariable("isfromlist")) {
            HRBaseServiceHelper currentHelper = new HRBaseServiceHelper(WTCHisServiceHelper.getCurrentBoName((String)hisHelper.getEntityName()));
            DynamicObject[] dynamicObjects = currentHelper.loadDynamicObjectArray((Object[])Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).distinct().toArray(Object[]::new));
            currentCollection.addAll(Arrays.asList(dynamicObjects));
        } else {
            currentCollection.addAll(Arrays.asList(dataEntities));
        }
        WTCSnapService.snapHisSave((MainEntityType)hisEntityType, (HRBaseServiceHelper)hisHelper, (DynamicObjectCollection)currentCollection);
    }
}

