/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.opplugin.web.his.validator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.constants.WTCBaseKDString;
import kd.wtc.wtbs.common.util.WTCCollections;

public class WTCHisModelBsedValidator
extends AbstractValidator {
    private static final Log LOG = LogFactory.getLog(WTCHisModelBsedValidator.class);
    private final Set<String> hisModelFields = new LinkedHashSet<String>();

    public WTCHisModelBsedValidator() {
    }

    public WTCHisModelBsedValidator(Collection<String> hisModelFields) {
        this.hisModelFields.addAll(hisModelFields);
    }

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        if (extendedDataEntities.length <= 0 || WTCCollections.isEmpty(this.hisModelFields)) {
            return;
        }
        MainEntityType mainEntityType = (MainEntityType)extendedDataEntities[0].getDataEntity().getDataEntityType();
        Map allFields = mainEntityType.getAllFields();
        for (String hisModelField : this.hisModelFields) {
            IDataEntityProperty property = (IDataEntityProperty)allFields.get(hisModelField);
            if (!(property instanceof BasedataProp)) continue;
            this.validateHisModelBsed(mainEntityType, hisModelField, property);
        }
    }

    private void validateHisModelBsed(MainEntityType mainEntityType, String hisModelField, IDataEntityProperty property) {
        block4: {
            block3: {
                if (property.getParent() != mainEntityType) break block3;
                Set<Long> basedataIdSet = Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getDataEntity).map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)hisModelField)).collect(Collectors.toSet());
                String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                Map<Long, DynamicObject> dataDyMap = this.queryEntityData(basedataIdSet, baseEntityId);
                for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    Date bsed = dataEntity.getDate("bsed");
                    this.validateBsed(mainEntityType, hisModelField, property, dataDyMap, extendedDataEntity, dataEntity, bsed);
                }
                break block4;
            }
            if (property.getParent() == null || property.getParent().getParent() != mainEntityType) break block4;
            Set<Long> basedataIdSet = Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getDataEntity).flatMap(dy -> dy.getDynamicObjectCollection(property.getParent().getName()).stream()).map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)hisModelField)).collect(Collectors.toSet());
            String baseEntityId = ((BasedataProp)property).getBaseEntityId();
            Map<Long, DynamicObject> dataDyMap = this.queryEntityData(basedataIdSet, baseEntityId);
            for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                Date bsed = dataEntity.getDate("bsed");
                DynamicObjectCollection entryDyColl = dataEntity.getDynamicObjectCollection(property.getParent().getName());
                for (DynamicObject entryDy : entryDyColl) {
                    this.validateBsed(mainEntityType, hisModelField, property, dataDyMap, extendedDataEntity, entryDy, bsed);
                }
            }
        }
    }

    private void validateBsed(MainEntityType mainEntityType, String hisModelField, IDataEntityProperty property, Map<Long, DynamicObject> dataDyMap, ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity, Date bsed) {
        Date firstBsed;
        long baseDataId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dataEntity, (String)hisModelField);
        DynamicObject hisModelDy = dataDyMap.get(baseDataId);
        if (hisModelDy != null && (firstBsed = hisModelDy.getDate("firstbsed")) != null && bsed != null && firstBsed.compareTo(bsed) > 0) {
            String illegalBsedTip = WTCBaseKDString.getIllegalBsedTip((String)property.getDisplayName().getLocaleValue(), (String)mainEntityType.getDisplayName().getLocaleValue());
            if (dataEntity.getDataEntityType().getParent() == mainEntityType && dataEntity.getDataEntityType().getProperties().get((Object)"seq") != null) {
                illegalBsedTip = dataEntity.getDataEntityType().getDisplayName().getLocaleValue() + WTCBaseKDString.getEntryRowFmt((int)dataEntity.getInt("seq")) + illegalBsedTip;
            }
            this.addErrorMessage(extendedDataEntity, illegalBsedTip);
        }
    }

    private Map<Long, DynamicObject> queryEntityData(Set<Long> basedataIdSet, String baseEntityId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(baseEntityId);
        DynamicObjectCollection dyColl = helper.queryOriginalCollection("id,firstbsed", new QFilter[]{new QFilter("id", "in", basedataIdSet)});
        return dyColl.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (o1, o2) -> o2));
    }

    public void addHisModelFields(String ... hisModelFields) {
        this.hisModelFields.addAll(Arrays.asList(hisModelFields));
    }
}

