/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.mob.billcontainer;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.mobile.BillContainerService;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class BillContainerPlugin
extends AbstractMobFormPlugin {
    public void preOpenForm(PreOpenFormEventArgs ee) {
        super.preOpenForm(ee);
        FormShowParameter formShowParameter = ee.getFormShowParameter();
        formShowParameter.setCaption(BillContainerService.getInstance().getCaption(formShowParameter));
        if (this.unCheckRight(formShowParameter)) {
            return;
        }
        String msg = BillContainerService.getInstance().checkRight(formShowParameter);
        if (HRStringUtils.isNotEmpty((String)msg)) {
            ee.setCancelMessage(msg);
            ee.setCancel(true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillContainerService.getInstance().openBill(this.getView());
    }

    private boolean unCheckRight(FormShowParameter formShowParameter) {
        boolean unCheck = false;
        Map customParams = formShowParameter.getCustomParams();
        if (WTCMaps.isNotEmpty((Map)customParams) && "myTime".equals(formShowParameter.getCustomParam("sourceApp"))) {
            if (!(customParams.get("billpkid") instanceof String && customParams.get("billType") instanceof Integer && customParams.get("billapplyType") instanceof Integer && customParams.get("personid_cache") instanceof Long)) {
                return false;
            }
            String pkIdStr = (String)customParams.get("billpkid");
            Integer billType = (Integer)customParams.get("billType");
            Integer applyType = (Integer)customParams.get("billapplyType");
            Long currPersonId = (Long)customParams.get("personid_cache");
            if (WTCStringUtils.isEmpty((String)pkIdStr) || applyType == 0 || 0L == currPersonId) {
                return false;
            }
            DynamicObject billDy = this.getBillDy(Long.parseLong(pkIdStr), billType);
            if (billDy == null) {
                return false;
            }
            long applyPersonId = billDy.getLong("personid");
            if (applyPersonId == currPersonId) {
                unCheck = true;
            }
        }
        return unCheck && this.unCheckRightCustomParam();
    }

    private DynamicObject getBillDy(long pkId, Integer billType) {
        String entityId = this.getEntityId(billType);
        if (entityId != null) {
            HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)entityId);
            QFilter filter = new QFilter("id", "=", (Object)pkId);
            return serviceHelper.queryOriginalOne("id,creator,personid", filter.toArray());
        }
        return null;
    }

    private String getEntityId(Integer billType) {
        if (billType == null) {
            return null;
        }
        String entityId = null;
        if (1 == billType) {
            entityId = "wtam_busitripbill";
        } else if (2 == billType) {
            entityId = "wtabm_vaapply";
        } else if (3 == billType) {
            entityId = "wtom_overtimeapplybill";
        } else if (4 == billType) {
            entityId = "wtpm_supsignpc";
        } else if (5 == billType) {
            entityId = "wts_swshiftbill";
        }
        return entityId;
    }

    public boolean unCheckRightCustomParam() {
        boolean unCheckRight = false;
        String customParameter = SystemParamQueryUtil.getAppCustomParameter((String)"kd_wtc_wtss_uncheckrigth2openotherbill");
        unCheckRight = WTCStringUtils.isNotEmpty((String)customParameter) && "true".equals(customParameter);
        return unCheckRight;
    }
}

