/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.task;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskDao;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.TaskHelper;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.wtc.wtbs.business.formtask.TaskFormProcessorService;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.task.base.MainTaskDetector;
import kd.wtc.wtbs.business.task.base.MainTaskDetectorImpl;
import kd.wtc.wtbs.business.task.base.MainTaskRunLog;
import kd.wtc.wtbs.business.task.base.TaskConfig;
import kd.wtc.wtbs.business.task.base.TaskRepository;
import kd.wtc.wtbs.business.task.base.TaskRepositoryImpl;
import kd.wtc.wtbs.business.task.base.WTCBackgroundTaskSubscriber;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class TaskProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final TaskRepositoryImpl taskRepository = TaskRepositoryImpl.getInstance();
    private static final MainTaskDetector mtDetector = new MainTaskDetectorImpl((TaskRepository)taskRepository);
    private boolean canClose = false;
    private JobFormInfo jobFormInfo;

    private JobFormInfo getJobFormInfo() {
        if (this.jobFormInfo == null) {
            String str = (String)this.getView().getFormShowParameter().getCustomParam("sch_clientjobinfo");
            String string = str = str == null ? this.getPageCache().get("sch_clientjobinfo") : str;
            if (StringUtils.isBlank((CharSequence)str)) {
                return null;
            }
            this.jobFormInfo = (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
        }
        return this.jobFormInfo;
    }

    private void setJobFormInfo(JobFormInfo jobFormInfo) {
        String str = SerializationUtils.toJsonString((Object)jobFormInfo);
        this.getView().getFormShowParameter().setCustomParam("sch_clientjobinfo", (Object)str);
        this.getPageCache().put("sch_clientjobinfo", str);
    }

    private String getTaskId() {
        return this.getView().getFormShowParameter().getCustomParams().containsKey("sch_taskid") ? (String)this.getView().getFormShowParameter().getCustomParam("sch_taskid") : this.getPageCache().get("sch_taskid");
    }

    private void setTaskId(String taskId) {
        this.getPageCache().put("sch_taskid", taskId);
    }

    private boolean isStart() {
        String start = this.getPageCache().get("isstart");
        return !StringUtils.isBlank((CharSequence)start) && Boolean.parseBoolean(start);
    }

    private void setStart(boolean start) {
        this.getPageCache().put("isstart", String.valueOf(start));
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get("isfinished");
        return !StringUtils.isBlank((CharSequence)finished) && Boolean.parseBoolean(finished);
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put("isfinished", String.valueOf(finished));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btnstop", "btnmin"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.startBar();
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnstop", "btnmin"});
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            this.setProgressDesc(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u4e2d", (String)"TaskProgressPlugin_2", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
        } else {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
            bar.setPercent(progress);
            this.setProgressDesc(taskInfo.getDesc());
            JobFormInfo jobFormInfo = this.getJobFormInfo();
            if (jobFormInfo != null) {
                this.setButtonVisible(jobFormInfo);
            }
        }
    }

    public void click(EventObject e) {
        Control source = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnstop")) {
            this.stop();
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnmin")) {
            this.tranBackground();
        }
    }

    public void onProgress(ProgressEvent e) {
        String taskId = this.getTaskId();
        boolean start = this.isStart();
        this.setStart(true);
        if (!start && StringUtils.isBlank((CharSequence)taskId)) {
            String paramsStr = (String)this.getView().getFormShowParameter().getCustomParam("params");
            String category = (String)this.getView().getFormShowParameter().getCustomParam("category");
            Object params = WTCSerializationUtils.deSerializeFromBase64((String)paramsStr);
            if (null != params) {
                boolean haveParentView;
                TaskFormProcessorService processorService = TaskConfig.getProcessorService((String)category);
                processorService.beforeGenTaskForm(params);
                WTCTaskForm taskForm = processorService.genTaskForm(params);
                WTCDistributeTaskHelper.setLoginIp((WTCTaskForm)taskForm);
                IFormView parentView = this.getView().getView(this.getView().getFormShowParameter().getParentPageId());
                boolean bl = haveParentView = null != parentView && !StringUtils.isBlank((CharSequence)parentView.getPageId());
                if (haveParentView) {
                    IPageCache cache = parentView.getPageCache();
                    cache.remove("errMsg");
                    cache.remove("taskId");
                    cache.remove("warnMsg");
                    if (!StringUtils.isBlank((CharSequence)taskForm.getErrMsg())) {
                        cache.put("errMsg", taskForm.getErrMsg());
                        this.getView().close();
                        return;
                    }
                    cache.put("taskId", String.valueOf(taskForm.getTaskRequest().getTaskId()));
                    cache.put("warnMsg", String.valueOf(taskForm.getWarnMsg()));
                }
                this.jobFormInfo = WTCDistributeTaskHelper.genJobInfo((WTCTaskForm)taskForm, (IFormView)this.getView());
                long mtId = WTCDistributeTaskHelper.saveTask((Map)this.jobFormInfo.getJobInfo().getParams());
                if (mtId == 0L) {
                    String errMsg = processorService.onStartDistributeFailed(params, taskForm);
                    if (errMsg != null && haveParentView) {
                        IPageCache cache = parentView.getPageCache();
                        cache.put("errMsg", errMsg);
                    } else {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u4efb\u52a1\u542f\u52a8\u5931\u8d25\u3002", (String)"TaskProgressPlugin_1", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
                    }
                    this.getView().close();
                    return;
                }
                this.getPageCache().put("mtId", String.valueOf(mtId));
                this.dispatchTask();
                this.setJobFormInfo(this.jobFormInfo);
                processorService.afterGenTaskForm((Object)taskForm);
                processorService.afterGenTaskForm((Object)taskForm, this.getView());
            }
        } else if (!StringUtils.isBlank((CharSequence)taskId)) {
            long mtId;
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            String mtIdStr = this.getPageCache().get("mtId");
            long l = mtId = WTCStringUtils.isEmpty((String)mtIdStr) ? 0L : Long.parseLong(mtIdStr);
            if (mtId == 0L) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4efb\u52a1\u542f\u52a8\u5931\u8d25\u3002", (String)"TaskProgressPlugin_1", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
                this.getView().close();
                return;
            }
            if (mtDetector.isEnd(mtId)) {
                taskInfo.setProgress(100);
                if (!taskInfo.isTaskEnd()) {
                    taskInfo.setStatus("COMPLETED");
                }
                MainTaskRunLog mainTaskRunLog = taskRepository.loadEffectiveMTRL(mtId);
                Map reportData = null;
                if (WTCStringUtils.isNotEmpty((String)mainTaskRunLog.getReportData())) {
                    reportData = (Map)WTCSerializationUtils.deSerializeFromBase64((String)mainTaskRunLog.getReportData());
                    taskInfo.setData(WTCSerializationUtils.toJsonString((Object)reportData));
                }
                TaskDao taskDao = ScheduleService.getInstance().getObjectFactory().getTaskDao();
                taskDao.updateProgress(taskId, taskInfo.getProgress(), taskInfo.getDesc(), reportData);
                taskDao.updateCustomData(taskId, reportData);
                taskDao.updateStatus(taskId, taskInfo.getStatus());
                this.complete(taskInfo, e);
            } else {
                TaskDao taskDao;
                int progress = mtDetector.getProgress(mtId);
                int n = progress >= 100 ? 99 : (progress = progress > 0 ? progress : 1);
                if (taskInfo.isTaskEnd()) {
                    taskDao = ScheduleService.getInstance().getObjectFactory().getTaskDao();
                    taskDao.updateStatus(taskId, "SCHEDULED");
                    taskDao.updateStatus(taskId, "BEGIN");
                    taskDao.updateProgress(taskId, progress);
                    taskInfo.setStatus("BEGIN");
                }
                if (TaskHelper.isStop((String)this.getTaskId()) && !mtDetector.isStop(mtId)) {
                    WTCDistributeTaskHelper.terminateTask((long)mtId);
                    taskDao = ScheduleService.getInstance().getObjectFactory().getTaskDao();
                    taskDao.updateProgress(taskId, taskInfo.getProgress(), ResManager.loadKDString((String)"\u4efb\u52a1\u7ec8\u6b62\u4e2d", (String)"TaskProgressPlugin_3", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]), null);
                    taskInfo.setDesc(ResManager.loadKDString((String)"\u4efb\u52a1\u7ec8\u6b62\u4e2d", (String)"TaskProgressPlugin_3", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
                }
                String desc = taskInfo.getDesc();
                e.setProgress(progress);
                if (StringUtils.isNotBlank((CharSequence)desc)) {
                    this.setProgressDesc(desc);
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String taskId;
        JobFormInfo jobFormInfo;
        super.beforeClosed(e);
        if (!this.isStart()) {
            e.setCancel(true);
        } else if (!(this.canClose || this.isFinished() || (jobFormInfo = this.getJobFormInfo()) == null || StringUtils.isBlank((CharSequence)(taskId = this.getTaskId())))) {
            if (jobFormInfo.isCanStop()) {
                this.stop();
                e.setCancel(true);
            } else if (jobFormInfo.isCanBackground()) {
                this.tranBackground();
                e.setCancel(true);
            } else {
                e.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getResult() != MessageBoxResult.Yes) {
            this.startBar();
        } else if (StringUtils.equals((CharSequence)evt.getCallBackId(), (CharSequence)"continue_background")) {
            this.doTranBackground();
        } else {
            this.doStop();
        }
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.stop();
    }

    private void closeForm() {
        this.canClose = true;
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (jobFormInfo != null) {
            if (StringUtils.isBlank((CharSequence)jobFormInfo.getJobInfo().getAppId())) {
                jobFormInfo.getJobInfo().setAppId(this.getView().getFormShowParameter().getServiceAppId());
            }
            String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
            this.setTaskId(taskId);
            this.setButtonVisible(jobFormInfo);
        }
    }

    private void complete(TaskInfo taskInfo, ProgressEvent e) {
        boolean isFinished = this.isFinished();
        this.setFinished(true);
        if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
            if (TaskProgressPlugin.isShowStackTrace()) {
                this.getView().showErrMessage(taskInfo.getFailureReason(), "");
            } else {
                String errMsg = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u51fa\u9519\uff0c\u8be6\u60c5\u8bf7\u67e5\u9605\u65e5\u5fd7", (String)"TaskProgressPlugin_5", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errMsg);
            }
            this.stopBar();
        } else if (!isFinished) {
            e.setProgress(99);
            this.setProgressDesc(this.getEndMsg());
        } else {
            this.setProgressDesc(this.getEndMsg());
            this.returnResult(null);
            if (StringUtils.equalsIgnoreCase((CharSequence)"COMPLETED", (CharSequence)taskInfo.getStatus())) {
                long mtId;
                String mtIdStr = this.getPageCache().get("mtId");
                long l = mtId = WTCStringUtils.isEmpty((String)mtIdStr) ? 0L : Long.parseLong(mtIdStr);
                if (mtId == 0L) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4efb\u52a1\u542f\u52a8\u5931\u8d25\u3002", (String)"TaskProgressPlugin_1", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
                    this.getView().close();
                    return;
                }
                MainTaskRunLog mainTaskRunLog = taskRepository.loadEffectiveMTRL(mtId);
                if (WTCStringUtils.isNotEmpty((String)mainTaskRunLog.getReportData())) {
                    Map data = (Map)WTCSerializationUtils.deSerializeFromBase64((String)mainTaskRunLog.getReportData());
                    taskInfo.setData(WTCSerializationUtils.toJsonString((Object)data));
                }
                this.returnResult(taskInfo);
            }
            this.stopBar();
            e.setProgress(100);
            this.closeForm();
        }
    }

    private String getEndMsg() {
        long mtId;
        String mtIdStr = this.getPageCache().get("mtId");
        long l = mtId = WTCStringUtils.isEmpty((String)mtIdStr) ? 0L : Long.parseLong(mtIdStr);
        if (WTCDistributeTaskHelper.isTerminated((long)mtId)) {
            return ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ec8\u6b62\u3002", (String)"TaskProgressPlugin_0", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5", (String)"TaskProgressPlugin_6", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]);
    }

    private void stop() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_stop", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u6267\u884c", (String)"TaskProgressPlugin_7", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ec8\u6b62\u6267\u884c", (String)"TaskProgressPlugin_8", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u8fd8\u6ca1\u6709\u6267\u884c\u5b8c\u6bd5\uff0c\u60a8\u662f\u5426\u786e\u8ba4\u8981\u7ec8\u6b62\u6267\u884c\uff1f", (String)"TaskProgressPlugin_9", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        this.stopBar();
    }

    private void doStop() {
        this.startBar();
        String taskId = this.getTaskId();
        if (!StringUtils.isBlank((CharSequence)taskId)) {
            ScheduleServiceHelper.stopTask((String)taskId);
            TaskClientProxy.suspend((JobFormInfo)this.jobFormInfo, (String)taskId);
        }
    }

    private void tranBackground() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_background", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TaskProgressPlugin_10", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u540e\u53f0\u6267\u884c", (String)"TaskProgressPlugin_11", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u8fd8\u6ca1\u6709\u6267\u884c\u5b8c\u6bd5\uff0c\u60a8\u662f\u5426\u786e\u8ba4\u8981\u8f6c\u5165\u540e\u53f0\u6267\u884c\uff1f", (String)"TaskProgressPlugin_12", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        this.stopBar();
    }

    private void doTranBackground() {
        this.closeForm();
        String taskId = this.getTaskId();
        if (!StringUtils.isBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (!TaskClientProxy.isExistTask((String)taskId)) {
                long mtId;
                String mtIdStr = this.getPageCache().get("mtId");
                long l = mtId = WTCStringUtils.isEmpty((String)mtIdStr) ? 0L : Long.parseLong(mtIdStr);
                if (mtId != 0L) {
                    TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)this.getJobFormInfo(), (TaskInfo)taskInfo);
                    WTCBackgroundTaskSubscriber subscriber = new WTCBackgroundTaskSubscriber(mtId, RequestContext.get(), this.getJobFormInfo(), taskId);
                    ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
                }
            }
        }
    }

    private void setProgressDesc(String desc) {
        Label lblDesc = (Label)this.getControl("lblprogress");
        lblDesc.setText(desc);
    }

    private void setButtonVisible(JobFormInfo jobFormInfo) {
        if (jobFormInfo.isCanStop()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnstop"});
        }
        if (jobFormInfo.isCanBackground()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnmin"});
        }
    }

    private void returnResult(TaskInfo taskInfo) {
        Map<String, String> result = TaskProgressPlugin.packageReturnResult(taskInfo);
        if (result != null) {
            this.getView().returnDataToParent(result);
        }
    }

    public static Map<String, String> packageReturnResult(TaskInfo taskInfo) {
        if (taskInfo == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (taskInfo != null) {
            String taskInfoStr = SerializationUtils.toJsonString((Object)taskInfo);
            result.put("taskinfo", taskInfoStr);
            result.put("taskend", String.valueOf(taskInfo.isTaskEnd()));
        }
        return result;
    }

    private static boolean isShowStackTrace() {
        Object isShowStackTrace;
        String showStackTrace = System.getProperty("exception_showstacktrace");
        if (showStackTrace != null && "true".equals(showStackTrace)) {
            return true;
        }
        Map cache = SystemParamServiceHelper.loadPublicParametersFromCache();
        if (cache != null && cache.size() > 0 && (isShowStackTrace = cache.get("showstacktrace")) != null) {
            return (Boolean)isShowStackTrace;
        }
        return false;
    }
}

