/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.util;

import java.io.IOException;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.AutoReleaseLock;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.wtc.wtbs.common.constants.WTCBaseKDString;
import kd.wtc.wtbs.common.model.bill.BillSystemParamRange;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class WTCBillViewUtils {
    private static final Log LOG = LogFactory.getLog(WTCBillViewUtils.class);

    public static Tuple<Boolean, String> dateCheckSuccess(BillSystemParamRange range, Date startDate, Date endDate) {
        if (range == null || startDate == null || endDate == null) {
            return Tuple.of((Object)Boolean.TRUE, (Object)"");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        switch (range.getUnit()) {
            case "year": {
                calendar.add(1, range.getRange());
                break;
            }
            case "month": {
                calendar.add(2, range.getRange());
                break;
            }
            case "day": {
                calendar.add(6, range.getRange());
                break;
            }
        }
        boolean success = !WTCDateUtils.addDays((Date)endDate, (int)0).after(calendar.getTime());
        String unit = null;
        if (!success) {
            switch (range.getUnit()) {
                case "year": {
                    unit = ResManager.loadKDString((String)"\u5e74", (String)"WTCBillViewUtils_0", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "month": {
                    unit = ResManager.loadKDString((String)"\u4e2a\u6708", (String)"WTCBillViewUtils_1", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "day": {
                    unit = ResManager.loadKDString((String)"\u65e5", (String)"WTCBillViewUtils_2", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]);
                    break;
                }
                default: {
                    unit = "";
                }
            }
        }
        return Tuple.of((Object)success, (Object)(success ? "" : String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6700\u5927\u53ef\u67e5\u8be2\u65e5\u671f\u8303\u56f4\u4e3a%1$s\u3002", (String)"WTCBillViewUtils_3", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]), range.getRange() + unit)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean requireMutex(String pkId, String entityNumber, String opNumber, StringBuilder errMsg) {
        try (DataMutex dataMutex = DataMutex.create();){
            MutexLockInfo mutexLockInfo = new MutexLockInfo();
            mutexLockInfo.setDataObjId(pkId);
            mutexLockInfo.setGroupId(opNumber);
            mutexLockInfo.setEntityNumber(entityNumber);
            mutexLockInfo.setOperationKey(opNumber);
            boolean require = dataMutex.require(mutexLockInfo);
            if (!require) {
                Map lockInfo = dataMutex.getLockInfo(mutexLockInfo.getDataObjId(), opNumber, mutexLockInfo.getEntityNumber());
                if (lockInfo == null) {
                    boolean bl = false;
                    return bl;
                }
                String userId = (String)lockInfo.get("userid");
                DynamicObject userDy = UserServiceHelper.getUserInfoByID((Long)Long.valueOf(userId), (String)"name");
                AbstractOperate operate = (AbstractOperate)FormMetadataCache.getFormOperation((String)entityNumber, (String)opNumber);
                errMsg.append(String.format(WTCBaseKDString.getDataMutexTip(), userDy.getString("name"), operate.getOperateName().getLocaleValue()));
                return require;
            }
            AutoReleaseLock.create().register(pkId, entityNumber, opNumber);
            return require;
        }
        catch (IOException ex) {
            LOG.error("WTCBillViewUtils.requireMutex.error");
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fe1\u606f\u9501\u5b9a\u5931\u8d25", (String)"WTCBillViewUtils_4", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
        }
    }

    public static void setEntryCellVisible(IFormView fromView, String parentFlexKey, String entryKey, Map<String, List<Integer>> colKeyRowMap) {
        String csStyleFmt = "{\"type\":0,\"content\":\"%s\"}";
        HashMap csStyleMap = Maps.newHashMapWithExpectedSize((int)1);
        StringBuilder rowViSb = new StringBuilder();
        for (Map.Entry<String, List<Integer>> colKeyRow : colKeyRowMap.entrySet()) {
            if (colKeyRow.getValue() == null) continue;
            for (int row : colKeyRow.getValue()) {
                rowViSb.append(String.format("$ #%s tr[data-rowindex=\\\"%d\\\"] td[data-code=\\\"%s\\\"] > div {display:none;}", entryKey, row, colKeyRow.getKey()));
            }
        }
        csStyleMap.put("cstyles", Base64.getEncoder().encodeToString(String.format(Locale.ROOT, csStyleFmt, rowViSb).getBytes()));
        fromView.updateControlMetadata(parentFlexKey, (Map)csStyleMap);
    }
}

