/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.Tips;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.TipsSupport;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListGridView;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.filter.FilterContainerAp;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.business.prompt.PromptService;
import kd.wtc.wtbs.business.util.WtcNumericalUtil;
import kd.wtc.wtbs.common.enums.WTCCommonMessages;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.formplugin.web.prompt.PromptCache;

public class WTCFormUtils {
    private WTCFormUtils() {
    }

    public static String getFormId(IFormView view) {
        return view.getFormShowParameter().getFormId();
    }

    public static BaseShowParameter getBaseShowParameter(String formId, Object pkId, ShowType showType, OperationStatus status) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId(formId);
        parameter.setPkId(pkId);
        parameter.getOpenStyle().setShowType(showType);
        parameter.setStatus(status);
        return parameter;
    }

    public static ListShowParameter getListShowParameter(String formId, ShowType showType) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(formId);
        parameter.getOpenStyle().setShowType(showType);
        return parameter;
    }

    public static void showDetailView(IFormView view, String formId, Object pkId) {
        BaseShowParameter parameter = WTCFormUtils.getBaseShowParameter(formId, pkId, ShowType.MainNewTabPage, OperationStatus.VIEW);
        String key = formId + "_pageid_" + pkId;
        String pageId = view.getPageCache().get(key);
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            parameter.setPageId(pageId);
        } else {
            view.getPageCache().put(key, parameter.getPageId());
        }
        view.showForm((FormShowParameter)parameter);
    }

    public static void showAddEntryF7ListBsed(AbstractFormPlugin plugin, BeforeDoOperationEventArgs args, String baseDataField) {
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (!"addentry".equals(key)) {
            return;
        }
        IFormView view = plugin.getView();
        IDataModel model = view.getModel();
        Object date = model.getValue("bsed");
        if (date == null) {
            view.showTipNotification(WTCCommonMessages.BSED_EMPTY.load());
            args.setCancel(true);
            return;
        }
        ListFilterParameter filter = new ListFilterParameter();
        filter.setFilter(new QFilter("firstbsed", "<=", date));
        WTCFormUtils.showAddEntryF7List(plugin, baseDataField, filter);
    }

    public static ListShowParameter getListShowParameterAddEntry(AbstractFormPlugin plugin, String baseDataField, ListFilterParameter filter, Map<String, Object> customParams) {
        IFormView view = plugin.getView();
        BasedataEdit edit = (BasedataEdit)view.getControl(baseDataField);
        BasedataProp prop = (BasedataProp)edit.getProperty();
        String formId = prop.getBaseEntityId();
        ListShowParameter parameter = WTCFormUtils.getListShowParameter(formId, ShowType.Modal);
        parameter.setFormId("bos_listf7");
        if (WTCMaps.isNotEmpty(customParams)) {
            parameter.setCustomParams(customParams);
        }
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("580");
        styleCss.setWidth("960");
        parameter.getOpenStyle().setInlineStyleCss(styleCss);
        parameter.setLookUp(true);
        parameter.setShowTitle(false);
        parameter.setMultiSelect(true);
        parameter.setSelectedRows((Object[])WTCFormUtils.getChosenIds(view, baseDataField));
        if (filter != null) {
            parameter.setListFilterParameter(filter);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "addentry"));
        parameter.setHasRight(true);
        return parameter;
    }

    public static void showAddEntryF7ListFiltered(AbstractFormPlugin plugin, String baseDataField, List<QFilter> qFilters) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1").and("status", "=", (Object)"C");
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{qFilter});
        if (!CollectionUtils.isEmpty(qFilters)) {
            filters.addAll(qFilters);
        }
        ListFilterParameter filter = new ListFilterParameter((List)filters, null);
        long orgId = plugin.getView().getModel().getDataEntity().getLong("createorg.id");
        ListShowParameter parameter = WTCFormUtils.getListShowParameterAddEntry(plugin, baseDataField, filter, null);
        parameter.setUseOrgId(orgId);
        plugin.getView().showForm((FormShowParameter)parameter);
    }

    public static void showAddEntryF7List(AbstractFormPlugin plugin, String baseDataField, ListFilterParameter filter) {
        ListShowParameter parameter = WTCFormUtils.getListShowParameterAddEntry(plugin, baseDataField, filter, null);
        plugin.getView().showForm((FormShowParameter)parameter);
    }

    public static List<Long> getChosenIds(IDataModel model, String keyEntryEntity, String baseDataField) {
        return model.getEntryEntity(keyEntryEntity).stream().filter(dy -> dy.get(baseDataField) != null).map(dy -> dy.getDynamicObject(baseDataField).getLong("id")).collect(Collectors.toList());
    }

    public static Long[] getChosenIds(IFormView view, String baseDataField) {
        IDataModel model = view.getModel();
        String entryKey = ((BasedataEdit)view.getControl(baseDataField)).getProperty().getParent().getName();
        return (Long[])model.getEntryEntity(entryKey).stream().filter(dy -> dy.get(baseDataField) != null).map(dy -> dy.getDynamicObject(baseDataField).getLong("id")).toArray(Long[]::new);
    }

    public static void setSelectedRows(IFormView view, String baseDataField, ListSelectedRowCollection selectedRows) {
        IDataModel model = view.getModel();
        model.beginInit();
        String entryKey = ((BasedataEdit)view.getControl(baseDataField)).getProperty().getParent().getName();
        DynamicObjectCollection entity = model.getEntryEntity(entryKey);
        if (entity.size() > selectedRows.size()) {
            model.deleteEntryRows(entryKey, IntStream.range(selectedRows.size(), entity.size()).toArray());
        } else if (entity.size() < selectedRows.size()) {
            model.batchCreateNewEntryRow(entryKey, selectedRows.size() - entity.size());
        }
        for (int i = 0; i < selectedRows.size(); ++i) {
            model.setValue(baseDataField, selectedRows.get(i).getPrimaryKeyValue(), i);
        }
        model.endInit();
        view.updateView(entryKey);
    }

    public static void addEntryClosedCallBack(IFormView view, String baseDataField, ClosedCallBackEvent event) {
        if (!"addentry".equals(event.getActionId())) {
            return;
        }
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)event.getReturnData();
        if (WTCCollections.isNotEmpty((Collection)returnData)) {
            WTCFormUtils.setSelectedRows(view, baseDataField, returnData);
        }
    }

    public static void beforeF7SelectBsed(AbstractFormPlugin plugin, BeforeF7SelectEvent event, String baseDataField) {
        String key = ((Control)event.getSource()).getKey();
        if (!StringUtils.equals((CharSequence)baseDataField, (CharSequence)key)) {
            return;
        }
        IFormView view = plugin.getView();
        Object date = view.getModel().getValue("bsed");
        if (date == null) {
            view.showTipNotification(WTCCommonMessages.BSED_EMPTY.load());
            event.setCancel(true);
            return;
        }
        List<QFilter> filters = Arrays.asList(new QFilter("id", "not in", (Object)WTCFormUtils.getChosenIds(view, baseDataField)), new QFilter("firstbsed", "<=", date));
        event.setCustomQFilters(filters);
    }

    public static String getEntityId(String formId) {
        return MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
    }

    public static FormMetadata getFormMetaData(String formId) {
        return (FormMetadata)MetadataDao.readRuntimeMeta((String)WTCFormUtils.getEntityId(formId), (MetaCategory)MetaCategory.Form);
    }

    public static FormMetadata getListMetaData(String formId) {
        return ((BillFormAp)((FormMetadata)MetadataDao.readRuntimeMeta((String)WTCFormUtils.getEntityId(formId), (MetaCategory)MetaCategory.Form)).getRootAp()).getListMeta();
    }

    public static Tips getTips(IFormView view, String controlKey) {
        String prompt = PromptCache.getPrompt(view, controlKey);
        if (StringUtils.isNotBlank((CharSequence)prompt)) {
            return WTCFormUtils.newTips(prompt, null);
        }
        List promptList = PromptService.queryPromptForString((String)WTCFormUtils.getFormId(view), (String)controlKey, (DynamicObject)view.getModel().getDataEntity());
        if (WTCCollections.isNotEmpty((Collection)promptList)) {
            prompt = (String)promptList.get(0);
            PromptCache.put(view, controlKey, prompt);
            return WTCFormUtils.newTips(prompt, null);
        }
        return null;
    }

    public static Tips newTips(String prompt, Tips defaultTips) {
        if (defaultTips == null) {
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(prompt));
            return tips;
        }
        if (HRStringUtils.isNotEmpty((String)prompt)) {
            defaultTips.setContent(new LocaleString(prompt));
        }
        return defaultTips;
    }

    public static void setTips(IFormView view) {
        Map<String, String> promptMap = WTCFormUtils.getPromptMap(view);
        WTCFormUtils.setTips(view, promptMap);
    }

    public static void setTips(IFormView source, IFormView target) {
        Map<String, String> promptMap = WTCFormUtils.getPromptMap(source);
        WTCFormUtils.setTips(target, promptMap);
    }

    public static void setTips(IFormView view, String source) {
        Map<String, String> promptMap = WTCFormUtils.getPromptMap(view, WTCFormUtils.createControlMap(source), null, null, null, null);
        WTCFormUtils.setTips(view, promptMap);
    }

    public static Map<String, String> getPromptMap(IFormView view) {
        return WTCFormUtils.getPromptMap(view, null, null, null, null, null);
    }

    public static Map<String, String> getPromptMap(IFormView view, Map<String, Set<String>> controlMap, Map<String, DynamicObject> dataMap, Map<String, Map<String, String>> keyMap, Boolean richText, Boolean queryApi) {
        PromptCache cache = PromptCache.get(view);
        Map<String, String> promptMap = cache.getPromptMap();
        if (promptMap.isEmpty() || Boolean.TRUE.equals(queryApi)) {
            Map<String, Set<String>> controlMap2 = WTCMaps.isEmpty(controlMap) ? WTCFormUtils.createControlMap(WTCFormUtils.getFormId(view)) : controlMap;
            Map<String, DynamicObject> dataModelMap = WTCMaps.isEmpty(dataMap) ? WTCFormUtils.createDataModelMap(view) : dataMap;
            Map resp = Boolean.TRUE.equals(richText) ? PromptService.batchQueryPromptContent(controlMap2, dataModelMap) : PromptService.batchQueryPromptForString(controlMap2, dataModelMap);
            if (WTCMaps.isEmpty((Map)resp)) {
                return promptMap;
            }
            resp.forEach((formId, pagePrompts) -> WTCFormUtils.setPromptMap(view, promptMap, pagePrompts, formId, keyMap));
            PromptCache.put(view, cache);
        }
        return promptMap;
    }

    public static Map<String, Set<String>> createControlMap(String ... formIds) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)formIds.length);
        for (String id : formIds) {
            map.put(id, Sets.newHashSet());
        }
        return map;
    }

    private static Map<String, DynamicObject> createDataModelMap(IFormView view) {
        return Collections.singletonMap(view.getFormShowParameter().getFormId(), view.getModel().getDataEntity());
    }

    private static void setPromptMap(IFormView view, Map<String, String> promptMap, Map<String, Set<String>> pagePrompts, String sourceId, Map<String, Map<String, String>> keyMap) {
        Map<String, String> formKeyMap;
        if (WTCMaps.isEmpty(pagePrompts)) {
            return;
        }
        Map<String, String> map = formKeyMap = WTCMaps.isEmpty(keyMap) ? null : keyMap.get(sourceId);
        if (null == formKeyMap || formKeyMap.isEmpty()) {
            pagePrompts.forEach((key, value) -> {
                Iterator it = value.iterator();
                if (it.hasNext()) {
                    promptMap.put((String)key, (String)it.next());
                }
            });
        } else {
            formKeyMap.forEach((key, value) -> {
                Set tips = (Set)pagePrompts.get(value);
                if (!CollectionUtils.isEmpty((Collection)tips) && tips.iterator().hasNext()) {
                    promptMap.put((String)key, (String)tips.iterator().next());
                }
            });
        }
        if (view instanceof ListView) {
            promptMap.keySet().removeIf(key -> !StringUtils.startsWith((CharSequence)key, (CharSequence)"list_"));
            new HashSet<String>(promptMap.keySet()).forEach(key -> {
                String cfr_ignored_0 = (String)promptMap.put(StringUtils.substringAfter((String)key, (String)"list_"), (String)promptMap.get(key));
            });
            promptMap.keySet().removeIf(key -> StringUtils.startsWith((CharSequence)key, (CharSequence)"list_"));
        }
    }

    public static void setTips(IFormView view, Map<String, String> promptMap) {
        if (WTCMaps.isEmpty(promptMap)) {
            return;
        }
        Map<String, Tips> pageTips = WTCFormUtils.getPageTips(view);
        for (Map.Entry<String, String> entry : promptMap.entrySet()) {
            Control control = view.getControl(entry.getKey());
            if (!(control instanceof TipsSupport)) continue;
            Tips tips = WTCFormUtils.newTips(entry.getValue(), pageTips.get(entry.getKey()));
            if (control instanceof AdvContainer) {
                WTCFormUtils.setAdvContainerTips(view, entry.getKey(), tips);
                continue;
            }
            ((TipsSupport)control).addTips(tips);
        }
        if (view instanceof IListView) {
            WTCFormUtils.setGridViewTips(view, promptMap, pageTips);
        }
    }

    public static void setAdvContainerTips(IFormView view, String controlKey, Tips tips) {
        HashMap<String, Object> tipsMap = new HashMap<String, Object>();
        tipsMap.put("type", tips.getType());
        LocaleString content = tips.getContent();
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put(Lang.get().getLocale().toString(), content.getLocaleValue());
        tipsMap.put("content", contentMap);
        tipsMap.put("iconClassName", tips.getIconClassName());
        tipsMap.put("triggerType", tips.getTriggerType());
        tipsMap.put("place", tips.getPlace());
        tipsMap.put("showIcon", tips.isShowIcon());
        HashMap<String, HashMap<String, Object>> fieldMap = new HashMap<String, HashMap<String, Object>>();
        fieldMap.put("tips", tipsMap);
        view.updateControlMetadata(controlKey, fieldMap);
    }

    private static void setGridViewTips(IFormView view, Map<String, String> promptMap, Map<String, Tips> pageTips) {
        Control gridView = view.getControl("gridview");
        if (!(gridView instanceof ListGridView)) {
            return;
        }
        Map<String, ListColumn> columnMap = ((ListGridView)gridView).getItems().stream().filter(col -> col instanceof ListColumn).collect(Collectors.toMap(col -> ((ListColumn)col).getListFieldKey(), col -> (ListColumn)col));
        for (Map.Entry<String, String> entry : promptMap.entrySet()) {
            ListColumn column = columnMap.get(entry.getKey());
            if (column == null) continue;
            Tips defaultTips = pageTips.get(entry.getKey());
            String prompt = entry.getValue();
            if (defaultTips == null && WTCStringUtils.isEmpty((String)prompt)) continue;
            Tips tips = WTCFormUtils.newTips(prompt, defaultTips);
            column.setCtlTips(tips);
        }
    }

    public static Map<String, List<String>> getEntryEntityMap(IFormView view) {
        PromptCache cache = PromptCache.get(view);
        Map<String, List<String>> map = cache.getEntryEntityMap();
        if (!map.isEmpty()) {
            return cache.getEntryEntityMap();
        }
        FormMetadata formMetaData = WTCFormUtils.getFormMetaData(WTCFormUtils.getFormId(view));
        if (formMetaData == null) {
            return map;
        }
        List collect = formMetaData.getItems().stream().filter(ap -> ap instanceof EntryAp).map(ap -> (EntryAp)ap).collect(Collectors.toList());
        for (EntryAp entryAp : collect) {
            EntryGrid entryGrid;
            List list;
            String key = entryAp.getKey();
            Control control = view.getControl(key);
            if (!(control instanceof EntryGrid) || CollectionUtils.isEmpty(list = (entryGrid = (EntryGrid)control).getControls().stream().filter(con -> con instanceof TipsSupport).map(Control::getKey).collect(Collectors.toList()))) continue;
            map.put(key, list);
        }
        PromptCache.put(view, cache);
        return map;
    }

    public static void setEntryTips(IFormView view, Map<String, List<String>> entryFieldApMap, Map<String, String> promptMap) {
        for (Map.Entry<String, List<String>> entry : entryFieldApMap.entrySet()) {
            String entryKey = entry.getKey();
            List<String> entryFields = entry.getValue();
            for (String field : entryFields) {
                String prompt = promptMap.get(field);
                if (StringUtils.isEmpty((CharSequence)prompt)) continue;
                EntryGrid entryGrid = (EntryGrid)view.getControl(entryKey);
                HashMap<String, String> content = new HashMap<String, String>(16);
                content.put(Lang.get().getLocale().toString(), prompt);
                HashMap<String, Object> tips = new HashMap<String, Object>(16);
                tips.put("type", "text");
                tips.put("content", content);
                tips.put("link", false);
                tips.put("showIcon", true);
                tips.put("triggerType", "hover");
                tips.put("isConfirm", false);
                entryGrid.setColumnProperty(field, "tips", tips);
            }
        }
    }

    public static Map<String, Tips> getPageTips(IFormView view) {
        PromptCache cache = PromptCache.get(view);
        Map<String, Tips> pageTips = cache.getPageTips();
        if (pageTips.isEmpty()) {
            ArrayList controlAps = new ArrayList();
            if (view instanceof IListView) {
                FormMetadata listMetaData = WTCFormUtils.getListMetaData(((IListView)view).getBillFormId());
                controlAps.addAll(listMetaData.getItems());
            } else {
                FormMetadata formMetaData = WTCFormUtils.getFormMetaData(WTCFormUtils.getFormId(view));
                if (formMetaData != null) {
                    controlAps.addAll(formMetaData.getItems());
                }
            }
            for (ControlAp ap : controlAps) {
                try {
                    Method method = ap.getClass().getMethod("getCtlTips", new Class[0]);
                    Object tips = method.invoke((Object)ap, new Object[0]);
                    if (!(tips instanceof Tips)) continue;
                    String tipsName = ap instanceof FilterContainerAp ? "filtercontainerap" : (ap instanceof ListColumnAp ? ((ListColumnAp)ap).getListFieldId() : ap.getKey());
                    pageTips.put(tipsName, (Tips)tips);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {}
            }
            PromptCache.put(view, cache);
        }
        return pageTips;
    }

    public static FieldTip newFieldTip(String fieldKey, String tips) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setFieldKey(fieldKey);
        fieldTip.setLevel(FieldTip.FieldTipsLevel.Error);
        fieldTip.setTip(tips);
        fieldTip.setTipsType(FieldTip.FieldTipsTypes.notNull);
        DeleteRule deleteRule2 = new DeleteRule();
        deleteRule2.setAction("isChange");
        deleteRule2.setFields(Collections.singletonList(fieldKey));
        fieldTip.setDeleteRule(deleteRule2);
        return fieldTip;
    }

    public static void showFieldTips(IFormView view, String tips, String ... fieldKeys) {
        if (ArrayUtils.isEmpty((Object[])fieldKeys)) {
            return;
        }
        for (String key : fieldKeys) {
            FieldTip fieldTip = WTCFormUtils.newFieldTip(key, tips);
            view.showFieldTip(fieldTip);
        }
    }

    public static void showFieldEmptyWarning(IFormView view, String ... fieldKeys) {
        IDataModel model = view.getModel();
        String[] emptyKeys = (String[])Stream.of(fieldKeys).filter(key -> {
            Object value = model.getValue(key);
            return value instanceof String ? StringUtils.isBlank((CharSequence)((CharSequence)value)) : value == null;
        }).toArray(String[]::new);
        WTCFormUtils.showFieldTips(view, WTCCommonMessages.NON_NULL.load(), emptyKeys);
    }

    public static void hideFieldTips(IFormView view, String ... fieldKeys) {
        if (ArrayUtils.isEmpty((Object[])fieldKeys)) {
            return;
        }
        for (String key : fieldKeys) {
            FieldTip fieldTip = new FieldTip();
            fieldTip.setFieldKey(key);
            fieldTip.setSuccess(true);
            view.showFieldTip(fieldTip);
        }
    }

    public static boolean isSave(String key) {
        return StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{"save", "saveandnew", "submit", "submitandaudit", "confirmchangenoaudit", "confirmchange"});
    }

    public static boolean isSave(BeforeDoOperationEventArgs args) {
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{"save", "confirmchange"})) {
            return Boolean.parseBoolean((String)((AbstractOperate)args.getSource()).getOption().getVariables().get("opfromformedit"));
        }
        return WTCFormUtils.isSave(key);
    }

    public static String getComboValue(IFormView view, String fieldName, int index) {
        IDataEntityProperty prop = (IDataEntityProperty)view.getModel().getDataEntityType().getAllFields().get(fieldName);
        if (prop instanceof ComboProp) {
            return ((ValueMapItem)((ComboProp)prop).getComboItems().get(index)).getValue();
        }
        return null;
    }

    public static List<DynamicObject> getMulBaseData(IDataModel model, String controlKey) {
        return model.getDataEntity().getDynamicObjectCollection(controlKey).stream().map(item -> item.getDynamicObject("fbasedataid")).collect(Collectors.toList());
    }

    public static void lockCondition(IFormView view, String controlKey) {
        TargetCondition condition = (TargetCondition)view.getControl(controlKey);
        String pageState = WTCHisService.isLock((IFormView)view) ? "view" : "edit";
        condition.setPageState(pageState);
    }

    public static void lockRadioFields(IFormView view, String[] keys) {
        HashMap map = Maps.newHashMap();
        map.put("l", 7);
        for (String con : keys) {
            view.updateControlMetadata(con, (Map)map);
        }
    }

    public static void showIllegalNumTipAndClean(IFormView formView, String key, BigDecimal min, BigDecimal max, boolean containMin, boolean containMax, BigDecimal verifyVal) {
        String errorInfo = WtcNumericalUtil.verifyIllegalNum((BigDecimal)min, (BigDecimal)max, (boolean)containMin, (boolean)containMax, (BigDecimal)verifyVal, (String)"");
        if (formView != null && HRStringUtils.isNotEmpty((String)errorInfo)) {
            formView.showTipNotification(errorInfo);
            formView.getModel().setValue(key, null);
        }
    }
}

